/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.tracereferences;

import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.Keep;
import com.android.tools.r8.diagnostic.DefinitionContext;
import com.android.tools.r8.diagnostic.MissingDefinitionsDiagnostic;
import com.android.tools.r8.diagnostic.internal.DefinitionContextUtils;
import com.android.tools.r8.diagnostic.internal.MissingClassInfoImpl;
import com.android.tools.r8.diagnostic.internal.MissingDefinitionsDiagnosticImpl;
import com.android.tools.r8.diagnostic.internal.MissingFieldInfoImpl;
import com.android.tools.r8.diagnostic.internal.MissingMethodInfoImpl;
import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.references.FieldReference;
import com.android.tools.r8.references.MethodReference;
import com.android.tools.r8.references.PackageReference;
import com.android.tools.r8.tracereferences.TraceReferencesConsumer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Keep
public class TraceReferencesCheckConsumer
extends TraceReferencesConsumer.ForwardingConsumer {
    private final Map<ClassReference, Map<Object, DefinitionContext>> missingClassesContexts = new ConcurrentHashMap<ClassReference, Map<Object, DefinitionContext>>();
    private final Map<FieldReference, Map<Object, DefinitionContext>> missingFieldsContexts = new ConcurrentHashMap<FieldReference, Map<Object, DefinitionContext>>();
    private final Map<MethodReference, Map<Object, DefinitionContext>> missingMethodsContexts = new ConcurrentHashMap<MethodReference, Map<Object, DefinitionContext>>();

    public TraceReferencesCheckConsumer(TraceReferencesConsumer consumer) {
        super(consumer);
    }

    private boolean isEmpty() {
        return this.missingClassesContexts.isEmpty() && this.missingFieldsContexts.isEmpty() && this.missingMethodsContexts.isEmpty();
    }

    private MissingDefinitionsDiagnostic buildDiagnostic() {
        MissingDefinitionsDiagnosticImpl.Builder diagnosticBuilder = MissingDefinitionsDiagnosticImpl.builder();
        this.missingClassesContexts.forEach((reference, referencedFrom) -> diagnosticBuilder.addMissingDefinitionInfo(((MissingClassInfoImpl.Builder)MissingClassInfoImpl.builder().setClass((ClassReference)reference).addReferencedFromContexts(referencedFrom.values())).build()));
        this.missingFieldsContexts.forEach((reference, referencedFrom) -> diagnosticBuilder.addMissingDefinitionInfo(((MissingFieldInfoImpl.Builder)MissingFieldInfoImpl.builder().setField((FieldReference)reference).addReferencedFromContexts(referencedFrom.values())).build()));
        this.missingMethodsContexts.forEach((reference, referencedFrom) -> diagnosticBuilder.addMissingDefinitionInfo(((MissingMethodInfoImpl.Builder)MissingMethodInfoImpl.builder().setMethod((MethodReference)reference).addReferencedFromContexts(referencedFrom.values())).build()));
        return diagnosticBuilder.build();
    }

    @Override
    public void acceptType(TraceReferencesConsumer.TracedClass tracedClass, DiagnosticsHandler handler) {
        super.acceptType(tracedClass, handler);
        if (tracedClass.isMissingDefinition()) {
            Map missingClassContexts = this.missingClassesContexts.computeIfAbsent((ClassReference)tracedClass.getReference(), ignore -> new ConcurrentHashMap());
            DefinitionContextUtils.accept(tracedClass.getReferencedFromContext(), classContext -> {
                DefinitionContext cfr_ignored_0 = missingClassContexts.put(classContext.getClassReference(), classContext);
            }, fieldContext -> {
                DefinitionContext cfr_ignored_0 = missingClassContexts.put(fieldContext.getFieldReference(), fieldContext);
            }, methodContext -> {
                DefinitionContext cfr_ignored_0 = missingClassContexts.put(methodContext.getMethodReference(), methodContext);
            });
        }
    }

    @Override
    public void acceptField(TraceReferencesConsumer.TracedField tracedField, DiagnosticsHandler handler) {
        super.acceptField(tracedField, handler);
        if (tracedField.isMissingDefinition()) {
            Map missingFieldContexts = this.missingFieldsContexts.computeIfAbsent((FieldReference)tracedField.getReference(), ignore -> new ConcurrentHashMap());
            DefinitionContextUtils.accept(tracedField.getReferencedFromContext(), classContext -> {
                DefinitionContext cfr_ignored_0 = missingFieldContexts.put(classContext.getClassReference(), classContext);
            }, fieldContext -> {
                DefinitionContext cfr_ignored_0 = missingFieldContexts.put(fieldContext.getFieldReference(), fieldContext);
            }, methodContext -> {
                DefinitionContext cfr_ignored_0 = missingFieldContexts.put(methodContext.getMethodReference(), methodContext);
            });
        }
    }

    @Override
    public void acceptMethod(TraceReferencesConsumer.TracedMethod tracedMethod, DiagnosticsHandler handler) {
        super.acceptMethod(tracedMethod, handler);
        if (tracedMethod.isMissingDefinition()) {
            Map missingMethodContexts = this.missingMethodsContexts.computeIfAbsent((MethodReference)tracedMethod.getReference(), ignore -> new ConcurrentHashMap());
            DefinitionContextUtils.accept(tracedMethod.getReferencedFromContext(), classContext -> {
                DefinitionContext cfr_ignored_0 = missingMethodContexts.put(classContext.getClassReference(), classContext);
            }, fieldContext -> {
                DefinitionContext cfr_ignored_0 = missingMethodContexts.put(fieldContext.getFieldReference(), fieldContext);
            }, methodContext -> {
                DefinitionContext cfr_ignored_0 = missingMethodContexts.put(methodContext.getMethodReference(), methodContext);
            });
        }
    }

    @Override
    public void acceptPackage(PackageReference pkg, DiagnosticsHandler handler) {
        super.acceptPackage(pkg, handler);
    }

    @Override
    public void finished(DiagnosticsHandler handler) {
        super.finished(handler);
        if (!this.isEmpty()) {
            handler.error(this.buildDiagnostic());
        }
    }
}

