/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.tracereferences;

import com.android.tools.r8.ArchiveClassFileProvider;
import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.Diagnostic;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.Keep;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.ProgramResourceProvider;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.com.google.common.collect.ImmutableCollection;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.org.objectweb.asm.ClassReader;
import com.android.tools.r8.org.objectweb.asm.ClassVisitor;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.tracereferences.TraceReferencesCommandParser;
import com.android.tools.r8.tracereferences.TraceReferencesConsumer;
import com.android.tools.r8.utils.ArchiveResourceProvider;
import com.android.tools.r8.utils.Box;
import com.android.tools.r8.utils.ExceptionDiagnostic;
import com.android.tools.r8.utils.ExceptionUtils;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.StringDiagnostic;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

@Keep
public class TraceReferencesCommand {
    private final boolean printHelp;
    private final boolean printVersion;
    private final Reporter reporter;
    private final ImmutableList<ClassFileResourceProvider> library;
    private final ImmutableList<ClassFileResourceProvider> traceTarget;
    private final ImmutableList<ProgramResourceProvider> traceSource;
    private final TraceReferencesConsumer consumer;

    TraceReferencesCommand(boolean printHelp, boolean printVersion, Reporter reporter, ImmutableList<ClassFileResourceProvider> library, ImmutableList<ClassFileResourceProvider> traceTarget, ImmutableList<ProgramResourceProvider> traceSource, TraceReferencesConsumer consumer) {
        this.printHelp = printHelp;
        this.printVersion = printVersion;
        this.reporter = reporter;
        this.library = library;
        this.traceTarget = traceTarget;
        this.traceSource = traceSource;
        this.consumer = consumer;
    }

    TraceReferencesCommand(boolean printHelp, boolean printVersion) {
        this.printHelp = printHelp;
        this.printVersion = printVersion;
        this.reporter = null;
        this.library = null;
        this.traceTarget = null;
        this.traceSource = null;
        this.consumer = null;
    }

    public static Builder builder(DiagnosticsHandler diagnosticsHandler) {
        return new Builder(diagnosticsHandler);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder parse(String[] args2, Origin origin) {
        return TraceReferencesCommandParser.parse(args2, origin);
    }

    public static Builder parse(String[] args2, Origin origin, DiagnosticsHandler diagnosticsHandler) {
        return TraceReferencesCommandParser.parse(args2, origin, diagnosticsHandler);
    }

    public static Builder parse(Collection<String> args2, Origin origin) {
        return TraceReferencesCommandParser.parse(args2.toArray(new String[args2.size()]), origin);
    }

    public boolean isPrintHelp() {
        return this.printHelp;
    }

    public boolean isPrintVersion() {
        return this.printVersion;
    }

    Reporter getReporter() {
        return this.reporter;
    }

    List<ClassFileResourceProvider> getLibrary() {
        return this.library;
    }

    List<ClassFileResourceProvider> getTarget() {
        return this.traceTarget;
    }

    List<ProgramResourceProvider> getSource() {
        return this.traceSource;
    }

    TraceReferencesConsumer getConsumer() {
        return this.consumer;
    }

    public static class Builder {
        private boolean printHelp = false;
        private boolean printVersion = false;
        private final Reporter reporter;
        private final ImmutableList.Builder<ClassFileResourceProvider> libraryBuilder = ImmutableList.builder();
        private final ImmutableList.Builder<ClassFileResourceProvider> traceTargetBuilder = ImmutableList.builder();
        private final ImmutableList.Builder<ProgramResourceProvider> traceSourceBuilder = ImmutableList.builder();
        private TraceReferencesConsumer consumer;

        private Builder() {
            this(new DiagnosticsHandler(){});
        }

        private Builder(DiagnosticsHandler diagnosticsHandler) {
            this.reporter = new Reporter(diagnosticsHandler);
        }

        private static String extractClassDescriptor(byte[] data2) {
            ClassReader reader = new ClassReader(data2);
            class ClassNameExtractor
            extends ClassVisitor {
                private String className;

                ClassNameExtractor() {
                    super(589824);
                }

                @Override
                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    this.className = name;
                }

                String getClassInternalType() {
                    return this.className;
                }
            }
            ClassNameExtractor extractor = new ClassNameExtractor();
            reader.accept(extractor, 7);
            return "L" + extractor.getClassInternalType() + ";";
        }

        private ClassFileResourceProvider singleClassFileClassFileResourceProvider(Path file) throws IOException {
            return new SingleClassClassFileResourceProvider(new PathOrigin(file), Files.readAllBytes(file));
        }

        private ProgramResourceProvider singleClassFileProgramResourceProvider(final Path file) throws IOException {
            final byte[] bytes = Files.readAllBytes(file);
            final String descriptor = Builder.extractClassDescriptor(bytes);
            return new ProgramResourceProvider(){

                @Override
                public Collection<ProgramResource> getProgramResources() {
                    return ImmutableList.of(ProgramResource.fromBytes(new PathOrigin(file), ProgramResource.Kind.CF, bytes, ImmutableSet.of(descriptor)));
                }
            };
        }

        private void addLibraryOrTargetFile(Path file, ImmutableList.Builder<ClassFileResourceProvider> builder) {
            if (!Files.exists(file, new LinkOption[0])) {
                PathOrigin pathOrigin = new PathOrigin(file);
                NoSuchFileException noSuchFileException = new NoSuchFileException(file.toString());
                this.error(new ExceptionDiagnostic(noSuchFileException, pathOrigin));
            }
            if (FileUtils.isArchive(file)) {
                try {
                    ArchiveClassFileProvider provider = new ArchiveClassFileProvider(file);
                    builder.add((Object)provider);
                }
                catch (IOException e) {
                    this.error(new ExceptionDiagnostic(e, new PathOrigin(file)));
                }
            } else if (FileUtils.isClassFile(file)) {
                try {
                    builder.add((Object)this.singleClassFileClassFileResourceProvider(file));
                }
                catch (IOException e) {
                    this.error(new ExceptionDiagnostic(e));
                }
            } else {
                this.error(new StringDiagnostic("Unsupported source file type", new PathOrigin(file)));
            }
        }

        private void addSourceFile(final Path file) {
            if (!Files.exists(file, new LinkOption[0])) {
                PathOrigin pathOrigin = new PathOrigin(file);
                NoSuchFileException noSuchFileException = new NoSuchFileException(file.toString());
                this.error(new ExceptionDiagnostic(noSuchFileException, pathOrigin));
            }
            if (FileUtils.isArchive(file)) {
                this.traceSourceBuilder.add((Object)ArchiveResourceProvider.fromArchive(file, false));
            } else if (FileUtils.isClassFile(file)) {
                try {
                    this.traceSourceBuilder.add((Object)this.singleClassFileProgramResourceProvider(file));
                }
                catch (IOException e) {
                    this.error(new ExceptionDiagnostic(e));
                }
            } else if (FileUtils.isDexFile(file)) {
                this.traceSourceBuilder.add((Object)new ProgramResourceProvider(){
                    ProgramResource dexResource;
                    {
                        this.dexResource = ProgramResource.fromFile(ProgramResource.Kind.DEX, file);
                    }

                    @Override
                    public Collection<ProgramResource> getProgramResources() throws ResourceException {
                        return Collections.singletonList(this.dexResource);
                    }
                });
            } else {
                this.error(new StringDiagnostic("Unsupported source file type", new PathOrigin(file)));
            }
        }

        private TraceReferencesCommand makeCommand() {
            if (this.isPrintHelp() || this.isPrintVersion()) {
                return new TraceReferencesCommand(this.isPrintHelp(), this.isPrintVersion());
            }
            ImmutableCollection library = this.libraryBuilder.build();
            ImmutableCollection traceTarget = this.traceTargetBuilder.build();
            ImmutableCollection traceSource = this.traceSourceBuilder.build();
            if (library.isEmpty()) {
                this.error(new StringDiagnostic("No library specified"));
            }
            if (traceTarget.isEmpty()) {
                // empty if block
            }
            if (traceSource.isEmpty()) {
                this.error(new StringDiagnostic("No source specified"));
            }
            if (this.consumer == null) {
                this.error(new StringDiagnostic("No consumer specified"));
            }
            return new TraceReferencesCommand(this.printHelp, this.printVersion, this.reporter, (ImmutableList<ClassFileResourceProvider>)library, (ImmutableList<ClassFileResourceProvider>)traceTarget, (ImmutableList<ProgramResourceProvider>)traceSource, this.consumer);
        }

        Reporter getReporter() {
            return this.reporter;
        }

        public boolean isPrintHelp() {
            return this.printHelp;
        }

        public Builder setPrintHelp(boolean printHelp) {
            this.printHelp = printHelp;
            return this;
        }

        public boolean isPrintVersion() {
            return this.printVersion;
        }

        public Builder setPrintVersion(boolean printVersion) {
            this.printVersion = printVersion;
            return this;
        }

        public Builder addLibraryResourceProvider(ClassFileResourceProvider provider) {
            this.libraryBuilder.add((Object)provider);
            return this;
        }

        public Builder addLibraryFiles(Path ... files) {
            this.addLibraryFiles(Arrays.asList(files));
            return this;
        }

        public Builder addLibraryFiles(Collection<Path> files) {
            for (Path file : files) {
                this.addLibraryOrTargetFile(file, this.libraryBuilder);
            }
            return this;
        }

        public Builder addTargetFiles(Path ... files) {
            this.addTargetFiles(Arrays.asList(files));
            return this;
        }

        public Builder addTargetFiles(Collection<Path> files) {
            for (Path file : files) {
                this.addLibraryOrTargetFile(file, this.traceTargetBuilder);
            }
            return this;
        }

        public Builder addSourceFiles(Path ... files) {
            this.addSourceFiles(Arrays.asList(files));
            return this;
        }

        public Builder addSourceFiles(Collection<Path> files) {
            for (Path file : files) {
                this.addSourceFile(file);
            }
            return this;
        }

        public Builder setConsumer(TraceReferencesConsumer consumer) {
            this.consumer = consumer;
            return this;
        }

        public final TraceReferencesCommand build() throws CompilationFailedException {
            Box<Object> box = new Box<Object>(null);
            ExceptionUtils.withCompilationHandler(this.reporter, () -> {
                box.set(this.makeCommand());
                this.reporter.failIfPendingErrors();
            });
            return box.get();
        }

        void error(Diagnostic diagnostic) {
            this.reporter.error(diagnostic);
        }

        private static class SingleClassClassFileResourceProvider
        implements ClassFileResourceProvider {
            private final String descriptor;
            private final ProgramResource programResource;

            SingleClassClassFileResourceProvider(Origin origin, byte[] data2) {
                this.descriptor = Builder.extractClassDescriptor(data2);
                this.programResource = ProgramResource.fromBytes(origin, ProgramResource.Kind.CF, data2, ImmutableSet.of(this.descriptor));
            }

            @Override
            public Set<String> getClassDescriptors() {
                return ImmutableSet.of(this.descriptor);
            }

            @Override
            public ProgramResource getProgramResource(String descriptor) {
                return descriptor.equals(this.descriptor) ? this.programResource : null;
            }
        }
    }
}

