/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.tracereferences;

import com.android.tools.r8.BaseCompilerCommandParser;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.JdkClassFileProvider;
import com.android.tools.r8.StringConsumer;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.tracereferences.TraceReferencesCheckConsumer;
import com.android.tools.r8.tracereferences.TraceReferencesCommand;
import com.android.tools.r8.tracereferences.TraceReferencesConsumer;
import com.android.tools.r8.tracereferences.TraceReferencesKeepRules;
import com.android.tools.r8.utils.ExceptionDiagnostic;
import com.android.tools.r8.utils.FlagFile;
import com.android.tools.r8.utils.StringDiagnostic;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Set;

class TraceReferencesCommandParser {
    private static final Set<String> OPTIONS_WITH_PARAMETER = ImmutableSet.of("--lib", "--target", "--source", "--output");
    static final String USAGE_MESSAGE = String.join((CharSequence)"\n", Iterables.concat(Arrays.asList("Usage: tracereferences <command> [<options>] [@<argfile>]", " Where <command> is one of:", "  --check                 # Run emitting only diagnostics messages.", "  --keep-rules [<keep-rules-options>]", "                          # Traced references will be output in the keep-rules", "                          # format.", " and each <argfile> is a file containing additional options (one per line)", " and options are:", "  --lib <file|jdk-home>   # Add <file|jdk-home> runtime library.", "  --source <file>         # Add <file> as a source for tracing references.", "  [--target <file>]       # Add <file> as a target for tracing references. When", "                          # target is not specified all references from source", "                          # outside of library are treated as a missing", "                          # references.", "  --output <file>         # Output result in <outfile>. If not passed the", "                          # result will go to standard out."), BaseCompilerCommandParser.MAP_DIAGNOSTICS_USAGE_MESSAGE, Arrays.asList("  --version               # Print the version of tracereferences.", "  --help                  # Print this message.", " and <keep-rule-options> are:", "  --allowobfuscation      # Output keep rules with the allowobfuscation", "                          # modifier (defaults to rules without the modifier)")));

    TraceReferencesCommandParser() {
    }

    static TraceReferencesCommand.Builder parse(String[] args2, Origin origin) {
        return new TraceReferencesCommandParser().parse(args2, origin, TraceReferencesCommand.builder());
    }

    static TraceReferencesCommand.Builder parse(String[] args2, Origin origin, DiagnosticsHandler handler) {
        return new TraceReferencesCommandParser().parse(args2, origin, TraceReferencesCommand.builder(handler));
    }

    private void checkCommandNotSet(Command command, TraceReferencesCommand.Builder builder, Origin origin) {
        if (command != null) {
            builder.error(new StringDiagnostic("Multiple commands specified", origin));
        }
    }

    private TraceReferencesCommand.Builder parse(String[] args2, Origin origin, TraceReferencesCommand.Builder builder) {
        String[] expandedArgs = FlagFile.expandFlagFiles(args2, builder::error);
        Path output = null;
        Enum command = null;
        boolean allowObfuscation = false;
        if (expandedArgs.length == 0) {
            builder.error(new StringDiagnostic("Missing command"));
            return builder;
        }
        for (int i = 0; i < expandedArgs.length; ++i) {
            String arg = expandedArgs[i].trim();
            String nextArg = null;
            if (OPTIONS_WITH_PARAMETER.contains(arg)) {
                if (++i < expandedArgs.length) {
                    nextArg = expandedArgs[i];
                } else {
                    builder.error(new StringDiagnostic("Missing parameter for " + expandedArgs[i - 1] + ".", origin));
                    break;
                }
            }
            if (arg.length() == 0) continue;
            if (arg.equals("--help")) {
                builder.setPrintHelp(true);
                return builder;
            }
            if (arg.equals("--version")) {
                builder.setPrintVersion(true);
                return builder;
            }
            if (arg.equals("--check")) {
                this.checkCommandNotSet((Command)command, builder, origin);
                command = Command.CHECK;
                continue;
            }
            if (arg.equals("--keep-rules")) {
                this.checkCommandNotSet((Command)command, builder, origin);
                command = Command.KEEP_RULES;
                continue;
            }
            if (arg.equals("--allowobfuscation")) {
                allowObfuscation = true;
                continue;
            }
            if (arg.equals("--lib")) {
                TraceReferencesCommandParser.addLibraryArgument(builder, origin, nextArg);
                continue;
            }
            if (arg.equals("--target")) {
                builder.addTargetFiles(Paths.get(nextArg, new String[0]));
                continue;
            }
            if (arg.equals("--source")) {
                builder.addSourceFiles(Paths.get(nextArg, new String[0]));
                continue;
            }
            if (arg.equals("--output")) {
                if (output != null) {
                    builder.error(new StringDiagnostic("Option '--output' passed multiple times.", origin));
                    continue;
                }
                output = Paths.get(nextArg, new String[0]);
                continue;
            }
            if (arg.startsWith("@")) {
                builder.error(new StringDiagnostic("Recursive @argfiles are not supported: ", origin));
                continue;
            }
            int argsConsumed = BaseCompilerCommandParser.tryParseMapDiagnostics(builder::error, builder.getReporter(), arg, expandedArgs, i, origin);
            if (argsConsumed >= 0) {
                i += argsConsumed;
                continue;
            }
            builder.error(new StringDiagnostic("Unsupported option '" + arg + "'", origin));
        }
        if (command == null) {
            builder.error(new StringDiagnostic("Missing command, specify one of 'check' or '--keep-rules'", origin));
            return builder;
        }
        if (command == Command.CHECK && output != null) {
            builder.error(new StringDiagnostic("Using '--output' requires command '--keep-rules'", origin));
            return builder;
        }
        if (command != Command.KEEP_RULES && allowObfuscation) {
            builder.error(new StringDiagnostic("Using '--allowobfuscation' requires command '--keep-rules'", origin));
            return builder;
        }
        switch (1.$SwitchMap$com$android$tools$r8$tracereferences$TraceReferencesCommandParser$Command[command.ordinal()]) {
            case 1: {
                builder.setConsumer(new TraceReferencesCheckConsumer(TraceReferencesConsumer.emptyConsumer()));
                break;
            }
            case 2: {
                builder.setConsumer(new TraceReferencesCheckConsumer(TraceReferencesKeepRules.builder().setAllowObfuscation(allowObfuscation).setOutputConsumer(output != null ? new StringConsumer.FileConsumer(output) : new StringConsumer.WriterConsumer(null, new PrintWriter(System.out))).build()));
                break;
            }
            default: {
                throw new Unreachable();
            }
        }
        return builder;
    }

    private static boolean isJdkHome(Path home) {
        Path jrtFsJar = home.resolve("lib").resolve("jrt-fs.jar");
        if (Files.exists(jrtFsJar, new LinkOption[0])) {
            return true;
        }
        Path rtJar = home.resolve("jre").resolve("lib").resolve("rt.jar");
        if (Files.exists(rtJar, new LinkOption[0])) {
            return true;
        }
        rtJar = home.resolve("lib").resolve("rt.jar");
        return Files.exists(rtJar, new LinkOption[0]);
    }

    static void addLibraryArgument(TraceReferencesCommand.Builder builder, Origin origin, String arg) {
        Path path = Paths.get(arg, new String[0]);
        if (TraceReferencesCommandParser.isJdkHome(path)) {
            try {
                builder.addLibraryResourceProvider(JdkClassFileProvider.fromJdkHome(path));
            }
            catch (IOException e) {
                builder.error(new ExceptionDiagnostic(e, origin));
            }
        } else {
            builder.addLibraryFiles(path);
        }
    }

    private static enum Command {
        CHECK,
        KEEP_RULES;

    }
}

