/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.tracereferences;

import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.Keep;
import com.android.tools.r8.KeepForSubclassing;
import com.android.tools.r8.diagnostic.DefinitionContext;
import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.references.FieldReference;
import com.android.tools.r8.references.MethodReference;
import com.android.tools.r8.references.PackageReference;

@KeepForSubclassing
public interface TraceReferencesConsumer {
    public static TraceReferencesConsumer emptyConsumer() {
        return ForwardingConsumer.EMPTY_CONSUMER;
    }

    public void acceptType(TracedClass var1, DiagnosticsHandler var2);

    public void acceptField(TracedField var1, DiagnosticsHandler var2);

    public void acceptMethod(TracedMethod var1, DiagnosticsHandler var2);

    default public void acceptPackage(PackageReference pkg, DiagnosticsHandler handler) {
    }

    default public void finished(DiagnosticsHandler handler) {
    }

    @Keep
    public static class ForwardingConsumer
    implements TraceReferencesConsumer {
        private static final TraceReferencesConsumer EMPTY_CONSUMER = new ForwardingConsumer(null);
        private final TraceReferencesConsumer consumer;

        public ForwardingConsumer(TraceReferencesConsumer consumer) {
            this.consumer = consumer;
        }

        @Override
        public void acceptType(TracedClass tracedClass, DiagnosticsHandler handler) {
            if (this.consumer != null) {
                this.consumer.acceptType(tracedClass, handler);
            }
        }

        @Override
        public void acceptField(TracedField tracedField, DiagnosticsHandler handler) {
            if (this.consumer != null) {
                this.consumer.acceptField(tracedField, handler);
            }
        }

        @Override
        public void acceptMethod(TracedMethod tracedMethod, DiagnosticsHandler handler) {
            if (this.consumer != null) {
                this.consumer.acceptMethod(tracedMethod, handler);
            }
        }

        @Override
        public void acceptPackage(PackageReference pkg, DiagnosticsHandler handler) {
            if (this.consumer != null) {
                this.consumer.acceptPackage(pkg, handler);
            }
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
            if (this.consumer != null) {
                this.consumer.finished(handler);
            }
        }
    }

    @Keep
    public static interface TracedMethod
    extends TracedReference<MethodReference, MethodAccessFlags> {
    }

    @Keep
    public static interface TracedField
    extends TracedReference<FieldReference, FieldAccessFlags> {
    }

    @Keep
    public static interface TracedClass
    extends TracedReference<ClassReference, ClassAccessFlags> {
    }

    @Keep
    public static interface TracedReference<T, F> {
        public boolean isMissingDefinition();

        public T getReference();

        public DefinitionContext getReferencedFromContext();

        public F getAccessFlags();
    }

    @Keep
    public static interface MethodAccessFlags
    extends AccessFlags {
    }

    @Keep
    public static interface FieldAccessFlags
    extends AccessFlags {
    }

    @Keep
    public static interface ClassAccessFlags
    extends AccessFlags {
        public boolean isInterface();

        public boolean isEnum();
    }

    @Keep
    public static interface AccessFlags {
        public boolean isStatic();

        public boolean isPublic();

        public boolean isProtected();

        public boolean isPrivate();
    }
}

