/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.tracereferences;

import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.Keep;
import com.android.tools.r8.StringConsumer;
import com.android.tools.r8.tracereferences.KeepRuleFormatter;
import com.android.tools.r8.tracereferences.TraceReferencesConsumer;
import com.android.tools.r8.tracereferences.internal.TraceReferencesResult;
import java.nio.file.Path;

@Keep
public class TraceReferencesKeepRules
extends TraceReferencesConsumer.ForwardingConsumer {
    private final TraceReferencesResult.Builder traceReferencesResultBuilder;
    private final StringConsumer consumer;
    private final boolean allowObfuscation;

    private TraceReferencesKeepRules(TraceReferencesResult.Builder traceReferencesResultBuilder, StringConsumer consumer, boolean allowObfuscation) {
        super(traceReferencesResultBuilder);
        this.traceReferencesResultBuilder = traceReferencesResultBuilder;
        this.consumer = consumer;
        this.allowObfuscation = allowObfuscation;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void finished(DiagnosticsHandler handler) {
        super.finished(handler);
        KeepRuleFormatter formatter = new KeepRuleFormatter(this.allowObfuscation);
        formatter.format(this.traceReferencesResultBuilder.build());
        this.consumer.accept(formatter.get(), handler);
        this.consumer.finished(handler);
    }

    @Keep
    public static class Builder {
        private StringConsumer consumer;
        private boolean allowObfuscation;

        public Builder setAllowObfuscation(boolean value) {
            this.allowObfuscation = value;
            return this;
        }

        public Builder setOutputPath(Path output) {
            this.consumer = new StringConsumer.FileConsumer(output);
            return this;
        }

        public Builder setOutputConsumer(StringConsumer consumer) {
            this.consumer = consumer;
            return this;
        }

        public TraceReferencesKeepRules build() {
            return new TraceReferencesKeepRules(TraceReferencesResult.builder(), this.consumer, this.allowObfuscation);
        }
    }
}

