/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.tracereferences;

import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.diagnostic.DefinitionContext;
import com.android.tools.r8.diagnostic.internal.DefinitionContextUtils;
import com.android.tools.r8.features.ClassToFeatureSplitMap;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.ClassResolutionResult;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndField;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.FieldResolutionResult;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.desugar.LambdaDescriptor;
import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.references.FieldReference;
import com.android.tools.r8.references.MethodReference;
import com.android.tools.r8.references.Reference;
import com.android.tools.r8.shaking.MainDexInfo;
import com.android.tools.r8.tracereferences.TraceReferencesConsumer;
import com.android.tools.r8.tracereferences.internal.TracedClassImpl;
import com.android.tools.r8.tracereferences.internal.TracedFieldImpl;
import com.android.tools.r8.tracereferences.internal.TracedMethodImpl;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Timing;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;

public class Tracer {
    private final AppView<? extends AppInfoWithClassHierarchy> appView;
    private final DiagnosticsHandler diagnostics;
    private final Predicate<DexType> targetPredicate;

    Tracer(Set<String> targetDescriptors, AndroidApp inputApp, DiagnosticsHandler diagnostics, InternalOptions options) throws IOException {
        this(AppView.createForTracer(AppInfoWithClassHierarchy.createInitialAppInfoWithClassHierarchy(new ApplicationReader(inputApp, options, Timing.empty()).read().toDirect(), ClassToFeatureSplitMap.createEmptyClassToFeatureSplitMap(), MainDexInfo.none())), diagnostics, type -> targetDescriptors.contains(type.toDescriptorString()));
    }

    public Tracer(AppView<? extends AppInfoWithClassHierarchy> appView, DiagnosticsHandler diagnostics, Predicate<DexType> targetPredicate) {
        this.appView = appView;
        this.diagnostics = diagnostics;
        this.targetPredicate = targetPredicate;
    }

    public void run(TraceReferencesConsumer consumer) {
        UseCollector useCollector = new UseCollector(this.appView, consumer, this.diagnostics, this.targetPredicate);
        for (DexProgramClass clazz : this.appView.appInfo().classes()) {
            DefinitionContext classContext = DefinitionContextUtils.create(clazz);
            if (clazz.superType != null) {
                useCollector.registerSuperType(clazz, clazz.superType, classContext);
            }
            for (DexType implementsType : clazz.getInterfaces()) {
                useCollector.registerSuperType(clazz, implementsType, classContext);
            }
            clazz.forEachProgramField(x$0 -> useCollector.registerField(x$0));
            clazz.forEachProgramMethod(method -> {
                useCollector.registerMethod(method);
                useCollector.traceCode(method);
            });
        }
        consumer.finished(this.diagnostics);
    }

    static class UseCollector {
        private final AppView<? extends AppInfoWithClassHierarchy> appView;
        private final DexItemFactory factory;
        private final TraceReferencesConsumer consumer;
        private final DiagnosticsHandler diagnostics;
        private final Predicate<DexType> targetPredicate;
        private final Set<ClassReference> missingClasses = new HashSet<ClassReference>();
        private final Set<FieldReference> missingFields = new HashSet<FieldReference>();
        private final Set<MethodReference> missingMethods = new HashSet<MethodReference>();

        UseCollector(AppView<? extends AppInfoWithClassHierarchy> appView, TraceReferencesConsumer consumer, DiagnosticsHandler diagnostics, Predicate<DexType> targetPredicate) {
            this.appView = appView;
            this.factory = appView.dexItemFactory();
            this.consumer = consumer;
            this.diagnostics = diagnostics;
            this.targetPredicate = targetPredicate;
        }

        private boolean isTargetType(DexType type) {
            return this.targetPredicate.test(type);
        }

        private void addType(DexType type, DefinitionContext referencedFrom) {
            if (type.isArrayType()) {
                this.addType(type.toBaseType(this.factory), referencedFrom);
                return;
            }
            if (type.isPrimitiveType() || type.isVoidType()) {
                return;
            }
            assert (type.isClassType());
            this.addClassType(type, referencedFrom);
        }

        private void addTypes(DexTypeList types, DefinitionContext referencedFrom) {
            for (DexType type : types) {
                this.addType(type, referencedFrom);
            }
        }

        private void addClassType(DexType type, DefinitionContext referencedFrom) {
            assert (type.isClassType());
            ClassResolutionResult result = this.appView.contextIndependentDefinitionForWithResolutionResult(type);
            if (result.hasClassResolutionResult()) {
                result.forEachClassResolutionResult(clazz -> this.addClass((DexClass)clazz, referencedFrom));
            } else {
                TracedClassImpl tracedClass = new TracedClassImpl(type, referencedFrom);
                this.collectMissingClass(tracedClass);
                this.consumer.acceptType(tracedClass, this.diagnostics);
            }
        }

        private void addClass(DexClass clazz, DefinitionContext referencedFrom) {
            if (this.isTargetType(clazz.getType())) {
                TracedClassImpl tracedClass = new TracedClassImpl(clazz, referencedFrom);
                this.consumer.acceptType(tracedClass, this.diagnostics);
                if (clazz.getAccessFlags().isVisibilityDependingOnPackage()) {
                    this.consumer.acceptPackage(Reference.packageFromString(clazz.getType().getPackageName()), this.diagnostics);
                }
            }
        }

        private void addSuperMethodFromTarget(DexClassAndMethod method, DefinitionContext referencedFrom) {
            assert (!method.isProgramMethod());
            assert (this.isTargetType(method.getHolderType()));
            TracedMethodImpl tracedMethod = new TracedMethodImpl((DexEncodedMethod)method.getDefinition(), referencedFrom);
            if (this.isTargetType(method.getHolderType())) {
                this.consumer.acceptMethod(tracedMethod, this.diagnostics);
                if (method.getAccessFlags().isVisibilityDependingOnPackage()) {
                    this.consumer.acceptPackage(Reference.packageFromString(method.getHolderType().getPackageName()), this.diagnostics);
                }
            }
        }

        private <R, T extends TraceReferencesConsumer.TracedReference<R, ?>> void collectMissing(T tracedReference, Set<R> missingCollection) {
            if (tracedReference.isMissingDefinition()) {
                missingCollection.add(tracedReference.getReference());
            }
        }

        private void collectMissingClass(TracedClassImpl tracedClass) {
            assert (tracedClass.isMissingDefinition());
            this.collectMissing(tracedClass, this.missingClasses);
        }

        private void collectMissingField(TracedFieldImpl tracedField) {
            assert (tracedField.isMissingDefinition());
            this.collectMissing(tracedField, this.missingFields);
        }

        private void collectMissingMethod(TracedMethodImpl tracedMethod) {
            assert (tracedMethod.isMissingDefinition());
            this.collectMissing(tracedMethod, this.missingMethods);
        }

        private void registerField(ProgramField field) {
            DefinitionContext referencedFrom = DefinitionContextUtils.create(field);
            this.addType(field.getType(), referencedFrom);
        }

        private void registerMethod(ProgramMethod method) {
            DefinitionContext referencedFrom = DefinitionContextUtils.create(method);
            this.addTypes(method.getParameters(), referencedFrom);
            this.addType(method.getReturnType(), referencedFrom);
            for (DexAnnotation annotation : ((DexEncodedMethod)method.getDefinition()).annotations().annotations) {
                if (annotation.getAnnotationType() != this.factory.annotationThrows) continue;
                DexValue.DexValueArray dexValues = annotation.annotation.elements[0].value.asDexValueArray();
                for (DexValue dexValType : dexValues.getValues()) {
                    this.addType((DexType)dexValType.asDexValueType().value, referencedFrom);
                }
            }
            DexClassAndMethod superTarget = this.appInfo().resolveMethodOn((DexClass)method.getHolder(), (DexMethod)method.getReference()).lookupInvokeSpecialTarget(method.getHolder(), this.appInfo());
            if (superTarget != null && !superTarget.isProgramMethod() && this.isTargetType(superTarget.getHolderType())) {
                this.addSuperMethodFromTarget(superTarget, referencedFrom);
            }
        }

        private void traceCode(ProgramMethod method) {
            method.registerCodeReferences(new MethodUseCollector(method));
        }

        private void registerSuperType(DexProgramClass clazz, DexType superType, DefinitionContext referencedFrom) {
            this.addType(superType, referencedFrom);
            clazz.forEachMethod(method -> {
                DexClassAndMethod resolvedMethod = this.appInfo().resolveMethodOn(superType, (DexMethod)method.getReference(), superType != clazz.superType).getResolutionPair();
                if (resolvedMethod != null && !resolvedMethod.isProgramMethod() && this.isTargetType(resolvedMethod.getHolderType())) {
                    this.addSuperMethodFromTarget(resolvedMethod, referencedFrom);
                }
            });
        }

        AppInfoWithClassHierarchy appInfo() {
            return this.appView.appInfo();
        }

        GraphLens graphLens() {
            return this.appView.graphLens();
        }

        class MethodUseCollector
        extends UseRegistry<ProgramMethod> {
            private final DefinitionContext referencedFrom;

            public MethodUseCollector(ProgramMethod context) {
                super(UseCollector.this.appView, context);
                this.referencedFrom = DefinitionContextUtils.create(context);
            }

            private void handleInvokeWithDynamicDispatch(GraphLens.MethodLookupResult lookupResult) {
                DexMethod method = (DexMethod)lookupResult.getReference();
                if (method.getHolderType().isArrayType()) {
                    assert (lookupResult.getType().isVirtual());
                    UseCollector.this.addType(method.getHolderType(), this.referencedFrom);
                    return;
                }
                assert (lookupResult.getType().isInterface() || lookupResult.getType().isVirtual());
                this.handleRewrittenMethodResolution(method, lookupResult.getType().isInterface() ? UseCollector.this.appInfo().resolveMethodOnInterface(method) : UseCollector.this.appInfo().resolveMethodOnClass(method));
            }

            private void handleRewrittenMethodResolution(DexMethod method, MethodResolutionResult resolutionResult) {
                if (resolutionResult.isFailedResolution() && resolutionResult.asFailedResolution().hasMethodsCausingError()) {
                    resolutionResult.asFailedResolution().forEachFailureDependency(methodCausingFailure -> this.handleRewrittenMethodReference(method, (DexEncodedMethod)methodCausingFailure));
                    return;
                }
                this.handleRewrittenMethodReference(method, resolutionResult.getResolutionPair());
            }

            private void handleRewrittenMethodReference(DexMethod method, DexClassAndMethod resolvedMethod) {
                this.handleRewrittenMethodReference(method, resolvedMethod == null ? null : (DexEncodedMethod)resolvedMethod.getDefinition());
            }

            private void handleRewrittenMethodReference(DexMethod method, DexEncodedMethod resolvedMethod) {
                assert (resolvedMethod == null || ((DexMethod)resolvedMethod.getReference()).match(method) || DexClass.isSignaturePolymorphicMethod(resolvedMethod, UseCollector.this.factory));
                UseCollector.this.addType(method.getHolderType(), this.referencedFrom);
                UseCollector.this.addTypes(method.getParameters(), this.referencedFrom);
                UseCollector.this.addType(method.getReturnType(), this.referencedFrom);
                if (resolvedMethod != null) {
                    if (UseCollector.this.isTargetType(resolvedMethod.getHolderType())) {
                        if (resolvedMethod.getHolderType() != method.getHolderType()) {
                            UseCollector.this.addType(resolvedMethod.getHolderType(), this.referencedFrom);
                        }
                        TracedMethodImpl tracedMethod = new TracedMethodImpl(resolvedMethod, this.referencedFrom);
                        UseCollector.this.consumer.acceptMethod(tracedMethod, UseCollector.this.diagnostics);
                        if (resolvedMethod.getAccessFlags().isVisibilityDependingOnPackage()) {
                            UseCollector.this.consumer.acceptPackage(Reference.packageFromString(resolvedMethod.getHolderType().getPackageName()), UseCollector.this.diagnostics);
                        }
                    }
                } else {
                    TracedMethodImpl tracedMethod = new TracedMethodImpl(method, this.referencedFrom);
                    UseCollector.this.collectMissingMethod(tracedMethod);
                    UseCollector.this.consumer.acceptMethod(tracedMethod, UseCollector.this.diagnostics);
                }
            }

            private void handleFieldAccess(DexField field) {
                GraphLens.FieldLookupResult lookupResult = UseCollector.this.graphLens().lookupFieldResult(field);
                this.handleRewrittenFieldReference((DexField)lookupResult.getReference());
            }

            private void handleRewrittenFieldReference(DexField field) {
                UseCollector.this.addType(field.getHolderType(), this.referencedFrom);
                UseCollector.this.addType(field.getType(), this.referencedFrom);
                FieldResolutionResult resolutionResult = UseCollector.this.appInfo().resolveField(field);
                resolutionResult.forEachFieldResolutionResult(singleResolutionResult -> {
                    if (!singleResolutionResult.isSingleFieldResolutionResult()) {
                        return;
                    }
                    DexClassAndField resolvedField = singleResolutionResult.getResolutionPair();
                    if (UseCollector.this.isTargetType(resolvedField.getHolderType())) {
                        if (resolvedField.getHolderType() != field.getHolderType()) {
                            UseCollector.this.addClass(resolvedField.getHolder(), this.referencedFrom);
                        }
                        TracedFieldImpl tracedField = new TracedFieldImpl(resolvedField, this.referencedFrom);
                        UseCollector.this.consumer.acceptField(tracedField, UseCollector.this.diagnostics);
                        if (resolvedField.getAccessFlags().isVisibilityDependingOnPackage()) {
                            UseCollector.this.consumer.acceptPackage(Reference.packageFromString(resolvedField.getHolderType().getPackageName()), UseCollector.this.diagnostics);
                        }
                    }
                });
                if (!resolutionResult.hasSuccessfulResolutionResult()) {
                    TracedFieldImpl tracedField = new TracedFieldImpl(field, this.referencedFrom);
                    UseCollector.this.collectMissingField(tracedField);
                    UseCollector.this.consumer.acceptField(tracedField, UseCollector.this.diagnostics);
                }
            }

            @Override
            public void registerInvokeDirect(DexMethod method) {
                GraphLens.MethodLookupResult lookupResult = UseCollector.this.graphLens().lookupInvokeDirect(method, (ProgramMethod)this.getContext());
                assert (lookupResult.getType().isDirect());
                DexMethod rewrittenMethod = (DexMethod)lookupResult.getReference();
                DexClass holder = UseCollector.this.appView.definitionFor(rewrittenMethod.getHolderType());
                this.handleRewrittenMethodReference(rewrittenMethod, rewrittenMethod.lookupMemberOnClass(holder));
            }

            @Override
            public void registerInvokeInterface(DexMethod method) {
                GraphLens.MethodLookupResult lookupResult = UseCollector.this.graphLens().lookupInvokeInterface(method, (ProgramMethod)this.getContext());
                assert (lookupResult.getType().isInterface());
                this.handleInvokeWithDynamicDispatch(lookupResult);
            }

            @Override
            public void registerInvokeStatic(DexMethod method) {
                GraphLens.MethodLookupResult lookupResult = UseCollector.this.graphLens().lookupInvokeStatic(method, (ProgramMethod)this.getContext());
                assert (lookupResult.getType().isStatic());
                DexMethod rewrittenMethod = (DexMethod)lookupResult.getReference();
                this.handleRewrittenMethodResolution(rewrittenMethod, UseCollector.this.appInfo().unsafeResolveMethodDueToDexFormat(rewrittenMethod));
            }

            @Override
            public void registerInvokeSuper(DexMethod method) {
                GraphLens.MethodLookupResult lookupResult = UseCollector.this.graphLens().lookupInvokeSuper(method, (ProgramMethod)this.getContext());
                assert (lookupResult.getType().isSuper());
                DexMethod rewrittenMethod = (DexMethod)lookupResult.getReference();
                MethodResolutionResult resolutionResult = UseCollector.this.appInfo().unsafeResolveMethodDueToDexFormat(rewrittenMethod);
                if (resolutionResult.isFailedResolution() && resolutionResult.asFailedResolution().hasMethodsCausingError()) {
                    this.handleRewrittenMethodResolution(rewrittenMethod, resolutionResult);
                    return;
                }
                this.handleRewrittenMethodReference(rewrittenMethod, resolutionResult.lookupInvokeSuperTarget(((ProgramMethod)this.getContext()).getHolder(), UseCollector.this.appInfo()));
            }

            @Override
            public void registerInvokeVirtual(DexMethod method) {
                GraphLens.MethodLookupResult lookupResult = UseCollector.this.graphLens().lookupInvokeVirtual(method, (ProgramMethod)this.getContext());
                assert (lookupResult.getType().isVirtual());
                this.handleInvokeWithDynamicDispatch(lookupResult);
            }

            @Override
            public void registerInitClass(DexType clazz) {
                DexType rewrittenClass = UseCollector.this.graphLens().lookupType(clazz);
                DexField clinitField = UseCollector.this.appView.initClassLens().getInitClassField(rewrittenClass);
                this.handleRewrittenFieldReference(clinitField);
            }

            @Override
            public void registerInstanceFieldRead(DexField field) {
                this.handleFieldAccess(field);
            }

            @Override
            public void registerInstanceFieldWrite(DexField field) {
                this.handleFieldAccess(field);
            }

            @Override
            public void registerStaticFieldRead(DexField field) {
                this.handleFieldAccess(field);
            }

            @Override
            public void registerStaticFieldWrite(DexField field) {
                this.handleFieldAccess(field);
            }

            @Override
            public void registerTypeReference(DexType type) {
                UseCollector.this.addType(UseCollector.this.graphLens().lookupType(type), this.referencedFrom);
            }

            @Override
            public void registerCallSite(DexCallSite callSite) {
                super.registerCallSite(callSite);
                LambdaDescriptor descriptor = LambdaDescriptor.tryInfer(callSite, UseCollector.this.appInfo(), (ProgramMethod)this.getContext());
                if (descriptor != null) {
                    for (DexType interfaceType : descriptor.interfaces) {
                        ClassResolutionResult classResolutionResult = UseCollector.this.appView.contextIndependentDefinitionForWithResolutionResult(interfaceType);
                        if (classResolutionResult.hasClassResolutionResult()) {
                            classResolutionResult.forEachClassResolutionResult(interfaceDefinition -> {
                                DexEncodedMethod mainMethod = interfaceDefinition.lookupMethod(descriptor.getMainMethod());
                                if (mainMethod != null) {
                                    this.registerInvokeInterface((DexMethod)mainMethod.getReference());
                                }
                                for (DexProto bridgeProto : descriptor.bridges) {
                                    DexEncodedMethod bridgeMethod = interfaceDefinition.lookupMethod(bridgeProto, descriptor.name);
                                    if (bridgeMethod == null) continue;
                                    this.registerInvokeInterface((DexMethod)bridgeMethod.getReference());
                                }
                            });
                            continue;
                        }
                        TracedClassImpl tracedClass = new TracedClassImpl(interfaceType, this.referencedFrom);
                        UseCollector.this.collectMissingClass(tracedClass);
                        UseCollector.this.consumer.acceptType(tracedClass, UseCollector.this.diagnostics);
                    }
                }
            }
        }
    }
}

