/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.tracereferences.internal;

import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.references.FieldReference;
import com.android.tools.r8.references.MethodReference;
import com.android.tools.r8.references.PackageReference;
import com.android.tools.r8.tracereferences.TraceReferencesConsumer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TraceReferencesResult {
    private final Set<TraceReferencesConsumer.TracedClass> types;
    private final Map<ClassReference, Set<TraceReferencesConsumer.TracedField>> fields;
    private final Map<ClassReference, Set<TraceReferencesConsumer.TracedMethod>> methods;
    private final Set<PackageReference> keepPackageNames;

    TraceReferencesResult(Set<TraceReferencesConsumer.TracedClass> types, Map<ClassReference, Set<TraceReferencesConsumer.TracedField>> fields, Map<ClassReference, Set<TraceReferencesConsumer.TracedMethod>> methods, Set<PackageReference> keepPackageNames) {
        this.types = types;
        this.fields = fields;
        this.methods = methods;
        this.keepPackageNames = keepPackageNames;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Set<TraceReferencesConsumer.TracedClass> getTracedClasses() {
        return this.types;
    }

    public Map<ClassReference, Set<TraceReferencesConsumer.TracedField>> getTracedFields() {
        return this.fields;
    }

    public Map<ClassReference, Set<TraceReferencesConsumer.TracedMethod>> getTracedMethods() {
        return this.methods;
    }

    public Set<PackageReference> getTracedPackageNames() {
        return this.keepPackageNames;
    }

    public static class Builder
    implements TraceReferencesConsumer {
        private final Set<TraceReferencesConsumer.TracedClass> types = new HashSet<TraceReferencesConsumer.TracedClass>();
        private final Map<ClassReference, Set<TraceReferencesConsumer.TracedField>> fields = new HashMap<ClassReference, Set<TraceReferencesConsumer.TracedField>>();
        private final Map<ClassReference, Set<TraceReferencesConsumer.TracedMethod>> methods = new HashMap<ClassReference, Set<TraceReferencesConsumer.TracedMethod>>();
        private final Set<PackageReference> keepPackageNames = new HashSet<PackageReference>();

        @Override
        public void acceptType(TraceReferencesConsumer.TracedClass tracedClass, DiagnosticsHandler handler) {
            this.types.add(tracedClass);
        }

        @Override
        public void acceptField(TraceReferencesConsumer.TracedField tracedField, DiagnosticsHandler handler) {
            FieldReference field = (FieldReference)tracedField.getReference();
            this.fields.computeIfAbsent(field.getHolderClass(), k -> new HashSet()).add(tracedField);
        }

        @Override
        public void acceptMethod(TraceReferencesConsumer.TracedMethod tracedMethod, DiagnosticsHandler handler) {
            MethodReference method = (MethodReference)tracedMethod.getReference();
            this.methods.computeIfAbsent(method.getHolderClass(), k -> new HashSet()).add(tracedMethod);
        }

        @Override
        public void acceptPackage(PackageReference pkg, DiagnosticsHandler handler) {
            this.keepPackageNames.add(pkg);
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
        }

        public TraceReferencesResult build() {
            return new TraceReferencesResult(this.types, this.fields, this.methods, this.keepPackageNames);
        }
    }
}

