/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.DataResourceProvider;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.ProgramResourceProvider;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.origin.ArchiveEntryOrigin;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.OneShotByteResource;
import com.android.tools.r8.utils.ZipUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class AarArchiveResourceProvider
implements ProgramResourceProvider {
    private final Origin origin;
    private final Path archive;

    public static AarArchiveResourceProvider fromArchive(Path archive) {
        return new AarArchiveResourceProvider(archive);
    }

    AarArchiveResourceProvider(Path archive) {
        assert (FileUtils.isArchive(archive));
        this.origin = new ArchiveEntryOrigin("classes.jar", new PathOrigin(archive));
        this.archive = archive;
    }

    private List<ProgramResource> readClassesJar(ZipInputStream stream) throws IOException {
        ZipEntry entry;
        ArrayList<ProgramResource> resources = new ArrayList<ProgramResource>();
        while (null != (entry = stream.getNextEntry())) {
            String name = entry.getName();
            if (!ZipUtils.isClassFile(name)) continue;
            ArchiveEntryOrigin entryOrigin = new ArchiveEntryOrigin(name, this.origin);
            String descriptor = DescriptorUtils.guessTypeDescriptor(name);
            OneShotByteResource resource = OneShotByteResource.create(ProgramResource.Kind.CF, entryOrigin, ByteStreams.toByteArray(stream), Collections.singleton(descriptor));
            resources.add(resource);
        }
        return resources;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<ProgramResource> readArchive() throws IOException {
        List<ProgramResource> classResources = null;
        try {
            ZipFile zipFile = FileUtils.createZipFile(this.archive.toFile(), StandardCharsets.UTF_8);
            Throwable throwable = null;
            try {
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    Throwable throwable2;
                    InputStream stream;
                    block16: {
                        ZipEntry entry = entries.nextElement();
                        stream = zipFile.getInputStream(entry);
                        throwable2 = null;
                        try {
                            String name = entry.getName();
                            if (!name.equals("classes.jar")) break block16;
                            ZipInputStream classesStream = new ZipInputStream(stream);
                            Throwable throwable3 = null;
                            try {
                                classResources = this.readClassesJar(classesStream);
                            }
                            catch (Throwable throwable4) {
                                try {
                                    throwable3 = throwable4;
                                    throw throwable4;
                                }
                                catch (Throwable throwable5) {
                                    AarArchiveResourceProvider.$closeResource(throwable3, classesStream);
                                    throw throwable5;
                                }
                            }
                            AarArchiveResourceProvider.$closeResource(throwable3, classesStream);
                            if (stream == null) break;
                        }
                        catch (Throwable throwable6) {
                            try {
                                throwable2 = throwable6;
                                throw throwable6;
                            }
                            catch (Throwable throwable7) {
                                if (stream == null) throw throwable7;
                                AarArchiveResourceProvider.$closeResource(throwable2, stream);
                                throw throwable7;
                            }
                        }
                        AarArchiveResourceProvider.$closeResource(throwable2, stream);
                        break;
                    }
                    if (stream == null) continue;
                    AarArchiveResourceProvider.$closeResource(throwable2, stream);
                }
                if (zipFile == null) return classResources == null ? Collections.emptyList() : classResources;
            }
            catch (Throwable throwable8) {
                try {
                    throwable = throwable8;
                    throw throwable8;
                }
                catch (Throwable throwable9) {
                    if (zipFile == null) throw throwable9;
                    AarArchiveResourceProvider.$closeResource(throwable, zipFile);
                    throw throwable9;
                }
            }
            AarArchiveResourceProvider.$closeResource(throwable, zipFile);
            return classResources == null ? Collections.emptyList() : classResources;
        }
        catch (ZipException e) {
            throw new CompilationError("Zip error while reading '" + this.archive + "': " + e.getMessage(), e);
        }
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    @Override
    public Collection<ProgramResource> getProgramResources() throws ResourceException {
        try {
            return this.readArchive();
        }
        catch (IOException e) {
            throw new ResourceException(this.origin, (Throwable)e);
        }
    }

    @Override
    public DataResourceProvider getDataResourceProvider() {
        return null;
    }
}

