/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.DataDirectoryResource;
import com.android.tools.r8.DataEntryResource;
import com.android.tools.r8.DataResourceProvider;
import com.android.tools.r8.Keep;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.ProgramResourceProvider;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.origin.ArchiveEntryOrigin;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.shaking.FilteredClassPath;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.OneShotByteResource;
import com.android.tools.r8.utils.ZipUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

@Keep
public class ArchiveResourceProvider
implements ProgramResourceProvider,
DataResourceProvider {
    private final Origin origin;
    private final FilteredClassPath archive;
    private final boolean ignoreDexInArchive;

    public static ArchiveResourceProvider fromArchive(Path archive, boolean ignoreDexInArchive) {
        return new ArchiveResourceProvider(FilteredClassPath.unfiltered(archive), ignoreDexInArchive);
    }

    ArchiveResourceProvider(FilteredClassPath archive, boolean ignoreDexInArchive) {
        assert (FileUtils.isArchive(archive.getPath()));
        this.origin = new PathOrigin(archive.getPath());
        this.archive = archive;
        this.ignoreDexInArchive = ignoreDexInArchive;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<ProgramResource> readArchive() throws IOException {
        ArrayList<ProgramResource> arrayList;
        ArrayList<OneShotByteResource> classResources;
        ArrayList<ProgramResource> dexResources;
        block18: {
            dexResources = new ArrayList<ProgramResource>();
            classResources = new ArrayList<OneShotByteResource>();
            try {
                ZipFile zipFile = FileUtils.createZipFile(this.archive.getPath().toFile(), StandardCharsets.UTF_8);
                Throwable throwable = null;
                try {
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        InputStream stream = zipFile.getInputStream(entry);
                        Throwable throwable2 = null;
                        try {
                            String name = entry.getName();
                            ArchiveEntryOrigin entryOrigin = new ArchiveEntryOrigin(name, this.origin);
                            if (this.archive.matchesFile(name)) {
                                if (ZipUtils.isDexFile(name)) {
                                    if (!this.ignoreDexInArchive) {
                                        OneShotByteResource resource = OneShotByteResource.create(ProgramResource.Kind.DEX, entryOrigin, ByteStreams.toByteArray(stream), null);
                                        dexResources.add(resource);
                                    }
                                } else if (ZipUtils.isClassFile(name)) {
                                    String descriptor = DescriptorUtils.guessTypeDescriptor(name);
                                    OneShotByteResource resource = OneShotByteResource.create(ProgramResource.Kind.CF, entryOrigin, ByteStreams.toByteArray(stream), Collections.singleton(descriptor));
                                    classResources.add(resource);
                                }
                            }
                            if (stream == null) continue;
                        }
                        catch (Throwable throwable3) {
                            try {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (stream == null) throw throwable4;
                                ArchiveResourceProvider.$closeResource(throwable2, stream);
                                throw throwable4;
                            }
                        }
                        ArchiveResourceProvider.$closeResource(throwable2, stream);
                    }
                    if (zipFile == null) break block18;
                }
                catch (Throwable throwable5) {
                    try {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        if (zipFile == null) throw throwable6;
                        ArchiveResourceProvider.$closeResource(throwable, zipFile);
                        throw throwable6;
                    }
                }
                ArchiveResourceProvider.$closeResource(throwable, zipFile);
            }
            catch (ZipException e) {
                throw new CompilationError("Zip error while reading '" + this.archive + "': " + e.getMessage(), e);
            }
        }
        if (!dexResources.isEmpty() && !classResources.isEmpty()) {
            throw new CompilationError("Cannot create android app from an archive '" + this.archive + "' containing both DEX and Java-bytecode content");
        }
        if (!dexResources.isEmpty()) {
            arrayList = dexResources;
            return arrayList;
        }
        arrayList = classResources;
        return arrayList;
    }

    private boolean isProgramResourceName(String name) {
        return ZipUtils.isClassFile(name) || ZipUtils.isDexFile(name) && !this.ignoreDexInArchive;
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    public Origin getOrigin() {
        return this.origin;
    }

    @Override
    public Collection<ProgramResource> getProgramResources() throws ResourceException {
        try {
            return this.readArchive();
        }
        catch (IOException e) {
            throw new ResourceException(this.origin, (Throwable)e);
        }
    }

    @Override
    public DataResourceProvider getDataResourceProvider() {
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void accept(DataResourceProvider.Visitor resourceBrowser) throws ResourceException {
        try {
            ZipFile zipFile = FileUtils.createZipFile(this.archive.getPath().toFile(), StandardCharsets.UTF_8);
            Throwable throwable = null;
            try {
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!this.archive.matchesFile(name) || this.isProgramResourceName(name)) continue;
                    if (entry.isDirectory()) {
                        resourceBrowser.visit(DataDirectoryResource.fromZip(zipFile, entry));
                        continue;
                    }
                    resourceBrowser.visit(DataEntryResource.fromZip(zipFile, entry));
                }
                if (zipFile == null) return;
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    if (zipFile == null) throw throwable3;
                    ArchiveResourceProvider.$closeResource(throwable, zipFile);
                    throw throwable3;
                }
            }
            ArchiveResourceProvider.$closeResource(throwable, zipFile);
            return;
        }
        catch (ZipException e) {
            throw new ResourceException(this.origin, (Throwable)new CompilationError("Zip error while reading '" + this.archive + "': " + e.getMessage(), e));
        }
        catch (IOException e) {
            throw new ResourceException(this.origin, (Throwable)new CompilationError("I/O exception while reading '" + this.archive + "': " + e.getMessage(), e));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void accept(Consumer<ProgramResource> visitor) throws ResourceException {
        try {
            ZipFile zipFile = FileUtils.createZipFile(this.archive.getPath().toFile(), StandardCharsets.UTF_8);
            Throwable throwable = null;
            try {
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!this.archive.matchesFile(name) || !this.isProgramResourceName(name)) continue;
                    ArchiveEntryOrigin entryOrigin = new ArchiveEntryOrigin(name, this.origin);
                    InputStream stream = zipFile.getInputStream(entry);
                    Throwable throwable2 = null;
                    try {
                        OneShotByteResource resource;
                        if (ZipUtils.isDexFile(name)) {
                            resource = OneShotByteResource.create(ProgramResource.Kind.DEX, entryOrigin, ByteStreams.toByteArray(stream), null);
                            visitor.accept(resource);
                        } else if (ZipUtils.isClassFile(name)) {
                            resource = OneShotByteResource.create(ProgramResource.Kind.CF, entryOrigin, ByteStreams.toByteArray(stream), Collections.singleton(DescriptorUtils.guessTypeDescriptor(name)));
                            visitor.accept(resource);
                        }
                        if (stream == null) continue;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (stream == null) throw throwable4;
                            ArchiveResourceProvider.$closeResource(throwable2, stream);
                            throw throwable4;
                        }
                    }
                    ArchiveResourceProvider.$closeResource(throwable2, stream);
                }
                if (zipFile == null) return;
            }
            catch (Throwable throwable5) {
                try {
                    throwable = throwable5;
                    throw throwable5;
                }
                catch (Throwable throwable6) {
                    if (zipFile == null) throw throwable6;
                    ArchiveResourceProvider.$closeResource(throwable, zipFile);
                    throw throwable6;
                }
            }
            ArchiveResourceProvider.$closeResource(throwable, zipFile);
            return;
        }
        catch (ZipException e) {
            throw new ResourceException(this.origin, (Throwable)new CompilationError("Zip error while reading '" + this.archive + "': " + e.getMessage(), e));
        }
        catch (IOException e) {
            throw new ResourceException(this.origin, (Throwable)new CompilationError("I/O exception while reading '" + this.archive + "': " + e.getMessage(), e));
        }
    }
}

