/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.utils.BooleanUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;

public class ArrayUtils {
    public static boolean containsInt(int[] array, int value) {
        for (int element : array) {
            if (element != value) continue;
            return true;
        }
        return false;
    }

    public static <T> T[] copyWithSparseChanges(Class<T[]> clazz, T[] original, Map<Integer, T> changedElements) {
        T[] results = clazz.cast(Array.newInstance(clazz.getComponentType(), original.length));
        int pos = 0;
        for (Map.Entry<Integer, T> entry : changedElements.entrySet()) {
            int i = entry.getKey();
            System.arraycopy(original, pos, results, pos, i - pos);
            results[i] = entry.getValue();
            pos = i + 1;
        }
        if (pos < original.length) {
            System.arraycopy(original, pos, results, pos, original.length - pos);
        }
        return results;
    }

    public static <T> boolean isEmpty(T[] array) {
        return array.length == 0;
    }

    public static boolean isSorted(int[] array) {
        for (int i = 0; i < array.length - 1; ++i) {
            assert (array[i] < array[i + 1]);
        }
        return true;
    }

    public static int last(int[] array) {
        return array[array.length - 1];
    }

    public static <T> T last(T[] array) {
        return array[array.length - 1];
    }

    public static <T> T[] map(T[] original, Function<T, T> mapper, T[] emptyArray) {
        ArrayList<T> results = null;
        for (int i = 0; i < original.length; ++i) {
            T oldOne = original[i];
            T newOne = mapper.apply(oldOne);
            if (newOne == oldOne) {
                if (results == null) continue;
                results.add(oldOne);
                continue;
            }
            if (results == null) {
                results = new ArrayList<T>(original.length);
                for (int j = 0; j < i; ++j) {
                    results.add(original[j]);
                }
            }
            if (newOne == null) continue;
            results.add(newOne);
        }
        return results != null ? results.toArray(emptyArray) : original;
    }

    public static <T> T[] filter(T[] original, Predicate<T> predicate, T[] emptyArray) {
        return ArrayUtils.map(original, e -> predicate.test(e) ? e : null, emptyArray);
    }

    public static <T> T[] filter(T[] original, Predicate<T> predicate, T[] emptyArray, int newSize) {
        Object[] result = (Object[])Array.newInstance(emptyArray.getClass().getComponentType(), newSize);
        int newIndex = 0;
        for (int originalIndex = 0; originalIndex < original.length; ++originalIndex) {
            T element = original[originalIndex];
            if (!predicate.test(element)) continue;
            result[newIndex] = element;
            ++newIndex;
        }
        assert (newIndex == newSize);
        return result;
    }

    public static int[] createIdentityArray(int size) {
        int[] array = new int[size];
        for (int i = 0; i < size; ++i) {
            array[i] = i;
        }
        return array;
    }

    public static <T> boolean contains(T[] elements, T elementToLookFor) {
        for (T element : elements) {
            if (!element.equals(elementToLookFor)) continue;
            return true;
        }
        return false;
    }

    public static int[] fromPredicate(IntPredicate predicate, int size) {
        int[] result = new int[size];
        for (int i = 0; i < size; ++i) {
            result[i] = BooleanUtils.intValue(predicate.test(i));
        }
        return result;
    }

    public static void sumOfPredecessorsInclusive(int[] array) {
        for (int i = 1; i < array.length; ++i) {
            int n = i;
            array[n] = array[n] + array[i - 1];
        }
    }

    public static <T> T[] appendSingleElement(T[] ts, T element) {
        T[] newArray = Arrays.copyOf(ts, ts.length + 1);
        newArray[ts.length] = element;
        return newArray;
    }

    public static <T> T first(T[] ts) {
        return ts[0];
    }
}

