/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.AssertionsConfiguration;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.references.MethodReference;
import java.util.ArrayList;
import java.util.List;

public class AssertionConfigurationWithDefault {
    public final AssertionsConfiguration defaultConfiguration;
    public final List<AssertionsConfiguration> assertionsConfigurations;
    private final List<MethodReference> allAssertionHandlers;

    public AssertionConfigurationWithDefault(AssertionsConfiguration defautlTransformation, List<AssertionsConfiguration> assertionsConfigurations) {
        this.defaultConfiguration = defautlTransformation;
        assert (assertionsConfigurations != null);
        this.assertionsConfigurations = assertionsConfigurations;
        this.allAssertionHandlers = this.computeAllAssertionHandlers();
    }

    private List<MethodReference> computeAllAssertionHandlers() {
        assert (!this.defaultConfiguration.isAssertionHandler());
        if (this.assertionsConfigurations.isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<MethodReference> result = new ArrayList<MethodReference>();
        this.assertionsConfigurations.forEach(assertionsConfiguration -> {
            if (assertionsConfiguration.isAssertionHandler() && !result.contains(assertionsConfiguration.getAssertionHandler())) {
                result.add(assertionsConfiguration.getAssertionHandler());
            }
        });
        return result;
    }

    public boolean isPassthroughAll() {
        if (this.assertionsConfigurations.size() == 0) {
            return this.defaultConfiguration.getTransformation() == AssertionsConfiguration.AssertionTransformation.PASSTHROUGH;
        }
        return this.assertionsConfigurations.size() == 1 && this.assertionsConfigurations.get(0).getScope() == AssertionsConfiguration.AssertionTransformationScope.ALL && this.assertionsConfigurations.get(0).getTransformation() == AssertionsConfiguration.AssertionTransformation.PASSTHROUGH;
    }

    public List<MethodReference> getAllAssertionHandlers() {
        return this.allAssertionHandlers;
    }
}

