/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import java.util.Comparator;
import java.util.Objects;
import java.util.function.Supplier;

public class Box<T> {
    private T value;

    public Box() {
    }

    public Box(T initialValue) {
        this.set(initialValue);
    }

    public T computeIfAbsent(Supplier<T> supplier) {
        if (this.value == null) {
            this.value = supplier.get();
        }
        return this.value;
    }

    public T get() {
        return this.value;
    }

    public void set(T value) {
        this.value = value;
    }

    public void setMin(T element, Comparator<T> comparator) {
        if (!this.isSet() || comparator.compare(element, this.get()) < 0) {
            this.set(element);
        }
    }

    public boolean isSet() {
        return this.value != null;
    }

    public T getAndSet(T newValue) {
        T oldValue = this.value;
        this.value = newValue;
        return oldValue;
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Box box = (Box)object;
        return Objects.equals(this.value, box.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public void empty() {
        this.value = null;
    }
}

