/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.com.google.common.collect.ImmutableCollection;
import com.android.tools.r8.com.google.common.collect.ImmutableListMultimap;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Multimap;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.ClassKind;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.JarApplicationReader;
import com.android.tools.r8.graph.JarClassFileReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public abstract class ClassProvider<T extends DexClass> {
    private final ClassKind<T> classKind;

    ClassProvider(ClassKind<T> classKind) {
        this.classKind = classKind;
    }

    public static <T extends DexClass> ClassProvider<T> forClassFileResources(ClassKind<T> classKind, ClassFileResourceProvider provider, JarApplicationReader reader) {
        return new ClassFileResourceReader(classKind, provider, reader);
    }

    public static <T extends DexClass> ClassProvider<T> forPreloadedClasses(ClassKind<T> classKind, Collection<T> classes) {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (DexClass clazz : classes) {
            builder.put(clazz.type, clazz);
        }
        return new PreloadedClassProvider(classKind, builder.build());
    }

    public static <T extends DexClass> ClassProvider<T> combine(ClassKind<T> classKind, List<ClassProvider<T>> providers) {
        return new CombinedClassProvider(classKind, providers);
    }

    final ClassKind<T> getClassKind() {
        return this.classKind;
    }

    public abstract void collectClass(DexType var1, Consumer<T> var2);

    public abstract Collection<DexType> collectTypes();

    public FilteringClassProvider<T> without(Set<DexType> filteredTypes) {
        return new FilteringClassProvider<T>(this.classKind, this, filteredTypes);
    }

    private static class CombinedClassProvider<T extends DexClass>
    extends ClassProvider<T> {
        private final List<ClassProvider<T>> providers;

        private CombinedClassProvider(ClassKind<T> classKind, List<ClassProvider<T>> providers) {
            super(classKind);
            this.providers = providers;
        }

        @Override
        public void collectClass(DexType type, Consumer<T> classConsumer) {
            for (ClassProvider<T> provider : this.providers) {
                provider.collectClass(type, classConsumer);
            }
        }

        @Override
        public Collection<DexType> collectTypes() {
            Set<DexType> types = Sets.newIdentityHashSet();
            for (ClassProvider<T> provider : this.providers) {
                types.addAll(provider.collectTypes());
            }
            return types;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            String prefix = "combined(";
            for (ClassProvider<T> provider : this.providers) {
                builder.append(prefix);
                prefix = ", ";
                builder.append(provider);
            }
            return builder.append(")").toString();
        }
    }

    private static class FilteringClassProvider<T extends DexClass>
    extends ClassProvider<T> {
        private final ClassProvider<T> provider;
        private final Set<DexType> filteredOut;

        FilteringClassProvider(ClassKind<T> classKind, ClassProvider<T> provider, Set<DexType> filteredOut) {
            super(classKind);
            assert (!(provider instanceof FilteringClassProvider)) : "Nested Filtering class providers";
            this.provider = provider;
            this.filteredOut = filteredOut;
        }

        @Override
        public FilteringClassProvider<T> without(Set<DexType> filteredTypes) {
            ImmutableCollection newSet = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(this.filteredOut)).addAll(filteredTypes)).build();
            return new FilteringClassProvider(this.getClassKind(), this.provider, (Set<DexType>)((Object)newSet));
        }

        @Override
        public void collectClass(DexType type, Consumer<T> classConsumer) {
            if (this.filteredOut.contains(type)) {
                return;
            }
            this.provider.collectClass(type, classConsumer);
        }

        @Override
        public Collection<DexType> collectTypes() {
            Collection<DexType> dexTypes = this.provider.collectTypes();
            dexTypes.removeAll(this.filteredOut);
            return dexTypes;
        }

        public String toString() {
            return this.provider + " without " + this.filteredOut;
        }
    }

    private static class PreloadedClassProvider<T extends DexClass>
    extends ClassProvider<T> {
        private final Multimap<DexType, T> classes;

        private PreloadedClassProvider(ClassKind<T> classKind, Multimap<DexType, T> classes) {
            super(classKind);
            this.classes = classes;
        }

        @Override
        public void collectClass(DexType type, Consumer<T> classConsumer) {
            for (DexClass clazz : this.classes.get(type)) {
                classConsumer.accept(clazz);
            }
        }

        @Override
        public Collection<DexType> collectTypes() {
            return this.classes.keys();
        }

        public String toString() {
            return "preloaded(" + this.classes.size() + ")";
        }
    }

    private static class ClassFileResourceReader<T extends DexClass>
    extends ClassProvider<T> {
        private final ClassKind<T> classKind;
        private final ClassFileResourceProvider provider;
        private final JarApplicationReader reader;

        private ClassFileResourceReader(ClassKind<T> classKind, ClassFileResourceProvider provider, JarApplicationReader reader) {
            super(classKind);
            this.classKind = classKind;
            this.provider = provider;
            this.reader = reader;
        }

        @Override
        public void collectClass(DexType type, Consumer<T> classConsumer) {
            String descriptor = type.descriptor.toString();
            ProgramResource resource = this.provider.getProgramResource(descriptor);
            if (resource != null) {
                try {
                    JarClassFileReader<T> classReader = new JarClassFileReader<T>(this.reader, classConsumer, this.classKind);
                    classReader.read(resource);
                }
                catch (ResourceException e) {
                    throw new CompilationError("Failed to load class: " + descriptor, e);
                }
            }
        }

        @Override
        public Collection<DexType> collectTypes() {
            ArrayList<DexType> types = new ArrayList<DexType>();
            for (String descriptor : this.provider.getClassDescriptors()) {
                types.add(this.reader.options.itemFactory.createType(descriptor));
            }
            return types;
        }

        public String toString() {
            return "class-resource-provider(" + this.provider.toString() + ")";
        }
    }
}

