/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.errors.Unreachable;
import java.util.Comparator;
import java.util.List;

public class ComparatorUtils {
    public static <T extends Comparable<T>> Comparator<List<T>> listComparator() {
        return ComparatorUtils.listComparator(Comparable::compareTo);
    }

    public static <T> Comparator<List<T>> listComparator(Comparator<T> comparator) {
        return (xs, ys) -> {
            int diff = Integer.compare(xs.size(), ys.size());
            for (int i = 0; i < xs.size() && diff == 0; ++i) {
                diff = comparator.compare(xs.get(i), ys.get(i));
            }
            return diff;
        };
    }

    public static int compareInts(int ... ints) {
        assert (ints.length % 2 == 0);
        int diff = 0;
        int i = 0;
        while (i < ints.length && diff == 0) {
            diff = Integer.compare(ints[i++], ints[i++]);
        }
        return diff;
    }

    public static int compareIntArray(int[] xs, int[] ys) {
        int diff = Integer.compare(xs.length, ys.length);
        for (int i = 0; i < xs.length && diff == 0; ++i) {
            diff = Integer.compare(xs[i], ys[i]);
        }
        return diff;
    }

    public static int compareShortArray(short[] xs, short[] ys) {
        int diff = Integer.compare(xs.length, ys.length);
        for (int i = 0; i < xs.length && diff == 0; ++i) {
            diff = Short.compare(xs[i], ys[i]);
        }
        return diff;
    }

    public static <T extends Comparable<T>> Comparator<T[]> arrayComparator() {
        return ComparatorUtils.arrayComparator(Comparable::compareTo);
    }

    public static <T> Comparator<T[]> arrayComparator(Comparator<T> comparator) {
        return (xs, ys) -> {
            int diff = Integer.compare(((Object[])xs).length, ((Object[])ys).length);
            for (int i = 0; i < ((Object[])xs).length && diff == 0; ++i) {
                diff = comparator.compare(xs[i], ys[i]);
            }
            return diff;
        };
    }

    public static <T> Comparator<T> unreachableComparator() {
        return (t1, t2) -> {
            throw new Unreachable();
        };
    }
}

