/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import java.util.Comparator;

public enum CompareResult {
    LESS_THAN(-1),
    EQUAL(0),
    GREATER_THAN(1);

    private int comparisonResult;

    private CompareResult(int comparisonResult) {
        this.comparisonResult = comparisonResult;
    }

    public static <T extends Comparable<T>> CompareResult compare(T element, T other) {
        return CompareResult.fromComparisonResult(element.compareTo(other));
    }

    public static <T> CompareResult compare(T element, T other, Comparator<T> comparator) {
        return CompareResult.fromComparisonResult(comparator.compare(element, other));
    }

    public static CompareResult fromComparisonResult(int comparisonResult) {
        if (comparisonResult < 0) {
            return LESS_THAN;
        }
        return comparisonResult == 0 ? EQUAL : GREATER_THAN;
    }

    public int getComparisonResult() {
        return this.comparisonResult;
    }

    public boolean isEqual() {
        return this == EQUAL;
    }
}

