/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.utils.ThrowingConsumer;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class ConsumerUtils {
    public static <S, T> Function<S, Consumer<T>> curry(BiConsumer<S, T> function) {
        return arg -> arg2 -> function.accept(arg, arg2);
    }

    public static <S, T> Consumer<T> apply(BiConsumer<S, T> function, S arg) {
        return ConsumerUtils.curry(function).apply(arg);
    }

    public static <T> void acceptIfNotNull(T element, Consumer<T> consumer) {
        if (element != null) {
            consumer.accept(element);
        }
    }

    public static <T> Consumer<T> acceptIfNotSeen(Consumer<T> consumer, Set<T> seen) {
        return element -> {
            if (seen.add(element)) {
                consumer.accept(element);
            }
        };
    }

    public static <S, T, R> BiConsumer<S, T> andThen(BiFunction<S, T, R> function, Consumer<R> consumer) {
        return (s2, t) -> consumer.accept(function.apply(s2, t));
    }

    public static <T> Consumer<T> emptyConsumer() {
        return ignore -> {};
    }

    public static <S, T> BiConsumer<S, T> emptyBiConsumer() {
        return (s2, t) -> {};
    }

    public static <T> ThrowingConsumer<T, RuntimeException> emptyThrowingConsumer() {
        return ignore -> {};
    }
}

