/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DisjointSets<T> {
    private final Map<T, T> parent = new HashMap<T, T>();

    public T makeSet(T element) {
        assert (!this.parent.containsKey(element));
        this.parent.put(element, element);
        assert (this.findSet(element) == element);
        return element;
    }

    public T findSet(T element) {
        T candidate = this.parent.get(element);
        if (candidate == null) {
            return null;
        }
        T candidateParent = this.parent.get(candidate);
        if (candidate == candidateParent) {
            return candidate;
        }
        T representative = this.findSet(candidateParent);
        this.parent.put(element, representative);
        return representative;
    }

    public boolean isRepresentativeOrNotPresent(T element) {
        T representative = this.findSet(element);
        return representative == null || representative.equals(element);
    }

    public Set<T> collectSet(T element) {
        T representative = this.findSet(element);
        if (representative == null) {
            return null;
        }
        HashSet<T> result = new HashSet<T>();
        for (T t : this.parent.keySet()) {
            if (!this.findSet(t).equals(representative)) continue;
            result.add(t);
        }
        return result;
    }

    public T findOrMakeSet(T element) {
        T representative = this.findSet(element);
        return representative != null ? representative : this.makeSet(element);
    }

    public T union(T representative1, T representative2) {
        assert (representative1 != null);
        assert (representative2 != null);
        if (representative1 == representative2) {
            return representative1;
        }
        assert (this.parent.get(representative1) == representative1);
        assert (this.parent.get(representative2) == representative2);
        this.parent.put(representative2, representative1);
        assert (this.findSet(representative1) == representative1);
        assert (this.findSet(representative2) == representative1);
        return representative1;
    }

    public T unionWithMakeSet(T element1, T element2) {
        if (element1.toString().contains("Enum") || element2.toString().contains("Enum")) {
            System.out.println();
        }
        if (element1 == element2) {
            return this.findOrMakeSet(element1);
        }
        return this.union(this.findOrMakeSet(element1), this.findOrMakeSet(element2));
    }

    public Map<T, Set<T>> collectSets() {
        HashMap<Object, Set> unification = new HashMap<Object, Set>();
        for (T element : this.parent.keySet()) {
            T representative = this.findSet(element);
            unification.computeIfAbsent(representative, k -> new HashSet()).add(element);
        }
        return unification;
    }

    public String toString() {
        Map<T, Set<T>> sets = this.collectSets();
        StringBuilder sb = new StringBuilder().append("Number of sets: ").append(sets.keySet().size()).append(System.lineSeparator());
        sets.forEach((representative, set) -> {
            sb.append("Representative: ").append(representative).append(System.lineSeparator());
            set.forEach(v -> sb.append("    ").append(v).append(System.lineSeparator()));
        });
        return sb.toString();
    }
}

