/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.StringConsumer;
import com.android.tools.r8.Version;
import com.android.tools.r8.com.google.common.collect.ObjectArrays;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.position.Position;
import com.android.tools.r8.utils.AbortException;
import com.android.tools.r8.utils.ExceptionDiagnostic;
import com.android.tools.r8.utils.Reporter;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class ExceptionUtils {
    public static String getMainStackTrace() {
        return Thread.getAllStackTraces().entrySet().stream().filter(x -> ((Thread)x.getKey()).getName().equals("main")).map(x -> (StackTraceElement[])x.getValue()).flatMap(x -> Stream.of(x)).map(x -> x.toString()).collect(Collectors.joining(System.lineSeparator()));
    }

    public static void withConsumeResourceHandler(Reporter reporter, StringConsumer consumer, String data2) {
        ExceptionUtils.withConsumeResourceHandler(reporter, handler -> consumer.accept(data2, (DiagnosticsHandler)handler));
    }

    public static void withFinishedResourceHandler(Reporter reporter, StringConsumer consumer) {
        ExceptionUtils.withConsumeResourceHandler(reporter, consumer::finished);
    }

    public static void withConsumeResourceHandler(Reporter reporter, Consumer<DiagnosticsHandler> consumer) {
        consumer.accept(reporter);
        reporter.failIfPendingErrors();
    }

    public static void withD8CompilationHandler(Reporter reporter, CompileAction action) throws CompilationFailedException {
        ExceptionUtils.withCompilationHandler(reporter, action);
    }

    public static void withR8CompilationHandler(Reporter reporter, CompileAction action) throws CompilationFailedException {
        ExceptionUtils.withCompilationHandler(reporter, action);
    }

    public static void withMainDexListHandler(Reporter reporter, CompileAction action) throws CompilationFailedException {
        ExceptionUtils.withCompilationHandler(reporter, action);
    }

    public static void withCompilationHandler(Reporter reporter, CompileAction action) throws CompilationFailedException {
        try {
            action.run();
            reporter.failIfPendingErrors();
        }
        catch (Throwable e) {
            throw ExceptionUtils.failCompilation(reporter, e);
        }
    }

    private static CompilationFailedException failCompilation(Reporter reporter, Throwable topMostException) {
        return ExceptionUtils.failWithFakeEntry(reporter, topMostException, CompilationFailedException::new, AbortException.class);
    }

    public static <T extends Exception, A extends Exception> T failWithFakeEntry(DiagnosticsHandler diagnosticsHandler, Throwable topMostException, BiFunction<String, Throwable, T> newException, Class<A> abortException) {
        boolean hasBeenReported = false;
        Origin origin = Origin.unknown();
        Position position = Position.UNKNOWN;
        ArrayList<Throwable> suppressed = new ArrayList<Throwable>();
        Throwable innerMostCause = topMostException;
        while (true) {
            Position nextPosition;
            hasBeenReported |= abortException.isAssignableFrom(innerMostCause.getClass());
            Origin nextOrigin = ExceptionUtils.getOrigin(innerMostCause);
            if (nextOrigin != Origin.unknown()) {
                origin = nextOrigin;
            }
            if ((nextPosition = ExceptionUtils.getPosition(innerMostCause)) != Position.UNKNOWN) {
                position = nextPosition;
            }
            if (innerMostCause.getCause() == null || suppressed.contains(innerMostCause)) break;
            suppressed.add(innerMostCause);
            innerMostCause = innerMostCause.getCause();
        }
        if (topMostException != innerMostCause) {
            innerMostCause.addSuppressed(topMostException);
        }
        if (!hasBeenReported) {
            diagnosticsHandler.error(new ExceptionDiagnostic(innerMostCause, origin, position));
        }
        StringBuilder message = new StringBuilder("Compilation failed to complete");
        if (position != Position.UNKNOWN) {
            message.append(", position: ").append(position);
        }
        if (origin != Origin.unknown()) {
            message.append(", origin: ").append(origin);
        }
        Exception rethrow = (Exception)newException.apply(message.toString(), innerMostCause);
        String filename = "Version_main.java";
        StackTraceElement versionElement = new StackTraceElement(Version.class.getSimpleName(), "fakeStackEntry", filename, 0);
        rethrow.setStackTrace(ObjectArrays.concat(versionElement, rethrow.getStackTrace()));
        return (T)rethrow;
    }

    private static Origin getOrigin(Throwable e) {
        if (e instanceof IOException) {
            return ExceptionUtils.extractIOExceptionOrigin((IOException)e);
        }
        if (e instanceof CompilationError) {
            return ((CompilationError)e).getOrigin();
        }
        if (e instanceof ResourceException) {
            return ((ResourceException)e).getOrigin();
        }
        if (e instanceof OriginAttachmentException) {
            return ((OriginAttachmentException)e).origin;
        }
        if (e instanceof AbortException) {
            return ((AbortException)e).getOrigin();
        }
        return Origin.unknown();
    }

    private static Position getPosition(Throwable e) {
        if (e instanceof CompilationError) {
            return ((CompilationError)e).getPosition();
        }
        if (e instanceof OriginAttachmentException) {
            return ((OriginAttachmentException)e).position;
        }
        if (e instanceof AbortException) {
            return ((AbortException)e).getPosition();
        }
        return Position.UNKNOWN;
    }

    public static void withMainProgramHandler(MainAction action) {
        try {
            action.run();
        }
        catch (CompilationFailedException e) {
            ExceptionUtils.printExitMessage(e.getCause());
            throw new RuntimeException(e);
        }
        catch (RuntimeException e) {
            ExceptionUtils.printExitMessage(e);
            throw e;
        }
    }

    private static void printExitMessage(Throwable cause) {
        System.err.println(ExceptionUtils.isExpectedException(cause) ? "Compilation failed" : "Compilation failed with an internal error.");
    }

    private static boolean isExpectedException(Throwable e) {
        return e instanceof CompilationError || e instanceof AbortException;
    }

    private static Origin extractIOExceptionOrigin(IOException e) {
        FileSystemException fse;
        if (e instanceof FileSystemException && (fse = (FileSystemException)e).getFile() != null && !fse.getFile().isEmpty()) {
            return new PathOrigin(Paths.get(fse.getFile(), new String[0]));
        }
        return Origin.unknown();
    }

    public static RuntimeException unwrapExecutionException(ExecutionException executionException) {
        return new RuntimeException(executionException);
    }

    public static void withOriginAttachmentHandler(Origin origin, Runnable action) {
        ExceptionUtils.withOriginAndPositionAttachmentHandler(origin, Position.UNKNOWN, action);
    }

    public static <T> T withOriginAttachmentHandler(Origin origin, Supplier<T> action) {
        return ExceptionUtils.withOriginAndPositionAttachmentHandler(origin, Position.UNKNOWN, action);
    }

    public static void withOriginAndPositionAttachmentHandler(Origin origin, Position position, Runnable action) {
        ExceptionUtils.withOriginAndPositionAttachmentHandler(origin, position, () -> {
            action.run();
            return null;
        });
    }

    public static <T> T withOriginAndPositionAttachmentHandler(Origin origin, Position position, Supplier<T> action) {
        try {
            return action.get();
        }
        catch (RuntimeException e) {
            throw OriginAttachmentException.wrap(e, origin, position);
        }
    }

    private static class OriginAttachmentException
    extends RuntimeException {
        final Origin origin;
        final Position position;

        public static RuntimeException wrap(RuntimeException e, Origin origin, Position position) {
            return OriginAttachmentException.needsAttachment(e, origin, position) ? new OriginAttachmentException(e, origin, position) : e;
        }

        private OriginAttachmentException(RuntimeException e, Origin origin, Position position) {
            super(e);
            this.origin = origin;
            this.position = position;
        }

        private static boolean needsAttachment(RuntimeException e, Origin origin, Position position) {
            if (origin == Origin.unknown() && position == Position.UNKNOWN) {
                return false;
            }
            Origin existingOrigin = ExceptionUtils.getOrigin(e);
            Position existingPosition = ExceptionUtils.getPosition(e);
            return origin != existingOrigin || position != existingPosition;
        }
    }

    public static interface MainAction {
        public void run() throws CompilationFailedException;
    }

    public static interface CompileAction {
        public void run() throws IOException, CompilationError, ResourceException;
    }
}

