/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.primitives.Ints;
import com.android.tools.r8.utils.structural.StructuralItem;
import com.android.tools.r8.utils.structural.StructuralMapping;
import com.android.tools.r8.utils.structural.StructuralSpecification;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;

public class Int2StructuralItemArrayMap<T extends StructuralItem<T>>
implements StructuralItem<Int2StructuralItemArrayMap<T>> {
    private final int[] keys;
    private final List<T> values;

    private Int2StructuralItemArrayMap(int[] keys2, List<T> values2) {
        this.keys = keys2;
        this.values = values2;
        assert (keys2.length == values2.size());
    }

    private static <T extends StructuralItem<T>> void specify(StructuralSpecification<Int2StructuralItemArrayMap<T>, ?> spec) {
        ((StructuralSpecification)spec.withIntArray(p -> p.keys)).withItemCollection(p -> p.values);
    }

    public static <T extends StructuralItem<T>> Builder<T> builder() {
        return new Builder();
    }

    @Override
    public Int2StructuralItemArrayMap<T> self() {
        return this;
    }

    @Override
    public StructuralMapping<Int2StructuralItemArrayMap<T>> getStructuralMapping() {
        return Int2StructuralItemArrayMap::specify;
    }

    public T lookup(int key) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] != key) continue;
            return (T)((StructuralItem)this.values.get(i));
        }
        return null;
    }

    public void forEach(BiConsumer<Integer, T> visitor) {
        for (int i = 0; i < this.keys.length; ++i) {
            visitor.accept(this.keys[i], (Integer)((Object)((StructuralItem)this.values.get(i))));
        }
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof Int2StructuralItemArrayMap && this.compareTo((Int2StructuralItemArrayMap)other) == 0;
    }

    @Override
    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.keys), this.values);
    }

    public boolean isEmpty() {
        return this.keys.length == 0;
    }

    public static class Builder<T extends StructuralItem<T>> {
        private final List<Integer> keys = new ArrayList<Integer>();
        private final ImmutableList.Builder<T> values = ImmutableList.builder();

        private Builder() {
        }

        public Builder<T> put(int key, T value) {
            this.keys.add(key);
            this.values.add((Object)value);
            return this;
        }

        public boolean isEmpty() {
            return this.keys.isEmpty();
        }

        public Int2StructuralItemArrayMap<T> build() {
            return new Int2StructuralItemArrayMap(Ints.toArray(this.keys), (List)((Object)this.values.build()));
        }
    }
}

