/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.ClassFileConsumer;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.DataResourceConsumer;
import com.android.tools.r8.DesugarGraphConsumer;
import com.android.tools.r8.DexFilePerClassFileConsumer;
import com.android.tools.r8.DexIndexedConsumer;
import com.android.tools.r8.FeatureSplit;
import com.android.tools.r8.MapIdProvider;
import com.android.tools.r8.ProgramConsumer;
import com.android.tools.r8.SourceFileProvider;
import com.android.tools.r8.StringConsumer;
import com.android.tools.r8.Version;
import com.android.tools.r8.androidapi.ComputedApiLevel;
import com.android.tools.r8.cf.CfVersion;
import com.android.tools.r8.com.google.common.annotations.VisibleForTesting;
import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Lists;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.dex.Marker;
import com.android.tools.r8.dump.DumpOptions;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.ExperimentalClassFileVersionDiagnostic;
import com.android.tools.r8.errors.IncompleteNestNestDesugarDiagnosic;
import com.android.tools.r8.errors.InterfaceDesugarMissingTypeDiagnostic;
import com.android.tools.r8.errors.InvalidDebugInfoException;
import com.android.tools.r8.errors.InvalidLibrarySuperclassDiagnostic;
import com.android.tools.r8.errors.MissingNestHostNestDesugarDiagnostic;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.experimental.graphinfo.GraphConsumer;
import com.android.tools.r8.experimental.startup.StartupConfiguration;
import com.android.tools.r8.features.FeatureSplitConfiguration;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.classmerging.VerticallyMergedClasses;
import com.android.tools.r8.horizontalclassmerging.HorizontalClassMerger;
import com.android.tools.r8.horizontalclassmerging.HorizontallyMergedClasses;
import com.android.tools.r8.horizontalclassmerging.Policy;
import com.android.tools.r8.inspector.internal.InspectorImpl;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.desugar.TypeRewriter;
import com.android.tools.r8.ir.desugar.desugaredlibrary.DesugaredLibrarySpecification;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.MachineDesugaredLibrarySpecification;
import com.android.tools.r8.ir.desugar.nest.Nest;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.enums.EnumDataMap;
import com.android.tools.r8.naming.MapVersion;
import com.android.tools.r8.optimize.argumentpropagation.ArgumentPropagatorEventConsumer;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.position.Position;
import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.references.FieldReference;
import com.android.tools.r8.references.MethodReference;
import com.android.tools.r8.references.Reference;
import com.android.tools.r8.repackaging.Repackaging;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.GlobalKeepInfoConfiguration;
import com.android.tools.r8.shaking.ProguardConfiguration;
import com.android.tools.r8.shaking.ProguardConfigurationRule;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.AssertionConfigurationWithDefault;
import com.android.tools.r8.utils.Box;
import com.android.tools.r8.utils.ConsumerUtils;
import com.android.tools.r8.utils.DeterminismChecker;
import com.android.tools.r8.utils.DumpInputFlags;
import com.android.tools.r8.utils.IROrdering;
import com.android.tools.r8.utils.InternalOutputMode;
import com.android.tools.r8.utils.OffOrAuto;
import com.android.tools.r8.utils.Pair;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.StringUtils;
import com.android.tools.r8.utils.ThrowingBiConsumer;
import com.android.tools.r8.utils.Timing;
import com.android.tools.r8.utils.TriFunction;
import com.android.tools.r8.utils.VersionProperties;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import com.android.tools.r8.utils.structural.Ordered;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class InternalOptions
implements GlobalKeepInfoConfiguration {
    public static final boolean DETERMINISTIC_DEBUGGING = false;
    public static final boolean USE_METHOD_COLLECTION_CONCURRENCY_CHECKED = false;
    public static final CfVersion SUPPORTED_CF_VERSION = CfVersion.V17;
    public static final CfVersion EXPERIMENTAL_CF_VERSION = CfVersion.V12;
    public static final int SUPPORTED_DEX_VERSION = AndroidApiLevel.LATEST.getDexVersion().getIntValue();
    public static final int ASM_VERSION = 589824;
    public final DexItemFactory itemFactory;
    private final ProguardConfiguration proguardConfiguration;
    public final Reporter reporter;
    public ProgramConsumer programConsumer = null;
    public DataResourceConsumer dataResourceConsumer;
    public FeatureSplitConfiguration featureSplitConfiguration;
    public StartupConfiguration startupConfiguration;
    public List<Consumer<InspectorImpl>> outputInspections = Collections.emptyList();
    public boolean printTimes = System.getProperty("com.android.tools.r8.printtimes") != null;
    public boolean printMemory = System.getProperty("com.android.tools.r8.printmemory") != null;
    public String dumpInputToFile = System.getProperty("com.android.tools.r8.dumpinputtofile");
    public String dumpInputToDirectory = System.getProperty("com.android.tools.r8.dumpinputtodirectory");
    public boolean passthroughDexCode = false;
    public boolean enableNeverMergePrefixes = true;
    public Set<String> neverMergePrefixes = ImmutableSet.of("j$.");
    public boolean classpathInterfacesMayHaveStaticInitialization = false;
    public boolean libraryInterfacesMayHaveStaticInitialization = false;
    public boolean enableFieldBitAccessAnalysis = System.getProperty("com.android.tools.r8.fieldBitAccessAnalysis") != null;
    public boolean enableVerticalClassMerging = true;
    public boolean enableUnusedInterfaceRemoval = true;
    public boolean enableDevirtualization = true;
    public boolean enableEnumUnboxing = true;
    public boolean enableSimpleInliningConstraints = true;
    public final int simpleInliningConstraintThreshold;
    public boolean enableClassInlining = true;
    public boolean enableClassStaticizer = true;
    public boolean enableInitializedClassesAnalysis = true;
    public boolean enableSideEffectAnalysis = true;
    public boolean enableDeterminismAnalysis = true;
    public boolean enableServiceLoaderRewriting = true;
    public boolean enableNameReflectionOptimization = true;
    public boolean enableStringConcatenationOptimization = true;
    public boolean enableTreeShakingOfLibraryMethodOverrides = false;
    public boolean encodeChecksums = false;
    public BiPredicate<String, Long> dexClassChecksumFilter = (name, checksum) -> true;
    public boolean cfToCfDesugar = false;
    public boolean forceAnnotateSynthetics = false;
    public boolean readDebugSetFileEvent = false;
    public boolean disableL8AnnotationRemoval = System.getProperty("com.android.tools.r8.disableL8AnnotationRemoval") != null;
    public boolean enableVisibilityBridgeRemoval = true;
    public int callGraphLikelySpuriousCallEdgeThreshold = 50;
    public Thread mainThread = Thread.currentThread();
    public boolean enableSwitchRewriting = true;
    public boolean enableStringSwitchConversion = true;
    public int minimumStringSwitchSize = 3;
    public boolean enableEnumValueOptimization = true;
    public boolean enableEnumSwitchMapRemoval = true;
    public final OutlineOptions outline = new OutlineOptions();
    public boolean enableInitializedClassesInInstanceMethodsAnalysis = true;
    public boolean enableRedundantFieldLoadElimination = true;
    public boolean enableRedundantConstNumberOptimization = false;
    public String synthesizedClassPrefix = "";
    public int threadCount = -1;
    public boolean useSmaliSyntax = false;
    public boolean verbose = false;
    public boolean quiet = false;
    public boolean invalidDebugInfoFatal = false;
    public boolean invalidDebugInfoStrict = System.getProperty("com.android.tools.r8.strictdebuginfo") != null;
    public boolean ignoreJavaLibraryOverride = false;
    public boolean ignoreMainDexMissingClasses = false;
    public boolean enableCfByteCodePassThrough = false;
    public boolean createSingletonsForStatelessLambdas = System.getProperty("com.android.tools.r8.createSingletonsForStatelessLambdas") != null;
    public DumpOptions dumpOptions;
    private boolean hasMarker = false;
    private Marker marker;
    public Set<String> extensiveLoggingFilter = InternalOptions.getExtensiveLoggingFilter();
    public Set<String> extensiveInterfaceMethodMinifierLoggingFilter = InternalOptions.getExtensiveInterfaceMethodMinifierLoggingFilter();
    public List<String> methodsFilter = ImmutableList.of();
    private AndroidApiLevel minApiLevel = AndroidApiLevel.getDefault();
    public boolean intermediate = false;
    public boolean retainCompileTimeAnnotations = true;
    public boolean ignoreBootClasspathEnumsForMaindexTracing = System.getProperty("com.android.tools.r8.ignoreBootClasspathEnumsForMaindexTracing") != null;
    public boolean pruneNonVissibleAnnotationClasses = System.getProperty("com.android.tools.r8.pruneNonVissibleAnnotationClasses") != null;
    public List<String> logArgumentsFilter = ImmutableList.of();
    public boolean enableLoadStoreOptimization = true;
    public DesugarState desugarState = DesugarState.ON;
    public boolean enableNestReduction = true;
    public OffOrAuto interfaceMethodDesugaring = OffOrAuto.Auto;
    public OffOrAuto tryWithResourcesDesugaring = OffOrAuto.Auto;
    public boolean processCovariantReturnTypeAnnotations = true;
    public boolean lookupLibraryBeforeProgram = false;
    public boolean loadAllClassDefinitions = false;
    public boolean enableMainDexListCheck = true;
    private final boolean enableTreeShaking;
    private final boolean enableMinification;
    public boolean printCfg = false;
    public String printCfgFile;
    public boolean ignoreMissingClasses = false;
    public boolean reportMissingClassesInEnclosingMethodAttribute = false;
    public boolean reportMissingClassesInInnerClassAttributes = false;
    public boolean disableGenericSignatureValidation = false;
    public boolean forceProguardCompatibility = false;
    public AssertionConfigurationWithDefault assertionsConfiguration = null;
    public boolean configurationDebugging = false;
    public boolean skipIR = false;
    public boolean debug = false;
    private final CallSiteOptimizationOptions callSiteOptimizationOptions = new CallSiteOptimizationOptions();
    private final ClassInlinerOptions classInlinerOptions = new ClassInlinerOptions();
    private final InlinerOptions inlinerOptions = new InlinerOptions();
    private final HorizontalClassMergerOptions horizontalClassMergerOptions = new HorizontalClassMergerOptions();
    private final OpenClosedInterfacesOptions openClosedInterfacesOptions = new OpenClosedInterfacesOptions();
    private final ProtoShrinkingOptions protoShrinking = new ProtoShrinkingOptions();
    private final KotlinOptimizationOptions kotlinOptimizationOptions = new KotlinOptimizationOptions();
    private final ApiModelTestingOptions apiModelTestingOptions = new ApiModelTestingOptions();
    private final DesugarSpecificOptions desugarSpecificOptions = new DesugarSpecificOptions();
    public final TestingOptions testing = new TestingOptions();
    public List<ProguardConfigurationRule> mainDexKeepRules = ImmutableList.of();
    public boolean minimalMainDex;
    public boolean enableInheritanceClassInDexDistributor = true;
    public LineNumberOptimization lineNumberOptimization = LineNumberOptimization.ON;
    private final Map<Origin, List<TypeVersionPair>> missingEnclosingMembers = new HashMap<Origin, List<TypeVersionPair>>();
    private final Map<Origin, List<InvalidParameterAnnotationInfo>> warningInvalidParameterAnnotations = new HashMap<Origin, List<InvalidParameterAnnotationInfo>>();
    private final Map<Origin, List<Pair<ProgramMethod, String>>> warningInvalidDebugInfo = new HashMap<Origin, List<Pair<ProgramMethod, String>>>();
    public boolean skipReadingDexCode = false;
    public StringConsumer mainDexListConsumer = null;
    public StringConsumer proguardMapConsumer = null;
    public StringConsumer usageInformationConsumer = null;
    public StringConsumer proguardSeedsConsumer = null;
    public StringConsumer configurationConsumer = null;
    private ThrowingBiConsumer<Timing, DexApplication, IOException> loadMachineDesugaredLibrarySpecification = null;
    public MachineDesugaredLibrarySpecification machineDesugaredLibrarySpecification = MachineDesugaredLibrarySpecification.empty();
    public boolean relocatorCompilation = false;
    public StringConsumer desugaredLibraryKeepRuleConsumer = null;
    public GraphConsumer keptGraphConsumer = null;
    public GraphConsumer mainDexKeptGraphConsumer = null;
    public DesugarGraphConsumer desugarGraphConsumer = null;
    public Consumer<List<ProguardConfigurationRule>> syntheticProguardRulesConsumer = null;
    public MapIdProvider mapIdProvider = null;
    public SourceFileProvider sourceFileProvider = null;
    private final Set<DexItem> reportedMissingForDesugaring = Sets.newConcurrentHashSet();
    private final AtomicBoolean reportedErrorReadingKotlinMetadataReflectively = new AtomicBoolean(false);
    private final Set<DexItem> invalidLibraryClasses = Sets.newConcurrentHashSet();
    private final Box<Boolean> reportedExperimentClassFileVersion = new Box<Boolean>(false);

    public InternalOptions() {
        this.simpleInliningConstraintThreshold = 0;
        this.reporter = new Reporter();
        this.itemFactory = new DexItemFactory();
        this.proguardConfiguration = null;
        this.enableTreeShaking = false;
        this.enableMinification = false;
    }

    public InternalOptions(DexItemFactory factory, Reporter reporter) {
        this.simpleInliningConstraintThreshold = 0;
        assert (reporter != null);
        assert (factory != null);
        this.reporter = reporter;
        this.itemFactory = factory;
        this.proguardConfiguration = null;
        this.enableTreeShaking = false;
        this.enableMinification = false;
        this.disableGlobalOptimizations();
    }

    public InternalOptions(CompilationMode mode, ProguardConfiguration proguardConfiguration, Reporter reporter) {
        this.simpleInliningConstraintThreshold = 0;
        assert (reporter != null);
        assert (proguardConfiguration != null);
        this.debug = mode == CompilationMode.DEBUG;
        this.reporter = reporter;
        this.proguardConfiguration = proguardConfiguration;
        this.itemFactory = proguardConfiguration.getDexItemFactory();
        this.enableTreeShaking = proguardConfiguration.isShrinking();
        this.enableMinification = proguardConfiguration.isObfuscating();
        if (!proguardConfiguration.isOptimizing()) {
            this.disableAllOptimizations();
        }
        if (this.debug) {
            assert (!this.isMinifying());
            assert (!this.isOptimizing());
            this.keepDebugRelatedInformation();
        }
        this.configurationDebugging = proguardConfiguration.isConfigurationDebugging();
        if (proguardConfiguration.isProtoShrinkingEnabled()) {
            this.enableProtoShrinking();
        }
    }

    private void keepDebugRelatedInformation() {
        assert (!this.proguardConfiguration.isObfuscating());
        this.getProguardConfiguration().getKeepAttributes().sourceFile = true;
        this.getProguardConfiguration().getKeepAttributes().sourceDebugExtension = true;
        this.getProguardConfiguration().getKeepAttributes().lineNumberTable = true;
        this.getProguardConfiguration().getKeepAttributes().localVariableTable = true;
        this.getProguardConfiguration().getKeepAttributes().localVariableTypeTable = true;
    }

    private Marker createMarker(Marker.Tool tool) {
        if (tool == Marker.Tool.D8 && this.testing.dontCreateMarkerInD8) {
            return null;
        }
        Marker marker = new Marker(tool).setVersion("main").setCompilationMode(this.debug ? CompilationMode.DEBUG : CompilationMode.RELEASE).setBackend(this.isGeneratingClassFiles() ? Marker.Backend.CF : Marker.Backend.DEX).setHasChecksums(this.encodeChecksums);
        if (this.isGeneratingDex() || this.desugarState == DesugarState.ON) {
            marker.setMinApi(this.getMinApiLevel().getLevel());
        }
        if (this.machineDesugaredLibrarySpecification.getIdentifier() != null) {
            marker.setDesugaredLibraryIdentifiers(this.machineDesugaredLibrarySpecification.getIdentifier());
        }
        if (Version.isDevelopmentVersion()) {
            marker.setSha1(VersionProperties.INSTANCE.getSha());
        }
        if (tool == Marker.Tool.R8) {
            marker.setR8Mode(this.forceProguardCompatibility ? "compatibility" : "full");
        }
        return marker;
    }

    private static Set<String> getExtensiveLoggingFilter() {
        String property = System.getProperty("com.android.tools.r8.extensiveLoggingFilter");
        if (property != null) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (String method : property.split(";")) {
                builder.add(method);
            }
            return builder.build();
        }
        return ImmutableSet.of();
    }

    private static Set<String> getExtensiveInterfaceMethodMinifierLoggingFilter() {
        String property = System.getProperty("com.android.tools.r8.extensiveInterfaceMethodMinifierLoggingFilter");
        if (property != null) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (String method : property.split(";")) {
                builder.add(method);
            }
            return builder.build();
        }
        return ImmutableSet.of();
    }

    private static boolean isSystemPropertyForDevelopmentSet(String propertyName) {
        if (Version.isDevelopmentVersion()) {
            return System.getProperty(propertyName) != null;
        }
        return false;
    }

    private static int parseSystemPropertyForDevelopmentOrDefault(String propertyName, int defaultValue) {
        String propertyValue;
        if (Version.isDevelopmentVersion() && (propertyValue = System.getProperty(propertyName)) != null) {
            return Integer.parseInt(propertyValue);
        }
        return defaultValue;
    }

    public static boolean assertionsEnabled() {
        boolean assertionsEnabled = false;
        if (!$assertionsDisabled) {
            assertionsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return assertionsEnabled;
    }

    public static void checkAssertionsEnabled() {
        if (!InternalOptions.assertionsEnabled()) {
            throw new Unreachable();
        }
    }

    private static String messageErrorMissingNestHost(DexClass compiledClass) {
        String nestHostName = compiledClass.getNestHost().getName();
        return "Class " + compiledClass.type.getName() + " requires its nest host " + nestHostName + " to be on program or class path.";
    }

    private static String messageErrorIncompleteNest(Nest nest) {
        ArrayList programClassesFromNest = new ArrayList();
        ArrayList classpathClassesFromNest = new ArrayList();
        ArrayList libraryClassesFromNest = new ArrayList();
        nest.getHostClass().accept(programClassesFromNest::add, classpathClassesFromNest::add, libraryClassesFromNest::add);
        for (DexClass memberClass : nest.getMembers()) {
            memberClass.accept(programClassesFromNest::add, classpathClassesFromNest::add, libraryClassesFromNest::add);
        }
        StringBuilder stringBuilder = new StringBuilder("Compilation of classes ").append(StringUtils.join(", ", programClassesFromNest, DexClass::getTypeName)).append(" requires its nest mates ");
        if (nest.hasMissingMembers()) {
            stringBuilder.append(StringUtils.join(", ", nest.getMissingMembers(), DexType::getTypeName)).append(" (unavailable) ");
        }
        if (!libraryClassesFromNest.isEmpty()) {
            stringBuilder.append(StringUtils.join(", ", libraryClassesFromNest, DexClass::getTypeName)).append(" (on library path) ");
        }
        stringBuilder.append("to be on program or class path.");
        if (!classpathClassesFromNest.isEmpty()) {
            stringBuilder.append("(Classes ").append(StringUtils.join(", ", classpathClassesFromNest, DexClass::getTypeName)).append(" from the same nest are on class path).");
        }
        return stringBuilder.toString();
    }

    private boolean hasMinApi(AndroidApiLevel level) {
        return this.getMinApiLevel().isGreaterThanOrEqualTo(level);
    }

    static /* synthetic */ boolean access$000(String x0) {
        return InternalOptions.isSystemPropertyForDevelopmentSet(x0);
    }

    static /* synthetic */ int access$100(String x0, int x1) {
        return InternalOptions.parseSystemPropertyForDevelopmentOrDefault(x0, x1);
    }

    public DexItemFactory dexItemFactory() {
        return this.itemFactory;
    }

    public boolean hasProguardConfiguration() {
        return this.proguardConfiguration != null;
    }

    public ProguardConfiguration getProguardConfiguration() {
        return this.proguardConfiguration;
    }

    void enableProtoShrinking() {
        this.inlinerOptions.applyInliningToInlinee = true;
        this.enableFieldBitAccessAnalysis = true;
        this.protoShrinking.enableGeneratedMessageLiteShrinking = true;
        this.protoShrinking.enableGeneratedMessageLiteBuilderShrinking = true;
        this.protoShrinking.enableGeneratedExtensionRegistryShrinking = true;
        this.protoShrinking.enableEnumLiteProtoShrinking = true;
    }

    void disableAllOptimizations() {
        this.disableGlobalOptimizations();
        this.enableNameReflectionOptimization = false;
        this.enableStringConcatenationOptimization = false;
    }

    public void disableGlobalOptimizations() {
        this.inlinerOptions.enableInlining = false;
        this.enableClassInlining = false;
        this.enableDevirtualization = false;
        this.enableVerticalClassMerging = false;
        this.enableEnumUnboxing = false;
        this.outline.enabled = false;
        this.enableEnumValueOptimization = false;
        this.enableSideEffectAnalysis = false;
        this.enableTreeShakingOfLibraryMethodOverrides = false;
        this.enableInitializedClassesAnalysis = false;
        this.callSiteOptimizationOptions.disableOptimization();
        this.horizontalClassMergerOptions.setRestrictToSynthetics();
        this.apiModelTestingOptions.disableApiCallerIdentification();
    }

    public int verificationSizeLimitInBytes() {
        if (this.testing.verificationSizeLimitInBytesOverride > -1) {
            return this.testing.verificationSizeLimitInBytesOverride;
        }
        return this.isGeneratingClassFiles() ? 65534 : 16383;
    }

    public int minimumVerificationSizeLimitInBytes() {
        if (this.testing.verificationSizeLimitInBytesOverride > -1) {
            return this.testing.verificationSizeLimitInBytesOverride;
        }
        return 16383;
    }

    public void setMarker(Marker marker) {
        this.hasMarker = true;
        this.marker = marker;
    }

    public Marker getMarker(Marker.Tool tool) {
        if (this.hasMarker) {
            return this.marker;
        }
        return this.createMarker(tool);
    }

    public void setDumpInputFlags(DumpInputFlags dumpInputFlags, boolean skipDump) {
        if (skipDump) {
            this.dumpInputToDirectory = null;
            this.dumpInputToFile = null;
            return;
        }
        if (dumpInputFlags.getDumpInputToFile() != null) {
            this.dumpInputToFile = dumpInputFlags.getDumpInputToFile().toString();
        }
        if (dumpInputFlags.getDumpInputToDirectory() != null) {
            this.dumpInputToDirectory = dumpInputFlags.getDumpInputToDirectory().toString();
        }
    }

    public boolean hasConsumer() {
        return this.programConsumer != null;
    }

    public InternalOutputMode getInternalOutputMode() {
        assert (this.hasConsumer());
        if (this.isGeneratingDexIndexed()) {
            return InternalOutputMode.DexIndexed;
        }
        if (this.isGeneratingDexFilePerClassFile()) {
            return InternalOutputMode.DexFilePerClassFile;
        }
        if (this.isGeneratingClassFiles()) {
            return InternalOutputMode.ClassFile;
        }
        throw new UnsupportedOperationException("Cannot find internal output mode.");
    }

    public boolean isAndroidPlatform() {
        return this.minApiLevel == AndroidApiLevel.ANDROID_PLATFORM;
    }

    public boolean isDesugaredLibraryCompilation() {
        return this.machineDesugaredLibrarySpecification.isLibraryCompilation();
    }

    public boolean isRelocatorCompilation() {
        return this.relocatorCompilation;
    }

    public boolean shouldBackportMethods() {
        return !this.hasConsumer() || this.isGeneratingDex() || this.cfToCfDesugar;
    }

    public boolean shouldKeepStackMapTable() {
        assert (this.cfToCfDesugar || this.isRelocatorCompilation() || this.getProguardConfiguration() != null);
        return this.cfToCfDesugar || this.isRelocatorCompilation() || this.getProguardConfiguration().getKeepAttributes().stackMapTable;
    }

    public boolean shouldRerunEnqueuer() {
        return this.isShrinking() || this.isMinifying() || this.getProguardConfiguration().hasApplyMappingFile();
    }

    public boolean isGeneratingDex() {
        return this.isGeneratingDexIndexed() || this.isGeneratingDexFilePerClassFile();
    }

    public boolean isGeneratingDexIndexed() {
        return this.programConsumer instanceof DexIndexedConsumer;
    }

    public boolean isGeneratingDexFilePerClassFile() {
        return this.programConsumer instanceof DexFilePerClassFileConsumer;
    }

    public boolean isGeneratingClassFiles() {
        return this.programConsumer instanceof ClassFileConsumer;
    }

    public boolean isDesugaring() {
        return !this.isGeneratingClassFiles() || this.cfToCfDesugar;
    }

    public DexIndexedConsumer getDexIndexedConsumer() {
        return (DexIndexedConsumer)this.programConsumer;
    }

    public DexFilePerClassFileConsumer getDexFilePerClassFileConsumer() {
        return (DexFilePerClassFileConsumer)this.programConsumer;
    }

    public ClassFileConsumer getClassFileConsumer() {
        return (ClassFileConsumer)this.programConsumer;
    }

    public void signalFinishedToConsumers() {
        if (this.programConsumer != null) {
            this.programConsumer.finished(this.reporter);
            if (this.dataResourceConsumer != null) {
                this.dataResourceConsumer.finished(this.reporter);
            }
        }
        if (this.featureSplitConfiguration != null) {
            for (FeatureSplit featureSplit : this.featureSplitConfiguration.getFeatureSplits()) {
                ProgramConsumer programConsumer = featureSplit.getProgramConsumer();
                programConsumer.finished(this.reporter);
                DataResourceConsumer dataResourceConsumer = programConsumer.getDataResourceConsumer();
                if (dataResourceConsumer == null) continue;
                dataResourceConsumer.finished(this.reporter);
            }
        }
        if (this.desugarGraphConsumer != null) {
            this.desugarGraphConsumer.finished();
        }
    }

    public boolean shouldDesugarNests() {
        return !this.canUseNestBasedAccess();
    }

    public boolean shouldDesugarRecords() {
        return this.desugarState.isOn() && !this.canUseRecords();
    }

    public AndroidApiLevel getMinApiLevel() {
        return this.minApiLevel;
    }

    public void setMinApiLevel(AndroidApiLevel minApiLevel) {
        assert (minApiLevel != null);
        this.minApiLevel = minApiLevel;
    }

    public boolean isOptimizing() {
        return this.hasProguardConfiguration() && this.getProguardConfiguration().isOptimizing();
    }

    public boolean isRelease() {
        return !this.debug;
    }

    public boolean isShrinking() {
        assert (this.proguardConfiguration == null || this.enableTreeShaking == this.proguardConfiguration.isShrinking());
        return this.enableTreeShaking;
    }

    public boolean isMinifying() {
        assert (this.proguardConfiguration == null || this.enableMinification == this.proguardConfiguration.isObfuscating());
        return this.enableMinification;
    }

    @Override
    public boolean isAnnotationRemovalEnabled() {
        return !this.isForceProguardCompatibilityEnabled();
    }

    @Override
    public boolean isTreeShakingEnabled() {
        return this.isShrinking();
    }

    @Override
    public boolean isMinificationEnabled() {
        return this.isMinifying();
    }

    @Override
    public boolean isOptimizationEnabled() {
        return this.isOptimizing();
    }

    @Override
    public boolean isRepackagingEnabled() {
        return this.proguardConfiguration.getPackageObfuscationMode().isSome() && this.isMinifying();
    }

    @Override
    public boolean isForceProguardCompatibilityEnabled() {
        return this.forceProguardCompatibility;
    }

    public boolean parseSignatureAttribute() {
        return this.isKeepAttributesSignatureEnabled();
    }

    @Override
    public boolean isKeepAttributesSignatureEnabled() {
        return this.proguardConfiguration == null || this.proguardConfiguration.getKeepAttributes().signature;
    }

    @Override
    public boolean isKeepEnclosingMethodAttributeEnabled() {
        return this.proguardConfiguration.getKeepAttributes().enclosingMethod;
    }

    @Override
    public boolean isKeepInnerClassesAttributeEnabled() {
        return this.proguardConfiguration.getKeepAttributes().innerClasses;
    }

    @Override
    public boolean isKeepRuntimeInvisibleAnnotationsEnabled() {
        return this.proguardConfiguration.getKeepAttributes().runtimeInvisibleAnnotations;
    }

    @Override
    public boolean isKeepRuntimeInvisibleParameterAnnotationsEnabled() {
        return this.proguardConfiguration.getKeepAttributes().runtimeInvisibleParameterAnnotations;
    }

    @Override
    public boolean isKeepRuntimeVisibleAnnotationsEnabled() {
        return this.proguardConfiguration.getKeepAttributes().runtimeVisibleAnnotations;
    }

    @Override
    public boolean isKeepRuntimeVisibleParameterAnnotationsEnabled() {
        return this.proguardConfiguration.getKeepAttributes().runtimeVisibleParameterAnnotations;
    }

    public boolean isClassMergingExtensionRequired(Enqueuer.Mode mode) {
        if (mode.isInitialTreeShaking()) {
            return this.horizontalClassMergerOptions.isEnabled(HorizontalClassMerger.Mode.INITIAL) && !this.horizontalClassMergerOptions.isRestrictedToSynthetics() || this.enableVerticalClassMerging;
        }
        if (mode.isFinalTreeShaking()) {
            return this.horizontalClassMergerOptions.isEnabled(HorizontalClassMerger.Mode.FINAL) && !this.horizontalClassMergerOptions.isRestrictedToSynthetics();
        }
        assert (false);
        return false;
    }

    @Override
    public boolean isAccessModificationEnabled() {
        return this.getProguardConfiguration() != null && this.getProguardConfiguration().isAccessModificationAllowed();
    }

    @Override
    public boolean isMethodStaticizingEnabled() {
        return this.callSiteOptimizationOptions().isMethodStaticizingEnabled();
    }

    public boolean keepInnerClassStructure() {
        return this.getProguardConfiguration().getKeepAttributes().signature || this.getProguardConfiguration().getKeepAttributes().innerClasses;
    }

    public boolean canUseInputStackMaps() {
        return this.testing.readInputStackMaps ? this.testing.readInputStackMaps : this.isGeneratingClassFiles();
    }

    public CallSiteOptimizationOptions callSiteOptimizationOptions() {
        return this.callSiteOptimizationOptions;
    }

    public ClassInlinerOptions classInlinerOptions() {
        return this.classInlinerOptions;
    }

    public InlinerOptions inlinerOptions() {
        return this.inlinerOptions;
    }

    public HorizontalClassMergerOptions horizontalClassMergerOptions() {
        return this.horizontalClassMergerOptions;
    }

    public ProtoShrinkingOptions protoShrinking() {
        return this.protoShrinking;
    }

    public KotlinOptimizationOptions kotlinOptimizationOptions() {
        return this.kotlinOptimizationOptions;
    }

    public ApiModelTestingOptions apiModelingOptions() {
        return this.apiModelTestingOptions;
    }

    public DesugarSpecificOptions desugarSpecificOptions() {
        return this.desugarSpecificOptions;
    }

    public OpenClosedInterfacesOptions getOpenClosedInterfacesOptions() {
        return this.openClosedInterfacesOptions;
    }

    public boolean hasUsageInformationConsumer() {
        return this.usageInformationConsumer != null;
    }

    public void setDesugaredLibrarySpecification(DesugaredLibrarySpecification specification) {
        if (specification.isEmpty()) {
            return;
        }
        this.loadMachineDesugaredLibrarySpecification = (timing, app) -> {
            this.machineDesugaredLibrarySpecification = specification.toMachineSpecification((DexApplication)app, (Timing)timing);
        };
    }

    public void loadMachineDesugaredLibrarySpecification(Timing timing, DexApplication app) throws IOException {
        if (this.loadMachineDesugaredLibrarySpecification == null) {
            return;
        }
        timing.begin("Load machine specification");
        this.loadMachineDesugaredLibrarySpecification.accept(timing, app);
        timing.end();
    }

    public TypeRewriter getTypeRewriter() {
        return this.machineDesugaredLibrarySpecification.getRewriteType().isEmpty() ? TypeRewriter.empty() : new TypeRewriter.MachineDesugarPrefixRewritingMapper(this.machineDesugaredLibrarySpecification);
    }

    public RuntimeException errorMissingNestHost(DexClass clazz) {
        throw this.reporter.fatalError(new MissingNestHostNestDesugarDiagnostic(clazz.getOrigin(), Position.UNKNOWN, InternalOptions.messageErrorMissingNestHost(clazz)));
    }

    public RuntimeException errorMissingNestMember(Nest nest) {
        throw this.reporter.fatalError(new IncompleteNestNestDesugarDiagnosic(nest.getHostClass().getOrigin(), Position.UNKNOWN, InternalOptions.messageErrorIncompleteNest(nest)));
    }

    public void warningMissingTypeForDesugar(Origin origin, Position position, DexType missingType, DexMethod context) {
        if (this.reportedMissingForDesugaring.add(missingType)) {
            this.reporter.warning(new InterfaceDesugarMissingTypeDiagnostic(origin, position, Reference.classFromDescriptor(missingType.toDescriptorString()), Reference.classFromDescriptor(context.holder.toDescriptorString()), null));
        }
    }

    public void warningMissingInterfaceForDesugar(DexClass classToDesugar, DexClass implementing, DexType missing) {
        if (this.reportedMissingForDesugaring.add(missing)) {
            this.reporter.warning(new InterfaceDesugarMissingTypeDiagnostic(classToDesugar.getOrigin(), Position.UNKNOWN, Reference.classFromDescriptor(missing.toDescriptorString()), Reference.classFromDescriptor(classToDesugar.getType().toDescriptorString()), classToDesugar == implementing ? null : Reference.classFromDescriptor(implementing.getType().toDescriptorString())));
        }
    }

    public void warningReadingKotlinMetadataReflective() {
        if (this.reportedErrorReadingKotlinMetadataReflectively.compareAndSet(false, true)) {
            this.reporter.warning(new StringDiagnostic("Could not read the kotlin metadata message reflectively which indicates the compiler running in the context of a Security Manager. Not being able to read the kotlin metadata will have a negative effect oncode size"));
        }
    }

    public void warningInvalidLibrarySuperclassForDesugar(Origin origin, DexType libraryType, DexType invalidSuperType, String message, Set<DexMethod> retarget) {
        if (this.invalidLibraryClasses.add(invalidSuperType)) {
            this.reporter.warning(new InvalidLibrarySuperclassDiagnostic(origin, Reference.classFromDescriptor(libraryType.toDescriptorString()), Reference.classFromDescriptor(invalidSuperType.toDescriptorString()), message, Lists.newArrayList(Iterables.transform(retarget, method -> method.asMethodReference()))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warningMissingEnclosingMember(DexType clazz, Origin origin, CfVersion version) {
        TypeVersionPair pair = new TypeVersionPair(version, clazz);
        Map<Origin, List<TypeVersionPair>> map = this.missingEnclosingMembers;
        synchronized (map) {
            this.missingEnclosingMembers.computeIfAbsent(origin, k -> new ArrayList()).add(pair);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warningInvalidParameterAnnotations(DexMethod method, Origin origin, int expected, int actual) {
        InvalidParameterAnnotationInfo info = new InvalidParameterAnnotationInfo(method, expected, actual);
        Map<Origin, List<InvalidParameterAnnotationInfo>> map = this.warningInvalidParameterAnnotations;
        synchronized (map) {
            this.warningInvalidParameterAnnotations.computeIfAbsent(origin, k -> new ArrayList()).add(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warningInvalidDebugInfo(ProgramMethod method, Origin origin, InvalidDebugInfoException e) {
        if (this.invalidDebugInfoFatal) {
            throw new CompilationError("Fatal warning: Invalid debug info", e);
        }
        Map<Origin, List<Pair<ProgramMethod, String>>> map = this.warningInvalidDebugInfo;
        synchronized (map) {
            this.warningInvalidDebugInfo.computeIfAbsent(origin, k -> new ArrayList()).add(new Pair<ProgramMethod, String>(method, e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warningExperimentalClassFileVersion(Origin origin) {
        Box<Boolean> box = this.reportedExperimentClassFileVersion;
        synchronized (box) {
            if (this.reportedExperimentClassFileVersion.get().booleanValue()) {
                return;
            }
            this.reportedExperimentClassFileVersion.set(true);
            this.reporter.warning(new ExperimentalClassFileVersionDiagnostic(origin, "One or more classes has class file version >= " + EXPERIMENTAL_CF_VERSION.major() + " which is not officially supported."));
        }
    }

    public boolean printWarnings() {
        StringBuilder builder;
        boolean printed = false;
        boolean printOutdatedToolchain = false;
        if (this.warningInvalidParameterAnnotations.size() > 0) {
            this.reporter.info(new StringDiagnostic("Invalid parameter counts in MethodParameter attributes. This is likely due to Proguard having removed a parameter."));
            for (Origin origin : new TreeSet<Origin>(this.warningInvalidParameterAnnotations.keySet())) {
                builder = new StringBuilder("Methods with invalid MethodParameter attributes:");
                for (InvalidParameterAnnotationInfo info : this.warningInvalidParameterAnnotations.get(origin)) {
                    builder.append("\n  ").append(info.method).append(" expected count: ").append(info.expectedParameterCount).append(" actual count: ").append(info.actualParameterCount);
                }
                this.reporter.info(new StringDiagnostic(builder.toString(), origin));
            }
            printed = true;
        }
        if (this.warningInvalidDebugInfo.size() > 0) {
            int count = 0;
            for (List<Pair<ProgramMethod, String>> methods : this.warningInvalidDebugInfo.values()) {
                count += methods.size();
            }
            this.reporter.info(new StringDiagnostic("Stripped invalid locals information from " + count + (count == 1 ? " method." : " methods.")));
            for (Origin origin : new TreeSet<Origin>(this.warningInvalidDebugInfo.keySet())) {
                StringBuilder builder2 = new StringBuilder("Methods with invalid locals information:");
                for (Pair pair : this.warningInvalidDebugInfo.get(origin)) {
                    builder2.append("\n  ").append(((ProgramMethod)pair.getFirst()).toSourceString());
                    builder2.append("\n  ").append((String)pair.getSecond());
                }
                this.reporter.info(new StringDiagnostic(builder2.toString(), origin));
            }
            printed = true;
            printOutdatedToolchain = true;
        }
        if (this.missingEnclosingMembers.size() > 0) {
            this.reporter.info(new StringDiagnostic("InnerClasses attribute has entries missing a corresponding EnclosingMethod attribute. Such InnerClasses attribute entries are ignored."));
            for (Origin origin : new TreeSet<Origin>(this.missingEnclosingMembers.keySet())) {
                builder = new StringBuilder("Classes with missing EnclosingMethod: ");
                boolean first = true;
                for (TypeVersionPair typeVersionPair : this.missingEnclosingMembers.get(origin)) {
                    if (first) {
                        first = false;
                    } else {
                        builder.append(", ");
                    }
                    builder.append(typeVersionPair.type);
                    printOutdatedToolchain |= typeVersionPair.version.isLessThan(CfVersion.V1_5);
                }
                this.reporter.info(new StringDiagnostic(builder.toString(), origin));
            }
            printed = true;
        }
        if (printOutdatedToolchain) {
            this.reporter.info(new StringDiagnostic("Some warnings are typically a sign of using an outdated Java toolchain. To fix, recompile the source with an updated toolchain."));
        }
        return printed;
    }

    public boolean hasMethodsFilter() {
        return this.methodsFilter.size() > 0;
    }

    public boolean methodMatchesFilter(DexEncodedMethod method) {
        if (!this.hasMethodsFilter()) {
            return true;
        }
        String qualifiedName = method.qualifiedName();
        return this.methodsFilter.contains(qualifiedName);
    }

    public boolean methodMatchesLogArgumentsFilter(DexEncodedMethod method) {
        if (this.logArgumentsFilter.size() == 0) {
            return false;
        }
        String qualifiedName = method.qualifiedName();
        return this.logArgumentsFilter.contains(qualifiedName);
    }

    public MapVersion getMapFileVersion() {
        return this.testing.enableExperimentalMapFileVersion ? MapVersion.MAP_VERSION_EXPERIMENTAL : MapVersion.STABLE;
    }

    @VisibleForTesting
    public void disableNameReflectionOptimization() {
        this.enableNameReflectionOptimization = false;
    }

    public boolean canAccessModifyLambdaImplementationMethods(AppView<?> appView) {
        return !appView.enableWholeProgramOptimizations();
    }

    public boolean canUseAbstractMethodOnNonAbstractClass() {
        boolean result = false;
        assert (!result || !this.canHaveDalvikAbstractMethodOnNonAbstractClassVerificationBug());
        return result;
    }

    public boolean canUseConstClassInstructions(CfVersion cfVersion) {
        assert (this.isGeneratingClassFiles());
        return cfVersion.isGreaterThanOrEqualTo(this.requiredCfVersionForConstClassInstructions());
    }

    public CfVersion requiredCfVersionForConstClassInstructions() {
        assert (this.isGeneratingClassFiles());
        return CfVersion.V1_5;
    }

    public boolean canUseInvokePolymorphicOnVarHandle() {
        return this.isGeneratingClassFiles() || this.hasMinApi(AndroidApiLevel.P);
    }

    public boolean canUseInvokePolymorphic() {
        return this.isGeneratingClassFiles() || this.hasMinApi(AndroidApiLevel.O);
    }

    public boolean canUseConstantMethodHandle() {
        return this.isGeneratingClassFiles() || this.hasMinApi(AndroidApiLevel.P);
    }

    public boolean canUseConstantMethodType() {
        return this.isGeneratingClassFiles() || this.hasMinApi(AndroidApiLevel.P);
    }

    public boolean canUseInvokeCustom() {
        return this.isGeneratingClassFiles() || this.hasMinApi(AndroidApiLevel.O);
    }

    public boolean canUseDefaultAndStaticInterfaceMethods() {
        return !this.isDesugaring() || this.hasMinApi(AndroidApiLevel.N);
    }

    public boolean canUseNestBasedAccess() {
        return !this.isDesugaring();
    }

    public boolean canUseRecords() {
        return !this.isDesugaring();
    }

    public boolean canLeaveStaticInterfaceMethodInvokes() {
        return !this.isDesugaring() || this.hasMinApi(AndroidApiLevel.L);
    }

    public boolean canUseTwrCloseResourceMethod() {
        return !this.isDesugaring() || this.hasMinApi(AndroidApiLevel.K);
    }

    public boolean enableBackportedMethodRewriting() {
        return this.desugarState.isOn() && this.getMinApiLevel().isLessThanOrEqualTo(AndroidApiLevel.LATEST);
    }

    public boolean enableTryWithResourcesDesugaring() {
        switch (this.tryWithResourcesDesugaring) {
            case Off: {
                return false;
            }
            case Auto: {
                return this.desugarState.isOn() && !this.canUseTwrCloseResourceMethod();
            }
        }
        throw new Unreachable();
    }

    public boolean canUsePrivateInterfaceMethods() {
        return !this.isDesugaring() || this.hasMinApi(AndroidApiLevel.N);
    }

    public boolean allowDiscardingResidualDebugInfo() {
        return this.sourceFileProvider != null && this.sourceFileProvider.allowDiscardingSourceFile();
    }

    public boolean canUseDexPc2PcAsDebugInformation() {
        return this.isGeneratingDex() && this.lineNumberOptimization == LineNumberOptimization.ON;
    }

    public boolean canUseNativeDexPcInsteadOfDebugInfo() {
        return this.canUseDexPc2PcAsDebugInformation() && this.hasMinApi(AndroidApiLevel.O) && this.allowDiscardingResidualDebugInfo();
    }

    public boolean isInterfaceMethodDesugaringEnabled() {
        if (!this.hasConsumer()) {
            return false;
        }
        return this.desugarState == DesugarState.ON && this.interfaceMethodDesugaring == OffOrAuto.Auto && !this.canUseDefaultAndStaticInterfaceMethods();
    }

    public boolean isSwitchRewritingEnabled() {
        return this.enableSwitchRewriting && !this.debug;
    }

    public boolean isStringSwitchConversionEnabled() {
        return this.enableStringSwitchConversion && !this.debug;
    }

    public boolean canUseMultidex() {
        assert (this.isGeneratingDex());
        return this.intermediate || this.hasMinApi(AndroidApiLevel.L);
    }

    public boolean canUseJavaUtilObjects() {
        return !this.isDesugaring() || this.hasMinApi(AndroidApiLevel.K);
    }

    public boolean canUseJavaUtilObjectsIsNull() {
        return this.isGeneratingDex() && this.hasMinApi(AndroidApiLevel.N);
    }

    public boolean canUseSuppressedExceptions() {
        return !this.isDesugaring() || this.hasMinApi(AndroidApiLevel.K);
    }

    public boolean canUseAssertionErrorTwoArgumentConstructor() {
        return !this.isDesugaring() || this.hasMinApi(AndroidApiLevel.K);
    }

    public CfVersion classFileVersionAfterDesugaring(CfVersion version) {
        if (!this.isDesugaring()) {
            return version;
        }
        CfVersion maxVersionAfterDesugar = this.canUseDefaultAndStaticInterfaceMethods() ? CfVersion.V1_8 : CfVersion.V1_7;
        return Ordered.min(maxVersionAfterDesugar, version);
    }

    public boolean canInitCauseAfterAssertionErrorObjectConstructor() {
        return !this.isDesugaring() || this.hasMinApi(AndroidApiLevel.J);
    }

    public boolean canUseFilledNewArrayOfObjects() {
        assert (this.isGeneratingDex());
        return this.hasMinApi(AndroidApiLevel.K);
    }

    public boolean canUseSameArrayAndResultRegisterInArrayGetWide() {
        return this.isGeneratingClassFiles() || this.getMinApiLevel().isGreaterThan(AndroidApiLevel.O_MR1);
    }

    public boolean canHaveBoundsCheckEliminationBug() {
        return this.isGeneratingDex() && this.getMinApiLevel().isLessThan(AndroidApiLevel.M);
    }

    public boolean canUseNotInstruction() {
        return this.isGeneratingClassFiles() || this.hasMinApi(AndroidApiLevel.L);
    }

    public boolean canHaveThisTypeVerifierBug() {
        return this.isGeneratingDex() && this.getMinApiLevel().isLessThan(AndroidApiLevel.M);
    }

    public boolean canHaveThisJitCodeDebuggingBug() {
        return this.getMinApiLevel().isLessThan(AndroidApiLevel.Q);
    }

    public boolean canHaveOverlappingLongRegisterBug() {
        return this.isGeneratingDex() && this.getMinApiLevel().isLessThan(AndroidApiLevel.L);
    }

    public boolean canHaveCmpLongBug() {
        return this.isGeneratingDex() && this.getMinApiLevel().isLessThan(AndroidApiLevel.L);
    }

    public boolean canHaveCmpIfFloatBug() {
        return this.getMinApiLevel().isLessThan(AndroidApiLevel.M);
    }

    public boolean canHaveMul2AddrBug() {
        return this.isGeneratingDex() && this.getMinApiLevel().isLessThan(AndroidApiLevel.M);
    }

    public boolean canHaveDex2OatLinkedListBug() {
        return this.isGeneratingDex() && this.getMinApiLevel().isLessThan(AndroidApiLevel.N);
    }

    public boolean canHaveDex2OatInliningIssue() {
        return this.isGeneratingDex() && this.getMinApiLevel().isLessThan(AndroidApiLevel.N);
    }

    public boolean canHaveArtStringNewInitBug() {
        return this.isGeneratingDex() && this.getMinApiLevel().isLessThan(AndroidApiLevel.Q);
    }

    public boolean canHaveNumberConversionRegisterAllocationBug() {
        return this.isGeneratingDex() && this.getMinApiLevel().isLessThan(AndroidApiLevel.L);
    }

    public boolean canHaveForwardingInitInliningBug() {
        return this.isGeneratingDex() && this.getMinApiLevel().isLessThan(AndroidApiLevel.M);
    }

    public boolean canHaveExceptionTargetingLoopHeaderBug() {
        return this.isGeneratingDex() && !this.debug && this.getMinApiLevel().isLessThan(AndroidApiLevel.M);
    }

    public boolean canHaveTracingPastInstructionsStreamBug() {
        return this.getMinApiLevel().isLessThan(AndroidApiLevel.L);
    }

    public boolean canHaveArtInstanceOfVerifierBug() {
        return this.isGeneratingDex() && this.getMinApiLevel().isLessThan(AndroidApiLevel.Q);
    }

    public boolean canHaveLongToIntBug() {
        return this.getMinApiLevel().isLessThan(AndroidApiLevel.M);
    }

    public boolean canHaveExceptionTypeBug() {
        return this.getMinApiLevel().isLessThan(AndroidApiLevel.Q);
    }

    public boolean canHaveArtCheckCastVerifierBug() {
        return this.getMinApiLevel().isLessThan(AndroidApiLevel.J);
    }

    public boolean canHaveIncorrectJoinForArrayOfInterfacesBug() {
        return true;
    }

    public boolean canHaveDalvikCatchHandlerVerificationBug() {
        return this.isGeneratingClassFiles() || this.getMinApiLevel().isLessThan(AndroidApiLevel.L);
    }

    public boolean canHaveDalvikAbstractMethodOnNonAbstractClassVerificationBug() {
        return this.isGeneratingDex() && this.getMinApiLevel().isLessThan(AndroidApiLevel.L);
    }

    public boolean canHaveDalvikIntUsedAsNonIntPrimitiveTypeBug() {
        return this.isGeneratingClassFiles() || this.getMinApiLevel().isLessThan(AndroidApiLevel.L);
    }

    public boolean canHaveZipFileWithMissingCloseableBug() {
        return this.isGeneratingClassFiles() || this.getMinApiLevel().isLessThan(AndroidApiLevel.K);
    }

    public boolean canHaveSwitchMaxIntBug() {
        return this.isGeneratingDex() && this.getMinApiLevel().isLessThan(AndroidApiLevel.K);
    }

    public boolean canParseNumbersWithPlusPrefix() {
        return this.getMinApiLevel().isGreaterThan(AndroidApiLevel.K);
    }

    public boolean canHaveSuperInvokeBug() {
        return this.getMinApiLevel().isLessThan(AndroidApiLevel.N);
    }

    public boolean canHaveInvokeInterfaceToObjectMethodBug() {
        return this.isGeneratingDex() && this.getMinApiLevel().isLessThan(AndroidApiLevel.O);
    }

    public static class TestingOptions {
        public static int NO_LIMIT = -1;
        private boolean hasReadCheckDeterminism = false;
        private DeterminismChecker determinismChecker = null;
        public ArgumentPropagatorEventConsumer argumentPropagatorEventConsumer = ArgumentPropagatorEventConsumer.emptyConsumer();
        public byte[] forceDexVersionBytes = null;
        public IROrdering irOrdering = InternalOptions.assertionsEnabled() ? IROrdering.NondeterministicIROrdering.getInstance() : IROrdering.IdentityIROrdering.getInstance();
        public BiConsumer<AppInfoWithLiveness, Enqueuer.Mode> enqueuerInspector = null;
        public Consumer<String> processingContextsConsumer = null;
        public Function<AppView<AppInfoWithLiveness>, Repackaging.RepackagingConfiguration> repackagingConfigurationFactory = Repackaging.DefaultRepackagingConfiguration::new;
        public BiConsumer<DexItemFactory, HorizontallyMergedClasses> horizontallyMergedClassesConsumer = ConsumerUtils.emptyBiConsumer();
        public Function<List<Policy>, List<Policy>> horizontalClassMergingPolicyRewriter = Function.identity();
        public TriFunction<AppView<?>, Iterable<DexProgramClass>, DexProgramClass, DexProgramClass> horizontalClassMergingTarget = (appView, candidates, target) -> target;
        public BiConsumer<DexItemFactory, EnumDataMap> unboxedEnumsConsumer = ConsumerUtils.emptyBiConsumer();
        public BiConsumer<DexItemFactory, VerticallyMergedClasses> verticallyMergedClassesConsumer = ConsumerUtils.emptyBiConsumer();
        public Consumer<Deque<ProgramMethodSet>> waveModifier = waves -> {};
        public boolean addCallEdgesForLibraryInvokes = false;
        public boolean allowCheckDiscardedErrors = false;
        public boolean allowClassInliningOfSynthetics = true;
        public boolean allowInjectedAnnotationMethods = false;
        public boolean allowInliningOfSynthetics = true;
        public boolean allowTypeErrors = !Version.isDevelopmentVersion() || System.getProperty("com.android.tools.r8.allowTypeErrors") != null;
        public boolean allowInvokeErrors = false;
        public boolean allowUnnecessaryDontWarnWildcards = true;
        public boolean allowUnusedDontWarnRules = true;
        public boolean reportUnusedProguardConfigurationRules = false;
        public boolean alwaysUseExistingAccessInfoCollectionsInMemberRebinding = true;
        public boolean alwaysUsePessimisticRegisterAllocation = false;
        public boolean enableCheckCastAndInstanceOfRemoval = true;
        public boolean enableDeadSwitchCaseElimination = true;
        public boolean enableInvokeSuperToInvokeVirtualRewriting = true;
        public boolean enableMultiANewArrayDesugaringForClassFiles = false;
        public boolean enableSwitchToIfRewriting = true;
        public boolean enableEnumUnboxingDebugLogs = false;
        public boolean forceRedundantConstNumberRemoval = false;
        public boolean enableExperimentalDesugaredLibraryKeepRuleGenerator = false;
        public boolean enableExperimentalLoopUnrolling = false;
        public boolean invertConditionals = false;
        public boolean placeExceptionalBlocksLast = false;
        public boolean dontCreateMarkerInD8 = false;
        public boolean forceJumboStringProcessing = false;
        public boolean forcePcBasedEncoding = false;
        public Set<Inliner.Reason> validInliningReasons = null;
        public boolean noLocalsTableOnInput = false;
        public boolean forceNameReflectionOptimization = false;
        public boolean enableNarrowAndWideningingChecksInD8 = false;
        public BiConsumer<IRCode, AppView<?>> irModifier = null;
        public Consumer<IRCode> inlineeIrModifier = null;
        public int basicBlockMuncherIterationLimit = NO_LIMIT;
        public boolean dontReportFailingCheckDiscarded = false;
        public boolean disableRecordApplicationReaderMap = false;
        public PrintStream whyAreYouNotInliningConsumer = System.out;
        public boolean trackDesugaredAPIConversions = System.getProperty("com.android.tools.r8.trackDesugaredAPIConversions") != null;
        public boolean enumUnboxingRewriteJavaCGeneratedMethod = false;
        public boolean assertConsistentRenamingOfSignature = false;
        public boolean allowStaticInterfaceMethodsForPreNApiLevel = false;
        public int verificationSizeLimitInBytesOverride = -1;
        public boolean forceIRForCfToCfDesugar = System.getProperty("com.android.tools.r8.forceIRForCfToCfDesugar") != null;
        public boolean disableMappingToOriginalProgramVerification = false;
        public boolean allowInvalidCfAccessFlags = System.getProperty("com.android.tools.r8.allowInvalidCfAccessFlags") != null;
        public boolean verifyInputs = System.getProperty("com.android.tools.r8.verifyInputs") != null;
        public boolean checkForNotExpandingMainDexTracingResult = false;
        public Set<String> allowedUnusedDontWarnPatterns = new HashSet<String>();
        public boolean enableTestAssertions = System.getProperty("com.android.tools.r8.enableTestAssertions") != null;
        public boolean disableMarkingMethodsFinal = System.getProperty("com.android.tools.r8.disableMarkingMethodsFinal") != null;
        public boolean disableMarkingClassesFinal = System.getProperty("com.android.tools.r8.disableMarkingClassesFinal") != null;
        public boolean testEnableTestAssertions = false;
        public boolean keepMetadataInR8IfNotRewritten = true;
        public boolean enableRecordModeling = true;
        public boolean allowConflictingSyntheticTypes = false;
        public boolean enableD8ResourcesPassThrough = false;
        public boolean allowNonAbstractClassesWithAbstractMethods = true;
        public boolean verifyKeptGraphInfo = false;
        public boolean readInputStackMaps = true;
        public boolean disableStackMapVerification = false;
        public boolean dumpAll = false;
        public boolean allowOutlinerInterfaceArrayArguments = false;
        public int limitNumberOfClassesPerDex = -1;
        public MinifierTestingOptions minifier = new MinifierTestingOptions();
        public Runnable hookInIrConversion = null;
        public boolean measureProguardIfRuleEvaluations = false;
        public ProguardIfRuleEvaluationData proguardIfRuleEvaluationData = new ProguardIfRuleEvaluationData();
        public Consumer<ProgramMethod> callSiteOptimizationInfoInspector = ConsumerUtils.emptyConsumer();
        public Predicate<DexMethod> cfByteCodePassThrough = null;
        public boolean enableExperimentalMapFileVersion = false;

        public static void allowExperimentClassFileVersion(InternalOptions options) {
            options.reportedExperimentClassFileVersion.set(true);
        }

        public void setDeterminismChecker(DeterminismChecker checker) {
            this.determinismChecker = checker;
        }

        public void checkDeterminism(AppView<?> appView) {
            if (this.determinismChecker == null && !this.hasReadCheckDeterminism) {
                this.hasReadCheckDeterminism = true;
                String dir = System.getProperty("com.android.tools.r8.checkdeterminism");
                if (dir != null) {
                    this.determinismChecker = DeterminismChecker.createWithFileBacking(Paths.get(dir, new String[0]));
                }
            }
            if (this.determinismChecker != null) {
                this.determinismChecker.check(appView);
            }
        }

        public static class ProguardIfRuleEvaluationData {
            public int numberOfProguardIfRuleClassEvaluations = 0;
            public int numberOfProguardIfRuleMemberEvaluations = 0;
        }

        public static class MinifierTestingOptions {
            public Comparator<DexMethod> interfaceMethodOrdering = null;

            public Comparator<Equivalence.Wrapper<DexEncodedMethod>> getInterfaceMethodOrderingOrDefault(Comparator<Equivalence.Wrapper<DexEncodedMethod>> comparator) {
                if (this.interfaceMethodOrdering != null) {
                    return (a, b) -> this.interfaceMethodOrdering.compare((DexMethod)((DexEncodedMethod)a.get()).getReference(), (DexMethod)((DexEncodedMethod)b.get()).getReference());
                }
                return comparator;
            }
        }
    }

    public static class ProtoShrinkingOptions {
        public boolean enableGeneratedExtensionRegistryShrinking = false;
        public boolean enableGeneratedMessageLiteShrinking = false;
        public boolean enableGeneratedMessageLiteBuilderShrinking = false;
        public boolean traverseOneOfAndRepeatedProtoFields = false;
        public boolean enableEnumLiteProtoShrinking = false;
        public boolean enableProtoEnumSwitchMapShrinking = true;

        public void disable() {
            this.enableGeneratedExtensionRegistryShrinking = false;
            this.enableGeneratedMessageLiteShrinking = false;
            this.enableGeneratedMessageLiteBuilderShrinking = false;
            this.traverseOneOfAndRepeatedProtoFields = false;
            this.enableEnumLiteProtoShrinking = false;
        }

        public boolean enableRemoveProtoEnumSwitchMap() {
            return this.isProtoShrinkingEnabled() && this.enableProtoEnumSwitchMapShrinking;
        }

        public boolean isProtoShrinkingEnabled() {
            return this.enableGeneratedExtensionRegistryShrinking || this.enableGeneratedMessageLiteShrinking || this.enableGeneratedMessageLiteBuilderShrinking || this.enableEnumLiteProtoShrinking;
        }

        public boolean isEnumLiteProtoShrinkingEnabled() {
            return this.enableEnumLiteProtoShrinking;
        }
    }

    public static class ApiModelTestingOptions {
        public boolean enableApiCallerIdentification = System.getProperty("com.android.tools.r8.disableApiModeling") == null;
        public boolean checkAllApiReferencesAreSet = System.getProperty("com.android.tools.r8.disableApiModeling") == null;
        public boolean enableStubbingOfClasses = System.getProperty("com.android.tools.r8.disableApiModeling") == null;
        public boolean enableOutliningOfMethods = System.getProperty("com.android.tools.r8.disableApiModeling") == null;
        public Map<MethodReference, AndroidApiLevel> methodApiMapping = new HashMap<MethodReference, AndroidApiLevel>();
        public Map<FieldReference, AndroidApiLevel> fieldApiMapping = new HashMap<FieldReference, AndroidApiLevel>();
        public Map<ClassReference, AndroidApiLevel> classApiMapping = new HashMap<ClassReference, AndroidApiLevel>();
        public BiConsumer<MethodReference, ComputedApiLevel> tracedMethodApiLevelCallback = null;

        public void visitMockedApiLevelsForReferences(DexItemFactory factory, BiConsumer<DexReference, AndroidApiLevel> apiLevelConsumer) {
            if (this.methodApiMapping.isEmpty() && this.fieldApiMapping.isEmpty() && this.classApiMapping.isEmpty()) {
                return;
            }
            this.classApiMapping.forEach((classReference, apiLevel) -> apiLevelConsumer.accept(factory.createType(classReference.getDescriptor()), (AndroidApiLevel)apiLevel));
            this.fieldApiMapping.forEach((fieldReference, apiLevel) -> apiLevelConsumer.accept(factory.createField((FieldReference)fieldReference), (AndroidApiLevel)apiLevel));
            this.methodApiMapping.forEach((methodReference, apiLevel) -> apiLevelConsumer.accept(factory.createMethod((MethodReference)methodReference), (AndroidApiLevel)apiLevel));
        }

        public void disableApiCallerIdentification() {
            this.enableApiCallerIdentification = false;
        }
    }

    public static class OpenClosedInterfacesOptions {
        private boolean allowOpenInterfaces = true;
        private List<OpenInterfaceWitnessSuppression> suppressions = new ArrayList<OpenInterfaceWitnessSuppression>();

        public void disallowOpenInterfaces() {
            this.allowOpenInterfaces = false;
        }

        public void suppressAllOpenInterfaces() {
            assert (!this.allowOpenInterfaces);
            this.suppressions.add((appView, valueType, openInterface) -> true);
        }

        public void suppressAllOpenInterfacesDueToMissingClasses() {
            assert (!this.allowOpenInterfaces);
            this.suppressions.add((appView, valueType, openInterface) -> valueType.isBasedOnMissingClass(appView));
        }

        public void suppressArrayAssignmentsToJavaLangSerializable() {
            assert (!this.allowOpenInterfaces);
            this.suppressions.add((appView, valueType, openInterface) -> valueType.isArrayType() && openInterface.getTypeName().equals("java.io.Serializable"));
        }

        public void suppressZipFileAssignmentsToJavaLangAutoCloseable() {
            assert (!this.allowOpenInterfaces);
            this.suppressions.add((appView, valueType, openInterface) -> valueType.isClassType() && valueType.asClassType().getClassType().getTypeName().equals("java.util.zip.ZipFile") && openInterface.getTypeName().equals("java.lang.AutoCloseable"));
        }

        public boolean isOpenInterfacesAllowed() {
            return this.allowOpenInterfaces;
        }

        public boolean hasSuppressions() {
            return !this.suppressions.isEmpty();
        }

        public boolean isSuppressed(AppView<? extends AppInfoWithClassHierarchy> appView, TypeElement valueType, DexClass openInterface) {
            return this.allowOpenInterfaces || this.suppressions.stream().anyMatch(suppression -> suppression.isSuppressed(appView, valueType, openInterface));
        }

        public static interface OpenInterfaceWitnessSuppression {
            public boolean isSuppressed(AppView<? extends AppInfoWithClassHierarchy> var1, TypeElement var2, DexClass var3);
        }
    }

    public class HorizontalClassMergerOptions {
        private boolean enable = !Version.isDevelopmentVersion() || System.getProperty("com.android.tools.r8.disableHorizontalClassMerging") == null;
        private boolean enableClassInitializerDeadlockDetection = true;
        private boolean enableInterfaceMerging = System.getProperty("com.android.tools.r8.enableHorizontalInterfaceMerging") != null;
        private boolean enableInterfaceMergingInInitial = false;
        private boolean enableSyntheticMerging = true;
        private boolean ignoreRuntimeTypeChecksForTesting = false;
        private boolean restrictToSynthetics = false;

        public void disable() {
            this.enable = false;
        }

        public void disableSyntheticMerging() {
            this.enableSyntheticMerging = false;
        }

        public void enable() {
            this.enable = true;
        }

        public void enableIf(boolean enable) {
            this.enable = enable;
        }

        public int getMaxClassGroupSizeInR8() {
            return 30;
        }

        public int getMaxClassGroupSizeInD8() {
            return 100;
        }

        public int getMaxInterfaceGroupSize() {
            return 100;
        }

        public boolean isConstructorMergingEnabled() {
            return true;
        }

        public boolean isClassInitializerDeadlockDetectionEnabled() {
            return this.enableClassInitializerDeadlockDetection;
        }

        public boolean isEnabled(HorizontalClassMerger.Mode mode) {
            if (!this.enable || InternalOptions.this.debug || InternalOptions.this.intermediate) {
                return false;
            }
            if (mode.isInitial()) {
                return ((InternalOptions)InternalOptions.this).inlinerOptions.enableInlining && InternalOptions.this.isShrinking();
            }
            assert (mode.isFinal());
            return true;
        }

        public boolean isIgnoreRuntimeTypeChecksForTestingEnabled() {
            return this.ignoreRuntimeTypeChecksForTesting;
        }

        public boolean isSyntheticMergingEnabled() {
            return this.enableSyntheticMerging;
        }

        public boolean isInterfaceMergingEnabled(HorizontalClassMerger.Mode mode) {
            if (!this.enableInterfaceMerging) {
                return false;
            }
            if (mode.isInitial()) {
                return this.enableInterfaceMergingInInitial;
            }
            assert (mode.isFinal());
            return true;
        }

        public boolean isRestrictedToSynthetics() {
            return this.restrictToSynthetics || !InternalOptions.this.isOptimizing() || !InternalOptions.this.isShrinking();
        }

        public void setEnableClassInitializerDeadlockDetection() {
            this.enableClassInitializerDeadlockDetection = true;
        }

        public void setEnableInterfaceMerging() {
            this.enableInterfaceMerging = true;
        }

        public void setEnableInterfaceMergingInInitial() {
            this.enableInterfaceMergingInInitial = true;
        }

        public void setIgnoreRuntimeTypeChecksForTesting() {
            this.ignoreRuntimeTypeChecksForTesting = true;
        }

        public void setRestrictToSynthetics() {
            this.restrictToSynthetics = true;
        }
    }

    public class InlinerOptions {
        public boolean enableInlining = !InternalOptions.access$000("com.android.tools.r8.disableinlining");
        public int simpleInliningInstructionLimit = InternalOptions.access$100("com.android.tools.r8.inliningInstructionLimit", -1);
        public int[] multiCallerInliningInstructionLimits = new int[]{Integer.MAX_VALUE, 28, 16, 12, 10};
        public int inliningInstructionAllowance = 1500;
        public int inliningMonitorEnterValuesAllowance = 4;
        public int inliningControlFlowResolutionBlocksThreshold = 15;
        public boolean applyInliningToInlinee = System.getProperty("com.android.tools.r8.applyInliningToInlinee") != null;
        public int applyInliningToInlineeMaxDepth = 0;
        public boolean enableInliningOfInvokesWithClassInitializationSideEffects = true;
        public boolean enableInliningOfInvokesWithNullableReceivers = true;
        public boolean disableInliningOfLibraryMethodOverrides = true;

        public int getSimpleInliningInstructionLimit() {
            if (this.simpleInliningInstructionLimit >= 0) {
                return this.simpleInliningInstructionLimit;
            }
            if (InternalOptions.this.isGeneratingClassFiles()) {
                return 3;
            }
            assert (InternalOptions.this.isGeneratingDex());
            return 5;
        }
    }

    public class ClassInlinerOptions {
        public int classInliningInstructionAllowance = -1;

        public int getClassInliningInstructionAllowance() {
            if (this.classInliningInstructionAllowance >= 0) {
                return this.classInliningInstructionAllowance;
            }
            if (InternalOptions.this.isGeneratingClassFiles()) {
                return 50;
            }
            assert (InternalOptions.this.isGeneratingDex());
            return 65;
        }
    }

    public class CallSiteOptimizationOptions {
        private boolean enabled = true;
        private boolean enableMethodStaticizing = true;
        private boolean forceSyntheticsForInstanceInitializers = false;

        public void disableOptimization() {
            this.enabled = false;
        }

        public int getMaxNumberOfInParameters() {
            return 10;
        }

        public boolean isEnabled() {
            if (!InternalOptions.this.isOptimizing() || !InternalOptions.this.isShrinking()) {
                return false;
            }
            return this.enabled;
        }

        public boolean isForceSyntheticsForInstanceInitializersEnabled() {
            return this.forceSyntheticsForInstanceInitializers;
        }

        public boolean isMethodStaticizingEnabled() {
            return this.enableMethodStaticizing;
        }

        public CallSiteOptimizationOptions setEnabled(boolean enabled) {
            if (enabled) {
                assert (this.isEnabled());
            } else {
                this.disableOptimization();
            }
            return this;
        }

        public CallSiteOptimizationOptions setForceSyntheticsForInstanceInitializers(boolean forceSyntheticsForInstanceInitializers) {
            this.forceSyntheticsForInstanceInitializers = forceSyntheticsForInstanceInitializers;
            return this;
        }

        public CallSiteOptimizationOptions setEnableMethodStaticizing(boolean enableMethodStaticizing) {
            this.enableMethodStaticizing = enableMethodStaticizing;
            return this;
        }
    }

    public static class DesugarSpecificOptions {
        public boolean sortMethodsOnCfOutput = System.getProperty("com.android.tools.r8.sortMethodsOnCfWriting") != null;
        public boolean allowAllDesugaredInput = System.getProperty("com.android.tools.r8.allowAllDesugaredInput") != null;
        public boolean noCfMarkerForDesugaredCode = System.getProperty("com.android.tools.r8.noCfMarkerForDesugaredCode") != null;
        public boolean lambdaClassFieldsFinal = System.getProperty("com.android.tools.r8.lambdaClassFieldsNotFinal") == null;
    }

    public static class KotlinOptimizationOptions {
        public boolean disableKotlinSpecificOptimizations = System.getProperty("com.android.tools.r8.disableKotlinSpecificOptimizations") != null;
    }

    public static class OutlineOptions {
        public boolean enabled = true;
        public int minSize = 3;
        public int maxSize = 99;
        public int threshold = 20;
        public int maxNumberOfInstructionsToBeConsidered = 100;
    }

    public static enum PackageObfuscationMode {
        NONE,
        MINIFICATION,
        REPACKAGE,
        FLATTEN;


        public boolean isNone() {
            return this == NONE;
        }

        public boolean isFlattenPackageHierarchy() {
            return this == FLATTEN;
        }

        public boolean isRepackageClasses() {
            return this == REPACKAGE;
        }

        public boolean isMinification() {
            return this == MINIFICATION;
        }

        public boolean isSome() {
            return !this.isNone();
        }
    }

    private static class TypeVersionPair {
        final CfVersion version;
        final DexType type;

        public TypeVersionPair(CfVersion version, DexType type) {
            this.version = version;
            this.type = type;
        }
    }

    public static class InvalidParameterAnnotationInfo {
        final DexMethod method;
        final int expectedParameterCount;
        final int actualParameterCount;

        public InvalidParameterAnnotationInfo(DexMethod method, int expectedParameterCount, int actualParameterCount) {
            this.method = method;
            this.expectedParameterCount = expectedParameterCount;
            this.actualParameterCount = actualParameterCount;
        }
    }

    public static enum DesugarState {
        OFF,
        ON;


        public boolean isOff() {
            return this == OFF;
        }

        public boolean isOn() {
            return this == ON;
        }
    }

    public static enum LineNumberOptimization {
        OFF,
        ON;

    }
}

