/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.GraphLens;
import java.util.Set;
import java.util.function.Consumer;

public class LensUtils {
    public static Set<DexEncodedMethod> rewrittenWithRenamedSignature(Set<DexEncodedMethod> methods, DexDefinitionSupplier definitions, GraphLens lens) {
        Set<DexEncodedMethod> result = Sets.newIdentityHashSet();
        for (DexEncodedMethod method : methods) {
            result.add(lens.mapDexEncodedMethod(method, definitions));
        }
        return result;
    }

    public static <T extends DexReference> void rewriteAndApplyIfNotPrimitiveType(GraphLens graphLens, T reference, Consumer<T> rewrittenConsumer) {
        T rewrittenReference = graphLens.rewriteReference(reference);
        if (rewrittenReference.isDexType() && rewrittenReference.asDexType().isPrimitiveType()) {
            return;
        }
        rewrittenConsumer.accept(rewrittenReference);
    }
}

