/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.utils.ForEachable;
import com.android.tools.r8.utils.IntObjToObjFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public class ListUtils {
    public static <T> List<T> flatMapSameType(List<T> list, Function<T, Collection<T>> fn, List<T> defaultValue) {
        List<T> result = null;
        for (int i = 0; i < list.size(); ++i) {
            T element = list.get(i);
            Collection<T> replacement = fn.apply(element);
            if (replacement == null) {
                if (result == null) continue;
                result.add(element);
                continue;
            }
            if (result == null) {
                result = new ArrayList<T>(list.size() + replacement.size() - 1);
                for (int j = 0; j < i; ++j) {
                    result.add(list.get(j));
                }
            }
            result.addAll(replacement);
        }
        return result != null ? result : defaultValue;
    }

    public static <S, T> List<T> flatMap(List<S> list, Function<S, Collection<T>> fn) {
        ArrayList result = new ArrayList();
        list.forEach(element -> result.addAll((Collection)fn.apply(element)));
        return result;
    }

    public static <T> List<T> filter(Collection<T> list, Predicate<? super T> predicate) {
        ArrayList filtered = new ArrayList(list.size());
        list.forEach(t -> {
            if (predicate.test(t)) {
                filtered.add(t);
            }
        });
        return filtered;
    }

    public static <T> T first(List<T> list) {
        return list.get(0);
    }

    public static <T> T firstMatching(List<T> list, Predicate<T> tester) {
        int i = ListUtils.firstIndexMatching(list, tester);
        return i >= 0 ? (T)list.get(i) : null;
    }

    public static <T> int firstIndexMatching(List<T> list, Predicate<T> tester) {
        for (int i = 0; i < list.size(); ++i) {
            if (!tester.test(list.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static <T> T last(List<T> list) {
        return list.get(list.size() - 1);
    }

    public static <T> int lastIndexMatching(List<T> list, Predicate<T> tester) {
        for (int i = list.size() - 1; i >= 0; --i) {
            if (!tester.test(list.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static <S, T> List<T> map(S[] list, Function<S, T> fn) {
        ArrayList<T> result = new ArrayList<T>();
        for (S element : list) {
            result.add(fn.apply(element));
        }
        return result;
    }

    public static <S, T> List<T> map(Iterable<S> list, Function<S, T> fn) {
        ArrayList<T> result = new ArrayList<T>();
        for (S element : list) {
            result.add(fn.apply(element));
        }
        return result;
    }

    public static <S, T> List<T> map(Collection<S> list, Function<S, T> fn) {
        ArrayList<T> result = new ArrayList<T>(list.size());
        for (S element : list) {
            result.add(fn.apply(element));
        }
        return result;
    }

    public static <S, T> List<T> mapNotNull(Collection<S> list, Function<S, T> fn) {
        ArrayList<T> result = new ArrayList<T>(list.size());
        for (S element : list) {
            T mapped = fn.apply(element);
            if (mapped == null) continue;
            result.add(mapped);
        }
        return result;
    }

    public static <T> List<T> mapOrElse(List<T> list, Function<T, T> fn, List<T> defaultValue) {
        return ListUtils.mapOrElse(list, (int index, T element) -> fn.apply(element), defaultValue);
    }

    public static <T> List<T> mapOrElse(List<T> list, IntObjToObjFunction<T, T> fn, List<T> defaultValue) {
        List<T> result = null;
        for (int i = 0; i < list.size(); ++i) {
            T oldElement = list.get(i);
            T newElement = fn.apply(i, oldElement);
            if (newElement == oldElement) {
                if (result == null) continue;
                ((ArrayList)result).add(oldElement);
                continue;
            }
            if (result == null) {
                result = new ArrayList<T>(list.size());
                for (int j = 0; j < i; ++j) {
                    ((ArrayList)result).add(list.get(j));
                }
            }
            if (newElement == null) continue;
            ((ArrayList)result).add(newElement);
        }
        return result != null ? result : defaultValue;
    }

    public static <T> List<T> mapOrElse(List<T> list, Function<T, T> fn) {
        return ListUtils.mapOrElse(list, fn, list);
    }

    public static <T> List<T> filterOrElse(List<T> list, Predicate<T> predicate) {
        return ListUtils.mapOrElse(list, (T element) -> predicate.test(element) ? element : null, list);
    }

    public static <T> ArrayList<T> newArrayList(T element) {
        ArrayList<T> list = new ArrayList<T>(1);
        list.add(element);
        return list;
    }

    public static <T> ArrayList<T> newArrayList(T element, T other) {
        ArrayList<T> list = new ArrayList<T>(2);
        list.add(element);
        list.add(other);
        return list;
    }

    public static <T> ArrayList<T> newArrayList(ForEachable<T> forEachable) {
        ArrayList list = new ArrayList();
        forEachable.forEach(list::add);
        return list;
    }

    public static <T> ArrayList<T> newInitializedArrayList(int size, T element) {
        ArrayList<T> list = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            list.add(element);
        }
        return list;
    }

    public static <T> ImmutableList<T> newImmutableList(ForEachable<T> forEachable) {
        ImmutableList.Builder builder = ImmutableList.builder();
        forEachable.forEach(builder::add);
        return builder.build();
    }

    public static <T> LinkedList<T> newLinkedList(T element) {
        LinkedList<T> list = new LinkedList<T>();
        list.add(element);
        return list;
    }

    public static <T> LinkedList<T> newLinkedList(ForEachable<T> forEachable) {
        LinkedList list = new LinkedList();
        forEachable.forEach(list::add);
        return list;
    }

    public static <T> Optional<T> removeFirstMatch(List<T> list, Predicate<T> element) {
        int index = ListUtils.firstIndexMatching(list, element);
        if (index >= 0) {
            return Optional.of(list.remove(index));
        }
        return Optional.empty();
    }

    public static <T> T removeLast(List<T> list) {
        return list.remove(list.size() - 1);
    }

    public static <T extends Comparable<T>> boolean verifyListIsOrdered(List<T> list) {
        for (int i = list.size() - 1; i > 0; --i) {
            if (((Comparable)list.get(i)).compareTo((Comparable)list.get(i - 1)) >= 0) continue;
            return false;
        }
        return true;
    }

    public static <T, R> R fold(Collection<T> items, R identity, BiFunction<R, T, R> acc) {
        R result = identity;
        for (T item : items) {
            result = acc.apply(result, item);
        }
        return result;
    }

    public static <T> void forEachWithIndex(List<T> items, ReferenceAndIntConsumer<T> consumer) {
        for (int i = 0; i < items.size(); ++i) {
            consumer.accept(items.get(i), i);
        }
    }

    public static <T> void destructiveSort(List<T> items, Comparator<T> comparator) {
        items.sort(comparator);
    }

    public static <T> void destructiveSortAndVerify(List<T> items, Comparator<T> comparator) {
        ListUtils.destructiveSort(items, comparator);
        assert (ListUtils.verifyComparatorOnSortedList(items, comparator));
    }

    public static <T> int uniqueIndexMatching(List<T> list, Predicate<T> predicate) {
        int result = -1;
        for (int i = 0; i < list.size(); ++i) {
            T element = list.get(i);
            if (!predicate.test(element)) continue;
            if (result == -1) {
                result = i;
                continue;
            }
            return -1;
        }
        return result;
    }

    private static <T> boolean verifyComparatorOnSortedList(List<T> items, Comparator<T> comparator) {
        for (int i = 0; i < items.size(); ++i) {
            boolean allowEqual = true;
            for (int j = i; j < items.size(); ++j) {
                boolean isEqual;
                T a = items.get(i);
                T b = items.get(j);
                int result1 = comparator.compare(a, b);
                int result2 = comparator.compare(b, a);
                boolean bl = isEqual = result1 == 0 && result2 == 0;
                if (i == j) {
                    assert (isEqual);
                    continue;
                }
                if (allowEqual && isEqual) continue;
                allowEqual = false;
                assert (result1 < 0);
                assert (result2 > 0);
            }
        }
        return true;
    }

    public static interface ReferenceAndIntConsumer<T> {
        public void accept(T var1, int var2);
    }
}

