/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public class PredicateSet<T> {
    private final Set<T> elements = Sets.newIdentityHashSet();
    private final List<Predicate<T>> predicates = new ArrayList<Predicate<T>>();

    public static <T> PredicateSet<T> empty() {
        return new PredicateSet<T>();
    }

    public boolean addElement(T element) {
        return this.elements.add(element);
    }

    public void addPredicate(Predicate<T> predicate) {
        this.predicates.add(predicate);
    }

    public PredicateSet<T> rewriteItems(Function<T, T> mapping) {
        PredicateSet<T> set = new PredicateSet<T>();
        for (T item : this.elements) {
            set.elements.add(mapping.apply(item));
        }
        set.predicates.addAll(this.predicates);
        return set;
    }

    public boolean contains(T element) {
        if (this.elements.contains(element)) {
            return true;
        }
        for (Predicate<T> predicate : this.predicates) {
            if (!predicate.test(element)) continue;
            return true;
        }
        return false;
    }
}

