/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.errors.DuplicateTypesDiagnostic;
import com.android.tools.r8.graph.ClassKind;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.references.Reference;
import com.android.tools.r8.utils.ClassMap;
import com.android.tools.r8.utils.Reporter;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class ProgramClassCollection
extends ClassMap<DexProgramClass> {
    private final ApplicationReader.ProgramClassConflictResolver conflictResolver;

    public static ProgramClassCollection create(List<DexProgramClass> classes, ApplicationReader.ProgramClassConflictResolver conflictResolver) {
        ConcurrentHashMap<DexType, Supplier<DexProgramClass>> map = new ConcurrentHashMap<DexType, Supplier<DexProgramClass>>();
        for (DexProgramClass clazz : classes) {
            map.merge(clazz.type, clazz, (a, b) -> conflictResolver.resolveClassConflict((DexProgramClass)a.get(), (DexProgramClass)b.get()));
        }
        return new ProgramClassCollection(map, conflictResolver);
    }

    private ProgramClassCollection(ConcurrentHashMap<DexType, Supplier<DexProgramClass>> classes, ApplicationReader.ProgramClassConflictResolver conflictResolver) {
        super(classes, null);
        this.conflictResolver = conflictResolver;
    }

    public static ApplicationReader.ProgramClassConflictResolver defaultConflictResolver(Reporter reporter) {
        return (a, b) -> {
            assert (a.type == b.type);
            if (a.accessFlags.isSynthetic() && b.accessFlags.isSynthetic()) {
                return ProgramClassCollection.mergeClasses(reporter, a, b);
            }
            throw ProgramClassCollection.reportDuplicateTypes(reporter, a, b);
        };
    }

    private static RuntimeException reportDuplicateTypes(Reporter reporter, DexProgramClass a, DexProgramClass b) {
        throw reporter.fatalError(new DuplicateTypesDiagnostic(Reference.classFromDescriptor(a.type.toDescriptorString()), ImmutableList.of(a.getOrigin(), b.getOrigin())));
    }

    private static DexProgramClass mergeClasses(Reporter reporter, DexProgramClass a, DexProgramClass b) {
        if (a.type.isLegacySynthesizedTypeAllowedDuplication() || a.type.isSynthesizedTypeAllowedDuplication()) {
            assert (ProgramClassCollection.assertEqualClasses(a, b));
            return a;
        }
        throw ProgramClassCollection.reportDuplicateTypes(reporter, a, b);
    }

    private static boolean assertEqualClasses(DexProgramClass a, DexProgramClass b) {
        assert (a.getMethodCollection().numberOfDirectMethods() == b.getMethodCollection().numberOfDirectMethods());
        assert (a.getMethodCollection().size() == b.getMethodCollection().size());
        return true;
    }

    @Override
    public String toString() {
        return "program classes: " + super.toString();
    }

    @Override
    DexProgramClass resolveClassConflict(DexProgramClass a, DexProgramClass b) {
        return this.conflictResolver.resolveClassConflict(a, b);
    }

    @Override
    Supplier<DexProgramClass> getTransparentSupplier(DexProgramClass clazz) {
        return clazz;
    }

    @Override
    ClassKind<DexProgramClass> getClassKind() {
        return ClassKind.PROGRAM;
    }
}

