/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class ReflectionHelper {
    public static <T> T performReflection(Object object, ReflectiveOperation<?> operation) throws Exception {
        return (T)operation.compute(object);
    }

    public static ReflectiveOperationSequenceBuilder builder() {
        return new ReflectiveOperationSequenceBuilder();
    }

    public static class ReflectiveOperationBuilder {
        private final String declaredMember;
        private final DeclaredType declaredType;
        private boolean setAccessible = false;
        private final ReflectiveOperationSequenceBuilder sequenceBuilder;

        private ReflectiveOperationBuilder(String declaredMember, DeclaredType declaredType, ReflectiveOperationSequenceBuilder sequenceBuilder) {
            this.declaredMember = declaredMember;
            this.declaredType = declaredType;
            this.sequenceBuilder = sequenceBuilder;
        }

        private ReflectiveOperation<?> build(ReflectiveOperation<?> nextOperation) {
            if (this.declaredType == DeclaredType.FIELD) {
                return new ReflectiveFieldOperation(null, this.declaredMember, nextOperation, field -> {
                    if (this.setAccessible) {
                        field.setAccessible(true);
                    }
                });
            }
            assert (this.declaredType == DeclaredType.METHOD);
            return new ReflectiveMethodOperation(null, this.declaredMember, nextOperation, method -> {
                if (this.setAccessible) {
                    method.setAccessible(true);
                }
            });
        }

        public ReflectiveOperationBuilder setSetAccessible(boolean setAccessible) {
            this.setAccessible = setAccessible;
            return this;
        }

        public ReflectiveOperationSequenceBuilder done() {
            return this.sequenceBuilder;
        }
    }

    public static class ReflectiveOperationSequenceBuilder {
        List<ReflectiveOperationBuilder> reflectiveOperationBuilderList = new ArrayList<ReflectiveOperationBuilder>();

        private ReflectiveOperationBuilder add(String declaredMember, DeclaredType declaredType) {
            ReflectiveOperationBuilder reflectiveOperationBuilder = new ReflectiveOperationBuilder(declaredMember, declaredType, this);
            this.reflectiveOperationBuilderList.add(reflectiveOperationBuilder);
            return reflectiveOperationBuilder;
        }

        public ReflectiveOperationBuilder readMethod(String declaredMember) {
            return this.add(declaredMember, DeclaredType.METHOD);
        }

        public ReflectiveOperationBuilder readField(String declaredMember) {
            return this.add(declaredMember, DeclaredType.FIELD);
        }

        public ReflectiveOperation<?> build() {
            assert (!this.reflectiveOperationBuilderList.isEmpty());
            ReflectiveOperation lastOperation = null;
            for (int i = this.reflectiveOperationBuilderList.size() - 1; i >= 0; --i) {
                lastOperation = this.reflectiveOperationBuilderList.get(i).build(lastOperation);
            }
            return lastOperation;
        }
    }

    public static class ReflectiveFieldOperation
    extends ReflectiveOperation<Field> {
        private ReflectiveFieldOperation(Class<?> classForDeclaration, String declaredMember, ReflectiveOperation<?> nextOperation, Consumer<Field> modifier) {
            super(classForDeclaration, declaredMember, nextOperation, modifier);
        }

        @Override
        public Object compute(Object object) throws Exception {
            Class clazz = this.classForDeclaration == null ? object.getClass() : this.classForDeclaration;
            Field declaredField = clazz.getDeclaredField(this.declaredMember);
            this.modifier.accept(declaredField);
            Object fieldValue = declaredField.get(object);
            return this.nextOperation != null ? this.nextOperation.compute(fieldValue) : fieldValue;
        }
    }

    public static class ReflectiveMethodOperation
    extends ReflectiveOperation<Method> {
        private ReflectiveMethodOperation(Class<?> classForDeclaration, String declaredMember, ReflectiveOperation<?> nextOperation, Consumer<Method> modifier) {
            super(classForDeclaration, declaredMember, nextOperation, modifier);
        }

        @Override
        public Object compute(Object object) throws Exception {
            Class clazz = this.classForDeclaration == null ? object.getClass() : this.classForDeclaration;
            Method declaredMethod = clazz.getDeclaredMethod(this.declaredMember, new Class[0]);
            this.modifier.accept(declaredMethod);
            Object returnValue = declaredMethod.invoke(object, new Object[0]);
            return this.nextOperation != null ? this.nextOperation.compute(returnValue) : returnValue;
        }
    }

    public static abstract class ReflectiveOperation<Member> {
        final Class<?> classForDeclaration;
        final String declaredMember;
        final Consumer<Member> modifier;
        final ReflectiveOperation<?> nextOperation;

        private ReflectiveOperation(Class<?> classForDeclaration, String declaredMember, ReflectiveOperation<?> nextOperation, Consumer<Member> modifier) {
            this.classForDeclaration = classForDeclaration;
            this.declaredMember = declaredMember;
            this.nextOperation = nextOperation;
            this.modifier = modifier;
        }

        public abstract Object compute(Object var1) throws Exception;
    }

    public static enum DeclaredType {
        FIELD,
        METHOD;

    }
}

