/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.Diagnostic;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.DiagnosticsLevel;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.utils.AbortException;
import com.android.tools.r8.utils.StringDiagnostic;
import java.util.ArrayList;
import java.util.List;

public class Reporter
implements DiagnosticsHandler {
    private final DiagnosticsHandler clientHandler;
    private final List<DiagnosticsLevelMapping> diagnosticsLevelMapping = new ArrayList<DiagnosticsLevelMapping>();
    private AbortException abort = null;

    public Reporter() {
        this(new DiagnosticsHandler(){});
    }

    public Reporter(DiagnosticsHandler clientHandler) {
        this.clientHandler = clientHandler;
    }

    private void handleDiagnostic(DiagnosticsLevel level, Diagnostic diagnostic) {
        if (level != null) {
            DiagnosticsLevel modifiedLevel = this.clientHandler.modifyDiagnosticsLevel(level, diagnostic);
            level = modifiedLevel != null ? modifiedLevel : level;
            level = this.mapDiagnosticsLevel(level, diagnostic);
        } else {
            level = DiagnosticsLevel.ERROR;
        }
        switch (level) {
            case INFO: {
                this.clientHandler.info(diagnostic);
                break;
            }
            case WARNING: {
                this.clientHandler.warning(diagnostic);
                break;
            }
            case ERROR: {
                this.abort = new AbortException(diagnostic);
                this.clientHandler.error(diagnostic);
                break;
            }
            default: {
                throw new Unreachable();
            }
        }
    }

    private DiagnosticsLevel mapDiagnosticsLevel(DiagnosticsLevel level, Diagnostic diagnostic) {
        for (DiagnosticsLevelMapping diagnosticsLevelMapping : this.diagnosticsLevelMapping) {
            level = diagnosticsLevelMapping.map(level, diagnostic);
        }
        return level;
    }

    @Override
    public synchronized void info(Diagnostic info) {
        this.handleDiagnostic(DiagnosticsLevel.INFO, info);
    }

    public void info(String message) {
        this.info(new StringDiagnostic(message));
    }

    @Override
    public synchronized void warning(Diagnostic warning) {
        this.handleDiagnostic(DiagnosticsLevel.WARNING, warning);
    }

    public void warning(String message) {
        this.warning(new StringDiagnostic(message));
    }

    @Override
    public synchronized void error(Diagnostic error) {
        this.handleDiagnostic(DiagnosticsLevel.ERROR, error);
    }

    public void error(String message) {
        this.error(new StringDiagnostic(message));
    }

    public RuntimeException fatalError(String message) {
        throw this.fatalError(new StringDiagnostic(message));
    }

    public RuntimeException fatalError(Diagnostic error) {
        this.handleDiagnostic(null, error);
        throw this.abort;
    }

    public synchronized void failIfPendingErrors() {
        if (this.abort != null) {
            throw new RuntimeException(this.abort);
        }
    }

    public void addDiagnosticsLevelMapping(DiagnosticsLevel from, String diagnosticsClassName, DiagnosticsLevel to) {
        this.diagnosticsLevelMapping.add(new DiagnosticsLevelMapping(from, to, diagnosticsClassName));
    }

    private static class DiagnosticsLevelMapping {
        private final DiagnosticsLevel from;
        private final DiagnosticsLevel to;
        private final String diagnosticsClassName;

        public DiagnosticsLevelMapping(DiagnosticsLevel from, DiagnosticsLevel to, String diagnosticsClassName) {
            this.from = from;
            this.to = to;
            this.diagnosticsClassName = diagnosticsClassName;
        }

        public DiagnosticsLevel map(DiagnosticsLevel level, Diagnostic diagnostic) {
            if (level != this.from) {
                return level;
            }
            if (this.diagnosticsClassName.length() == 0 || this.diagnosticsClassName.equals(diagnostic.getClass().getSimpleName()) || this.diagnosticsClassName.equals(diagnostic.getClass().getTypeName())) {
                return this.to;
            }
            for (Class<?> clazz : diagnostic.getClass().getInterfaces()) {
                if (!this.diagnosticsClassName.equals(clazz.getSimpleName()) && !this.diagnosticsClassName.equals(clazz.getTypeName())) continue;
                return this.to;
            }
            return level;
        }
    }
}

