/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import java.util.Objects;

public class SemanticVersion {
    private final int major;
    private final int minor;
    private final int patch;
    private final String prerelease;

    public static SemanticVersion parse(String version) {
        String prerelease;
        int patch;
        int minor;
        int major;
        int majorEnd = version.indexOf(46);
        if (majorEnd <= 0) {
            throw new IllegalArgumentException("Invalid semantic version: " + version);
        }
        int minorEnd = version.indexOf(46, majorEnd + 1);
        if (minorEnd <= majorEnd + 1) {
            throw new IllegalArgumentException("Invalid semantic version: " + version);
        }
        int patchEnd = version.indexOf(45, minorEnd + 1);
        int prereleaseEnd = -1;
        if (patchEnd == -1) {
            patchEnd = version.length();
        } else {
            if (patchEnd <= minorEnd + 1) {
                throw new IllegalArgumentException("Invalid semantic version: " + version);
            }
            prereleaseEnd = version.length();
        }
        try {
            major = Integer.parseInt(version.substring(0, majorEnd));
            minor = Integer.parseInt(version.substring(majorEnd + 1, minorEnd));
            patch = Integer.parseInt(version.substring(minorEnd + 1, patchEnd));
            prerelease = prereleaseEnd < 0 ? null : version.substring(patchEnd + 1, prereleaseEnd);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid semantic version: " + version, e);
        }
        return SemanticVersion.create(major, minor, patch, prerelease);
    }

    private SemanticVersion(int major, int minor, int patch, String prerelease) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.prerelease = prerelease;
    }

    public static SemanticVersion create(int major, int minor, int patch) {
        return SemanticVersion.create(major, minor, patch, null);
    }

    public static SemanticVersion create(int major, int minor, int patch, String prerelease) {
        return new SemanticVersion(major, minor, patch, prerelease);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public boolean isNewerOrEqual(SemanticVersion other) {
        if (this.major != other.major) {
            return this.major > other.major;
        }
        if (this.minor != other.minor) {
            return this.minor > other.minor;
        }
        return this.patch >= other.patch;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SemanticVersion)) {
            return false;
        }
        SemanticVersion other = (SemanticVersion)obj;
        return this.major == other.major && this.minor == other.minor && this.patch == other.patch && Objects.equals(this.prerelease, other.prerelease);
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch, this.prerelease);
    }

    public String toString() {
        return "" + this.major + "." + this.minor + "." + this.patch + (this.prerelease != null ? "-" + this.prerelease : "");
    }
}

