/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.utils.IterableUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    public static char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final String[] EMPTY_ARRAY = new String[0];
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final char BOM = '\ufeff';

    public static String toASCIIString(String s2) {
        StringBuilder builder = new StringBuilder();
        for (char ch : s2.toCharArray()) {
            if ('\u001f' < ch && ch < '\u007f') {
                builder.append(ch);
                continue;
            }
            builder.append("\\u").append(StringUtils.hexString(ch, 4, false));
        }
        return builder.toString();
    }

    public static boolean appendNonEmpty(StringBuilder builder, String pre, Object item, String post) {
        if (item == null) {
            return false;
        }
        String text = item.toString();
        if (!text.isEmpty()) {
            if (pre != null) {
                builder.append(pre);
            }
            builder.append(text);
            if (post != null) {
                builder.append(post);
            }
            return true;
        }
        return false;
    }

    public static StringBuilder appendIndent(StringBuilder builder, String subject, int indent) {
        for (int i = 0; i < indent; ++i) {
            builder.append(" ");
        }
        builder.append(subject);
        return builder;
    }

    public static StringBuilder appendLeftPadded(StringBuilder builder, String subject, int width) {
        for (int i = subject.length(); i < width; ++i) {
            builder.append(" ");
        }
        builder.append(subject);
        return builder;
    }

    public static StringBuilder appendRightPadded(StringBuilder builder, String subject, int width) {
        builder.append(subject);
        for (int i = subject.length(); i < width; ++i) {
            builder.append(" ");
        }
        return builder;
    }

    public static <T> StringBuilder append(StringBuilder builder, Collection<T> collection) {
        return StringUtils.append(builder, collection, ", ", BraceType.PARENS);
    }

    public static <T> StringBuilder append(StringBuilder builder, Iterable<T> collection, String seperator, BraceType brace) {
        builder.append(brace.left());
        boolean first = true;
        for (T element : collection) {
            if (first) {
                first = false;
            } else {
                builder.append(seperator);
            }
            builder.append(element);
        }
        builder.append(brace.right());
        return builder;
    }

    public static String join(String separator, String ... strings) {
        return StringUtils.join(separator, Arrays.asList(strings));
    }

    public static <T> String join(String separator, Iterable<T> iterable) {
        return StringUtils.join(separator, iterable, BraceType.NONE);
    }

    public static <T> String join(String separator, Iterable<T> iterable, Function<T, String> fn) {
        return StringUtils.join(separator, iterable, fn, BraceType.NONE);
    }

    public static <T> String join(String separator, Iterable<T> iterable, BraceType brace) {
        return StringUtils.join(separator, iterable, Object::toString, brace);
    }

    public static <T> String join(String separator, Iterable<T> iterable, Function<T, String> fn, BraceType brace) {
        StringBuilder builder = new StringBuilder();
        StringUtils.append(builder, IterableUtils.transform(iterable, fn), separator, brace);
        return builder.toString();
    }

    public static String lines(List<String> lines) {
        StringBuilder builder = new StringBuilder();
        for (String line : lines) {
            builder.append(line).append(LINE_SEPARATOR);
        }
        return builder.toString();
    }

    public static String lines(String ... lines) {
        return StringUtils.lines(Arrays.asList(lines));
    }

    public static String withNativeLineSeparator(String s2) {
        s2 = s2.replace("\r\n", "\n");
        if (LINE_SEPARATOR.equals("\r\n")) {
            return s2.replace("\n", "\r\n");
        }
        assert (LINE_SEPARATOR.equals("\n"));
        return s2;
    }

    public static String joinLines(String ... lines) {
        return StringUtils.join(LINE_SEPARATOR, lines);
    }

    public static <T> String joinLines(Collection<T> collection) {
        return StringUtils.join(LINE_SEPARATOR, collection, BraceType.NONE);
    }

    public static List<String> splitLines(String content) {
        String line;
        int length = content.length();
        ArrayList<String> lines = new ArrayList<String>();
        int start = 0;
        for (int i = 0; i < length; ++i) {
            char c = content.charAt(i);
            int end = i;
            if (c == '\r' && i + 1 < length && content.charAt(i + 1) == '\n') {
                ++i;
            } else if (c != '\n') continue;
            lines.add(content.substring(start, end));
            start = i + 1;
        }
        if (start < length && !(line = content.substring(start)).isEmpty()) {
            lines.add(line);
        }
        return lines;
    }

    public static String zeroPrefix(int i, int width) {
        return StringUtils.zeroPrefixString(Integer.toString(i), width);
    }

    private static String zeroPrefixString(String s2, int width) {
        String prefix = "0000000000000000";
        assert (width <= prefix.length());
        int prefixLength = width - s2.length();
        if (prefixLength > 0) {
            StringBuilder builder = new StringBuilder();
            builder.append(prefix, 0, prefixLength);
            builder.append(s2);
            return builder.toString();
        }
        return s2;
    }

    public static String hexString(int value, int width) {
        return StringUtils.hexString(value, width, true);
    }

    public static String hexString(int value, int width, boolean zeroXPrefix) {
        assert (0 <= width && width <= 8);
        String prefix = zeroXPrefix ? "0x" : "";
        String hex = Integer.toHexString(value);
        if (value >= 0) {
            return prefix + StringUtils.zeroPrefixString(hex, width);
        }
        assert (hex.length() == 8);
        return prefix + hex;
    }

    public static String hexString(long value, int width) {
        return StringUtils.hexString(value, width, true);
    }

    public static String hexString(long value, int width, boolean zeroXPrefix) {
        assert (0 <= width && width <= 16);
        String prefix = zeroXPrefix ? "0x" : "";
        String hex = Long.toHexString(value);
        if (value >= 0L) {
            return prefix + StringUtils.zeroPrefixString(hex, width);
        }
        assert (hex.length() == 16);
        return prefix + hex;
    }

    public static String computeMD5Hash(String name) {
        byte[] digest = null;
        try {
            MessageDigest m3 = MessageDigest.getInstance("MD5");
            m3.reset();
            m3.update(name.getBytes());
            digest = m3.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return Arrays.toString(digest);
    }

    public static String times(String string, int count) {
        StringBuilder builder = new StringBuilder();
        while (--count >= 0) {
            builder.append(string);
        }
        return builder.toString();
    }

    public static boolean isBOM(int codePoint) {
        return codePoint == 65279;
    }

    public static boolean isWhitespace(int codePoint) {
        return Character.isWhitespace(codePoint) || StringUtils.isBOM(codePoint);
    }

    public static String stripLeadingBOM(String s2) {
        if (s2.length() > 0 && s2.charAt(0) == '\ufeff') {
            return s2.substring(1);
        }
        return s2;
    }

    public static String trim(String s2) {
        int beginIndex;
        int endIndex = s2.length();
        for (beginIndex = 0; beginIndex < endIndex && StringUtils.isWhitespace(s2.charAt(beginIndex)); ++beginIndex) {
        }
        while (endIndex - 1 > beginIndex && StringUtils.isWhitespace(s2.charAt(endIndex - 1))) {
            --endIndex;
        }
        if (beginIndex > 0 || endIndex < s2.length()) {
            return s2.substring(beginIndex, endIndex);
        }
        return s2;
    }

    public static boolean onlyContainsDigits(String s2) {
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static char lastChar(String s2) {
        return StringUtils.charFromEnd(s2, 0);
    }

    public static char charFromEnd(String s2, int charsFromEnd) {
        assert (s2.length() > charsFromEnd);
        return s2.charAt(s2.length() - (charsFromEnd + 1));
    }

    public static int firstNonWhitespaceCharacter(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (StringUtils.isWhitespace(string.charAt(i))) continue;
            return i;
        }
        return string.length();
    }

    public static String replaceAll(String subject, String target, String replacement) {
        return subject.replaceAll(Pattern.quote(target), Matcher.quoteReplacement(replacement));
    }

    public static String stacktraceAsString(Throwable throwable) {
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static String capitalize(String stringToCapitalize) {
        if (stringToCapitalize == null || stringToCapitalize.isEmpty()) {
            return stringToCapitalize;
        }
        return stringToCapitalize.substring(0, 1).toUpperCase() + stringToCapitalize.substring(1);
    }

    public static enum BraceType {
        PARENS,
        SQUARE,
        TUBORG,
        NONE;


        public String left() {
            switch (this) {
                case PARENS: {
                    return "(";
                }
                case SQUARE: {
                    return "[";
                }
                case TUBORG: {
                    return "{";
                }
                case NONE: {
                    return "";
                }
            }
            throw new Unreachable("Invalid brace type: " + (Object)((Object)this));
        }

        public String right() {
            switch (this) {
                case PARENS: {
                    return ")";
                }
                case SQUARE: {
                    return "]";
                }
                case TUBORG: {
                    return "}";
                }
                case NONE: {
                    return "";
                }
            }
            throw new Unreachable("Invalid brace type: " + (Object)((Object)this));
        }
    }
}

