/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.com.google.common.base.Suppliers;
import com.android.tools.r8.utils.Box;
import com.android.tools.r8.utils.ThrowingSupplier;
import java.util.function.Supplier;

public class SupplierUtils {
    public static <T> Supplier<T> nonThreadSafeMemoize(Supplier<T> supplier) {
        Box box = new Box();
        return () -> box.computeIfAbsent(supplier);
    }

    public static <T, E extends Throwable> Supplier<T> memoize(ThrowingSupplier<T, E> supplier) {
        return Suppliers.memoize(() -> {
            try {
                return supplier.get();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        });
    }
}

