/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.utils.Action;
import com.android.tools.r8.utils.ForEachable;
import com.android.tools.r8.utils.IntBox;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.ThrowingBiConsumer;
import com.android.tools.r8.utils.ThrowingBiFunction;
import com.android.tools.r8.utils.ThrowingConsumer;
import com.android.tools.r8.utils.ThrowingFunction;
import com.android.tools.r8.utils.ThrowingReferenceIntConsumer;
import com.android.tools.r8.utils.ThrowingReferenceIntFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;

public class ThreadUtils {
    public static final int NOT_SPECIFIED = -1;

    public static <T> Future<T> processAsynchronously(Action action, ExecutorService executorService) {
        return ThreadUtils.processAsynchronously(() -> {
            action.execute();
            return null;
        }, executorService);
    }

    public static <T> Future<T> processAsynchronously(Callable<T> callable, ExecutorService executorService) {
        return executorService.submit(callable);
    }

    public static <T, R, E extends Exception> Collection<R> processItemsWithResults(Iterable<T> items, ThrowingFunction<T, R, E> consumer, ExecutorService executorService) throws ExecutionException {
        return ThreadUtils.processItemsWithResults(items, (T item, int i) -> consumer.apply(item), executorService);
    }

    public static <T, R, E extends Exception> Collection<R> processItemsWithResults(Iterable<T> items, ThrowingReferenceIntFunction<T, R, E> consumer, ExecutorService executorService) throws ExecutionException {
        return ThreadUtils.processItemsWithResults(items::forEach, consumer, executorService);
    }

    public static <T, R, E extends Exception> Collection<R> processItemsWithResults(ForEachable<T> items, ThrowingFunction<T, R, E> consumer, ExecutorService executorService) throws ExecutionException {
        return ThreadUtils.processItemsWithResults(items, (T item, int i) -> consumer.apply(item), executorService);
    }

    public static <T, R, E extends Exception> Collection<R> processItemsWithResults(ForEachable<T> items, ThrowingReferenceIntFunction<T, R, E> consumer, ExecutorService executorService) throws ExecutionException {
        IntBox indexSupplier = new IntBox();
        ArrayList futures = new ArrayList();
        items.forEach(item -> {
            int index = indexSupplier.getAndIncrement();
            futures.add(executorService.submit(() -> consumer.apply(item, index)));
        });
        return ThreadUtils.awaitFuturesWithResults(futures);
    }

    public static <T, E extends Exception> void processItems(Iterable<T> items, ThrowingConsumer<T, E> consumer, ExecutorService executorService) throws ExecutionException {
        ThreadUtils.processItems(items, (T item, int i) -> consumer.accept(item), executorService);
    }

    public static <T, E extends Exception> void processItems(Iterable<T> items, ThrowingReferenceIntConsumer<T, E> consumer, ExecutorService executorService) throws ExecutionException {
        ThreadUtils.processItems(items::forEach, consumer, executorService);
    }

    public static <T, E extends Exception> void processItems(ForEachable<T> items, ThrowingConsumer<T, E> consumer, ExecutorService executorService) throws ExecutionException {
        ThreadUtils.processItems(items, (T item, int i) -> consumer.accept(item), executorService);
    }

    public static <T, E extends Exception> void processItems(ForEachable<T> items, ThrowingReferenceIntConsumer<T, E> consumer, ExecutorService executorService) throws ExecutionException {
        ThreadUtils.processItemsWithResults(items, (T item, int i) -> {
            consumer.accept(item, i);
            return null;
        }, executorService);
    }

    public static <T, U, E extends Exception> void processMap(Map<T, U> items, ThrowingBiConsumer<T, U, E> consumer, ExecutorService executorService) throws ExecutionException {
        ThreadUtils.processMapWithResults(items, (key, value) -> {
            consumer.accept(key, value);
            return null;
        }, executorService);
    }

    public static <T, U, R, E extends Exception> Collection<R> processMapWithResults(Map<T, U> items, ThrowingBiFunction<T, U, R, E> consumer, ExecutorService executorService) throws ExecutionException {
        return ThreadUtils.processItemsWithResults(items.entrySet(), (T arg) -> consumer.apply(arg.getKey(), arg.getValue()), executorService);
    }

    public static <E extends Exception> void processMethods(AppView<?> appView, ThrowingConsumer<ProgramMethod, E> consumer, ExecutorService executorService) throws ExecutionException {
        ThreadUtils.processItems(((AppInfo)appView.appInfo()).classes(), (T clazz) -> clazz.forEachProgramMethod(consumer::acceptWithRuntimeException), executorService);
    }

    public static void awaitFutures(Iterable<? extends Future<?>> futures) throws ExecutionException {
        Iterator<Future<?>> futureIterator = futures.iterator();
        try {
            while (futureIterator.hasNext()) {
                futureIterator.next().get();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting for future.", e);
        }
        finally {
            while (futureIterator.hasNext()) {
                try {
                    futureIterator.next().get();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static <R> Collection<R> awaitFuturesWithResults(Collection<? extends Future<R>> futures) throws ExecutionException {
        ArrayList<R> results = new ArrayList<R>(futures.size());
        Iterator<Future<R>> futureIterator = futures.iterator();
        try {
            while (futureIterator.hasNext()) {
                results.add(futureIterator.next().get());
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting for future.", e);
        }
        finally {
            while (futureIterator.hasNext()) {
                try {
                    futureIterator.next().get();
                }
                catch (Throwable throwable) {}
            }
        }
        return results;
    }

    static ExecutorService getExecutorServiceForProcessors(int processors) {
        int threads = processors <= 2 ? processors : (int)Math.ceil((double)Integer.min(processors, 16) / 2.0);
        return ThreadUtils.getExecutorServiceForThreads(threads);
    }

    static ExecutorService getExecutorServiceForThreads(int threads) {
        return Executors.newWorkStealingPool(threads);
    }

    public static ExecutorService getExecutorService(int threads) {
        return threads == -1 ? ThreadUtils.getExecutorServiceForProcessors(Runtime.getRuntime().availableProcessors()) : ThreadUtils.getExecutorServiceForThreads(threads);
    }

    public static ExecutorService getExecutorService(InternalOptions options) {
        return ThreadUtils.getExecutorService(options.threadCount);
    }

    public static int getNumberOfThreads(ExecutorService service) {
        if (service instanceof ForkJoinPool) {
            return ((ForkJoinPool)service).getParallelism();
        }
        return -1;
    }
}

