/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.com.google.common.base.Strings;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.ThrowingAction;
import com.android.tools.r8.utils.ThrowingSupplier;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;

public class Timing {
    private static final int MINIMUM_REPORT_PERCENTAGE = 2;
    private static final Timing EMPTY = new Timing("<empty>", false){

        @Override
        public TimingMerger beginMerger(String title, int numberOfThreads) {
            return new TimingMerger(null, -1, (Timing)this){

                @Override
                public void add(Collection<Timing> timings) {
                }

                @Override
                public void end() {
                }
            };
        }

        @Override
        public void begin(String title) {
        }

        @Override
        public void end() {
        }

        @Override
        public void report() {
        }
    };
    private final Node top;
    private final Stack<Node> stack;
    private final boolean trackMemory;

    public static Timing empty() {
        return EMPTY;
    }

    public static Timing create(String title, InternalOptions options) {
        return options.printTimes || InternalOptions.assertionsEnabled() ? new Timing(title, options.printMemory) : Timing.empty();
    }

    public static Timing create(String title, boolean printMemory) {
        return new Timing(title, printMemory);
    }

    @Deprecated
    public Timing(String title) {
        this(title, false);
    }

    private Timing(String title, boolean trackMemory) {
        this.trackMemory = trackMemory;
        this.stack = new Stack();
        this.top = new Node(title, trackMemory);
        this.stack.push(this.top);
    }

    private static long percentage(long part, long total) {
        return part * 100L / total;
    }

    private static String prettyPercentage(long part, long total) {
        return Timing.percentage(part, total) + "%";
    }

    private static String prettyTime(long value) {
        return value / 1000000L + "ms";
    }

    private static String prettySize(long value) {
        return Timing.prettyNumber(value / 1024L) + "k";
    }

    private static String prettyNumber(long value) {
        String printed = "" + Math.abs(value);
        if (printed.length() < 4) {
            return "" + value;
        }
        StringBuilder builder = new StringBuilder();
        if (value < 0L) {
            builder.append('-');
        }
        int prefix = printed.length() % 3;
        builder.append(printed, 0, prefix);
        for (int i = prefix; i < printed.length(); i += 3) {
            if (i > 0) {
                builder.append('.');
            }
            builder.append(printed, i, i + 3);
        }
        return builder.toString();
    }

    private static Map<String, MemInfo> computeMemoryInformation() {
        System.gc();
        LinkedHashMap<String, MemInfo> info = new LinkedHashMap<String, MemInfo>();
        info.put("Memory", MemInfo.fromTotalAndFree(Runtime.getRuntime().totalMemory(), Runtime.getRuntime().freeMemory()));
        return info;
    }

    public TimingMerger beginMerger(String title, int numberOfThreads) {
        return new TimingMerger(title, numberOfThreads, this);
    }

    public void begin(String title) {
        Node child;
        Node parent = this.stack.peek();
        if (parent.children.containsKey(title)) {
            child = parent.children.get(title);
            child.restart();
        } else {
            child = new Node(title, this.trackMemory);
            parent.children.put(title, child);
        }
        this.stack.push(child);
    }

    public <E extends Exception> void time(String title, ThrowingAction<E> action) throws E {
        this.begin(title);
        try {
            action.execute();
        }
        finally {
            this.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Exception> T time(String title, ThrowingSupplier<T, E> supplier) throws E {
        this.begin(title);
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.end();
        }
    }

    public void end() {
        this.stack.peek().end();
        this.stack.pop();
    }

    public void report() {
        assert (this.stack.size() == 1);
        Node top = this.stack.peek();
        assert (top == this.top);
        top.end();
        System.out.println("Recorded timings:");
        top.report(0, top);
    }

    public static class TimingMerger {
        final Node parent;
        final Node merged;
        private int taskCount = 0;
        private Node slowest = new Node("<zero>", false);

        private TimingMerger(String title, final int numberOfThreads, Timing timing) {
            this.parent = (Node)timing.stack.peek();
            this.merged = new Node(title, timing.trackMemory){

                @Override
                public void report(int depth, Node top) {
                    assert (this.duration() >= 0L);
                    this.printPrefix(depth);
                    System.out.print(this.toString());
                    if (numberOfThreads <= 0) {
                        System.out.println(" (unknown thread count)");
                    } else {
                        long walltime = parent.duration();
                        long perThreadTime = this.duration() / (long)numberOfThreads;
                        System.out.println(", tasks: " + taskCount + ", threads: " + numberOfThreads + ", utilization: " + Timing.prettyPercentage(perThreadTime, walltime));
                    }
                    if (this.trackMemory) {
                        this.printMemory(depth);
                    }
                    this.children.forEach((title, node) -> node.report(depth + 1, this));
                    if (((TimingMerger)this).slowest.duration > 0L) {
                        this.printPrefix(depth);
                        System.out.println("SLOWEST " + slowest.toString(this));
                        ((TimingMerger)this).slowest.children.forEach((title, node) -> node.report(depth + 1, this));
                    }
                }

                @Override
                public String toString() {
                    return "MERGE " + super.toString();
                }
            };
        }

        public void add(Collection<Timing> timings) {
            boolean trackMemory = this.merged.trackMemory;
            ArrayDeque<Item> worklist = new ArrayDeque<Item>();
            for (Timing timing : timings) {
                if (timing == Timing.empty()) continue;
                assert (timing.stack.isEmpty()) : "Expected sub-timing to have completed prior to merge";
                ++this.taskCount;
                this.merged.duration += ((Timing)timing).top.duration;
                if (((Timing)timing).top.duration > this.slowest.duration) {
                    this.slowest = timing.top;
                }
                worklist.addLast(new Item(this.merged, timing.top));
            }
            while (!worklist.isEmpty()) {
                Item item = (Item)worklist.pollFirst();
                item.mergeSource.children.forEach((title, child) -> {
                    Node mergeTarget = item.mergeTarget.children.computeIfAbsent((String)title, t -> new Node((String)t, trackMemory));
                    mergeTarget.duration += child.duration;
                    if (!child.children.isEmpty()) {
                        worklist.addLast(new Item(mergeTarget, (Node)child));
                    }
                });
            }
        }

        public void end() {
            assert (!this.parent.children.containsKey(this.merged.title));
            this.parent.children.put(this.merged.title, this.merged);
        }

        private static class Item {
            final Node mergeTarget;
            final Node mergeSource;

            public Item(Node mergeTarget, Node mergeSource) {
                this.mergeTarget = mergeTarget;
                this.mergeSource = mergeSource;
            }
        }
    }

    static class Node {
        final String title;
        final boolean trackMemory;
        final Map<String, Node> children = new LinkedHashMap<String, Node>();
        long duration = 0L;
        long start_time;
        Map<String, MemInfo> startMemory;
        Map<String, MemInfo> endMemory;

        Node(String title, boolean trackMemory) {
            this.title = title;
            this.trackMemory = trackMemory;
            if (trackMemory) {
                this.startMemory = Timing.computeMemoryInformation();
            }
            this.start_time = System.nanoTime();
        }

        void restart() {
            assert (this.start_time == -1L);
            if (this.trackMemory) {
                this.startMemory = Timing.computeMemoryInformation();
            }
            this.start_time = System.nanoTime();
        }

        void end() {
            this.duration += System.nanoTime() - this.start_time;
            this.start_time = -1L;
            assert (this.duration() >= 0L);
            if (this.trackMemory) {
                this.endMemory = Timing.computeMemoryInformation();
            }
        }

        long duration() {
            return this.duration;
        }

        public String toString() {
            return this.title + ": " + Timing.prettyTime(this.duration());
        }

        public String toString(Node top) {
            if (this == top) {
                return this.toString();
            }
            return "(" + Timing.prettyPercentage(this.duration(), top.duration()) + ") " + this.toString();
        }

        public void report(int depth, Node top) {
            long unaccounted;
            assert (this.duration() >= 0L);
            if (Timing.percentage(this.duration(), top.duration()) < 2L) {
                return;
            }
            this.printPrefix(depth);
            System.out.println(this.toString(top));
            if (this.trackMemory) {
                this.printMemory(depth);
            }
            if (this.children.isEmpty()) {
                return;
            }
            Collection<Node> childNodes = this.children.values();
            long childTime = 0L;
            for (Node childNode : childNodes) {
                childTime += childNode.duration();
            }
            if (childTime < this.duration() && Timing.percentage(unaccounted = this.duration() - childTime, top.duration()) >= 2L) {
                this.printPrefix(depth + 1);
                System.out.println("(" + Timing.prettyPercentage(unaccounted, top.duration()) + ") Unaccounted: " + Timing.prettyTime(unaccounted));
            }
            childNodes.forEach(p -> p.report(depth + 1, top));
        }

        void printPrefix(int depth) {
            if (depth > 0) {
                System.out.print(Strings.repeat("  ", depth));
                System.out.print("- ");
            }
        }

        void printMemory(int depth) {
            for (Map.Entry<String, MemInfo> start : this.startMemory.entrySet()) {
                if (!start.getKey().equals("Memory")) continue;
                for (int i = 0; i <= depth; ++i) {
                    System.out.print("  ");
                }
                MemInfo endValue = this.endMemory.get(start.getKey());
                MemInfo startValue = start.getValue();
                System.out.println(start.getKey() + " start: " + Timing.prettySize(startValue.used) + ", end: " + Timing.prettySize(endValue.used) + ", delta: " + Timing.prettySize(endValue.usedDelta(startValue)));
            }
        }
    }

    private static class MemInfo {
        final long used;

        MemInfo(long used) {
            this.used = used;
        }

        public static MemInfo fromTotalAndFree(long total, long free) {
            return new MemInfo(total - free);
        }

        long usedDelta(MemInfo previous) {
            return this.used - previous.used;
        }
    }
}

