/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.errors.Unreachable;

public abstract class TraversalContinuation<T> {
    public static TraversalContinuation<?> breakIf(boolean condition) {
        return TraversalContinuation.continueIf(!condition);
    }

    public static TraversalContinuation<?> continueIf(boolean condition) {
        return condition ? TraversalContinuation.doContinue() : TraversalContinuation.doBreak();
    }

    public static <T> TraversalContinuation<T> doContinue() {
        return Continue.CONTINUE;
    }

    public static TraversalContinuation<?> doBreak() {
        return Break.BREAK_NO_VALUE;
    }

    public static <T> TraversalContinuation<T> doBreak(T value) {
        return new Break(value);
    }

    public boolean isBreak() {
        return !this.isContinue();
    }

    public boolean isContinue() {
        return false;
    }

    public Break<T> asBreak() {
        return null;
    }

    public final boolean shouldBreak() {
        return this.isBreak();
    }

    public final boolean shouldContinue() {
        return this.isContinue();
    }

    public static class Break<T>
    extends TraversalContinuation<T> {
        private static final TraversalContinuation<?> BREAK_NO_VALUE = new Break<Object>(null){

            @Override
            public Object getValue() {
                return new Unreachable("Invalid attempt at getting a value from a no-value break state.");
            }
        };
        private final T value;

        private Break(T value) {
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }

        @Override
        public Break<T> asBreak() {
            return this;
        }
    }

    public static final class Continue<T>
    extends TraversalContinuation<T> {
        private static final TraversalContinuation<?> CONTINUE = new Continue();

        private Continue() {
        }

        @Override
        public boolean isContinue() {
            return true;
        }
    }
}

