/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.references.ArrayReference;
import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.references.PrimitiveReference;
import com.android.tools.r8.references.TypeReference;
import com.android.tools.r8.utils.ClassReferenceUtils;
import com.android.tools.r8.utils.ListUtils;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;

public class TypeReferenceUtils {
    private static final Comparator<TypeReference> COMPARATOR = (type, other) -> {
        if (type == other) {
            return 0;
        }
        if (type == null) {
            return -1;
        }
        if (other == null) {
            return 1;
        }
        return type.getDescriptor().compareTo(other.getDescriptor());
    };

    public static Comparator<TypeReference> getTypeReferenceComparator() {
        return COMPARATOR;
    }

    public static DexProto toDexProto(List<TypeReference> formalTypes, TypeReference returnType, DexItemFactory dexItemFactory) {
        return TypeReferenceUtils.toDexProto(formalTypes, returnType, dexItemFactory, classReference -> ClassReferenceUtils.toDexType(classReference, dexItemFactory));
    }

    public static DexProto toDexProto(List<TypeReference> formalTypes, TypeReference returnType, DexItemFactory dexItemFactory, Function<ClassReference, DexType> classReferenceConverter) {
        return dexItemFactory.createProto(TypeReferenceUtils.toDexType(returnType, dexItemFactory, classReferenceConverter), ListUtils.map(formalTypes, formalType -> TypeReferenceUtils.toDexType(formalType, dexItemFactory, classReferenceConverter)));
    }

    public static DexType toDexType(TypeReference typeReference, DexItemFactory dexItemFactory) {
        return TypeReferenceUtils.toDexType(typeReference, dexItemFactory, classReference -> ClassReferenceUtils.toDexType(classReference, dexItemFactory));
    }

    public static DexType toDexType(TypeReference typeReference, DexItemFactory dexItemFactory, Function<ClassReference, DexType> classReferenceConverter) {
        if (typeReference == null) {
            return dexItemFactory.voidType;
        }
        if (typeReference.isPrimitive()) {
            PrimitiveReference primitiveReference = typeReference.asPrimitive();
            switch (primitiveReference.getDescriptor().charAt(0)) {
                case 'Z': {
                    return dexItemFactory.booleanType;
                }
                case 'B': {
                    return dexItemFactory.byteType;
                }
                case 'C': {
                    return dexItemFactory.charType;
                }
                case 'S': {
                    return dexItemFactory.shortType;
                }
                case 'I': {
                    return dexItemFactory.intType;
                }
                case 'F': {
                    return dexItemFactory.floatType;
                }
                case 'J': {
                    return dexItemFactory.longType;
                }
                case 'D': {
                    return dexItemFactory.doubleType;
                }
            }
            throw new Unreachable("Invalid primitive descriptor: " + primitiveReference.getDescriptor());
        }
        if (typeReference.isArray()) {
            ArrayReference arrayReference = typeReference.asArray();
            TypeReference baseType = arrayReference.getBaseType();
            return dexItemFactory.createArrayType(arrayReference.getDimensions(), TypeReferenceUtils.toDexType(baseType, dexItemFactory, classReferenceConverter));
        }
        assert (typeReference.isClass());
        return classReferenceConverter.apply(typeReference.asClass());
    }
}

