/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.NewInstance;
import com.android.tools.r8.ir.code.Value;

public class ValueUtils {
    public static boolean isStringBuilder(Value value, DexItemFactory dexItemFactory) {
        TypeElement type = value.getType();
        return type.isClassType() && type.asClassType().getClassType() == dexItemFactory.stringBuilderType;
    }

    public static boolean isNonNullStringBuilder(Value value, DexItemFactory dexItemFactory) {
        while (true) {
            InvokeVirtual invoke;
            if (value.isPhi()) {
                return false;
            }
            Instruction definition = value.getDefinition();
            if (definition.isNewInstance()) {
                NewInstance newInstance = definition.asNewInstance();
                return newInstance.clazz == dexItemFactory.stringBuilderType;
            }
            if (!definition.isInvokeVirtual() || !dexItemFactory.stringBuilderMethods.isAppendMethod((invoke = definition.asInvokeVirtual()).getInvokedMethod())) break;
            value = invoke.getReceiver();
        }
        return false;
    }
}

