/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class VersionProperties {
    public static final VersionProperties INSTANCE = VersionProperties.get();
    private static final String VERSION_CODE_KEY = "version-file.version.code";
    private static final String SHA_KEY = "version.sha";
    private static final String RELEASER_KEY = "releaser";
    private static final String RESOURCE_NAME = "r8-version.properties";
    private String sha;
    private String releaser;

    private static VersionProperties get() {
        VersionProperties versionProperties;
        block14: {
            InputStream resourceStream;
            block15: {
                ClassLoader loader = VersionProperties.class.getClassLoader();
                resourceStream = loader.getResourceAsStream(RESOURCE_NAME);
                Throwable throwable = null;
                try {
                    VersionProperties versionProperties2 = versionProperties = resourceStream == null ? new VersionProperties() : new VersionProperties(resourceStream);
                    if (resourceStream == null) break block14;
                    if (throwable == null) break block15;
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (resourceStream != null) {
                                if (throwable != null) {
                                    try {
                                        resourceStream.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                } else {
                                    resourceStream.close();
                                }
                            }
                            throw throwable3;
                        }
                    }
                    catch (IOException e) {
                        return new VersionProperties();
                    }
                }
                try {
                    resourceStream.close();
                }
                catch (Throwable throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                break block14;
            }
            resourceStream.close();
        }
        return versionProperties;
    }

    private VersionProperties() {
    }

    private VersionProperties(InputStream resourceStream) throws IOException {
        Properties prop = new Properties();
        prop.load(resourceStream);
        long versionFileVersion = Long.parseLong(prop.getProperty(VERSION_CODE_KEY));
        assert (versionFileVersion >= 1L);
        this.sha = prop.getProperty(SHA_KEY);
        this.releaser = prop.getProperty(RELEASER_KEY);
    }

    public String getDescription() {
        return "build " + this.getSha() + (this.releaser != null ? " from " + this.releaser : "");
    }

    public String getSha() {
        return this.isEngineering() ? "engineering" : this.sha;
    }

    public String toString() {
        return this.sha + " from " + this.releaser;
    }

    public boolean isEngineering() {
        return this.sha == null || this.sha.trim().isEmpty();
    }
}

