/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;

public class WorkList<T> {
    private final Deque<T> workingList = new ArrayDeque<T>();
    private final Set<T> seen;

    public static <T> WorkList<T> newEqualityWorkList() {
        return new WorkList<T>(EqualityTest.EQUALS);
    }

    public static <T> WorkList<T> newEqualityWorkList(T item) {
        WorkList<T> workList = new WorkList<T>(EqualityTest.EQUALS);
        workList.addIfNotSeen(item);
        return workList;
    }

    public static <T> WorkList<T> newEqualityWorkList(Iterable<T> items) {
        WorkList<T> workList = new WorkList<T>(EqualityTest.EQUALS);
        workList.addIfNotSeen(items);
        return workList;
    }

    public static <T> WorkList<T> newIdentityWorkList() {
        return new WorkList<T>(EqualityTest.IDENTITY);
    }

    public static <T> WorkList<T> newIdentityWorkList(T item) {
        WorkList<T> workList = new WorkList<T>(EqualityTest.IDENTITY);
        workList.addIfNotSeen(item);
        return workList;
    }

    public static <T> WorkList<T> newIdentityWorkList(T item, Set<T> seen) {
        WorkList<T> workList = new WorkList<T>(seen);
        workList.addIfNotSeen(item);
        return workList;
    }

    public static <T> WorkList<T> newIdentityWorkList(Iterable<T> items) {
        WorkList<T> workList = new WorkList<T>(EqualityTest.IDENTITY);
        workList.addIfNotSeen(items);
        return workList;
    }

    public static <T> WorkList<T> newWorkList(Set<T> seen) {
        return new WorkList<T>(seen);
    }

    private WorkList(EqualityTest equalityTest) {
        this(equalityTest == EqualityTest.EQUALS ? new HashSet() : Sets.newIdentityHashSet());
    }

    private WorkList(Set<T> seen) {
        this.seen = seen;
    }

    public void addIgnoringSeenSet(T item) {
        this.workingList.addLast(item);
    }

    public void addAllIgnoringSeenSet(Iterable<T> items) {
        items.forEach(this.workingList::addLast);
    }

    public void addIfNotSeen(Iterable<? extends T> items) {
        items.forEach(this::addIfNotSeen);
    }

    public void addIfNotSeen(T[] items) {
        for (T item : items) {
            this.addIfNotSeen(item);
        }
    }

    public boolean addIfNotSeen(T item) {
        if (this.seen.add(item)) {
            this.workingList.addLast(item);
            return true;
        }
        return false;
    }

    public boolean addFirstIfNotSeen(T item) {
        if (this.seen.add(item)) {
            this.workingList.addFirst(item);
            return true;
        }
        return false;
    }

    public void addFirstIgnoringSeenSet(T item) {
        this.workingList.addFirst(item);
    }

    public boolean hasNext() {
        return !this.workingList.isEmpty();
    }

    public boolean isEmpty() {
        return !this.hasNext();
    }

    public boolean isSeen(T item) {
        return this.seen.contains(item);
    }

    public void markAsSeen(T item) {
        this.seen.add(item);
    }

    public void markAsSeen(Iterable<T> items) {
        items.forEach(this::markAsSeen);
    }

    public T next() {
        assert (this.hasNext());
        return this.workingList.removeFirst();
    }

    public T removeSeen() {
        T next = this.next();
        this.seen.remove(next);
        return next;
    }

    public Set<T> getSeenSet() {
        return Collections.unmodifiableSet(this.seen);
    }

    public Set<T> getMutableSeenSet() {
        return this.seen;
    }

    public static enum EqualityTest {
        EQUALS,
        IDENTITY;

    }
}

