/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils.classhierarchy;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexMethodSignature;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.ImmediateProgramSubtypingInfo;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.optimize.argumentpropagation.utils.DepthFirstTopDownClassHierarchyTraversal;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.MapUtils;
import com.android.tools.r8.utils.collections.DexMethodSignatureSet;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class MethodOverridesCollector {
    public static ProgramMethodSet findAllMethodsAndOverridesThatMatches(AppView<AppInfoWithLiveness> appView, ImmediateProgramSubtypingInfo immediateSubtypingInfo, Collection<DexProgramClass> stronglyConnectedComponent, Predicate<ProgramMethod> predicate) {
        ProgramMethodSet classRootMethods = ProgramMethodSet.create();
        ProgramMethodSet interfaceRootMethods = ProgramMethodSet.create();
        for (DexProgramClass clazz : stronglyConnectedComponent) {
            clazz.forEachProgramMethod(method -> {
                if (predicate.test((ProgramMethod)method)) {
                    if (clazz.isInterface()) {
                        interfaceRootMethods.add(method);
                    } else {
                        classRootMethods.add(method);
                    }
                }
            });
        }
        if (!interfaceRootMethods.isEmpty()) {
            new InterfaceMethodToClassSiblingPropagator(appView, immediateSubtypingInfo, classRootMethods, interfaceRootMethods).run(stronglyConnectedComponent);
        }
        TopDownClassHierarchyPropagator topDownClassHierarchyPropagator = new TopDownClassHierarchyPropagator(appView, immediateSubtypingInfo, classRootMethods, interfaceRootMethods);
        topDownClassHierarchyPropagator.run(stronglyConnectedComponent);
        return topDownClassHierarchyPropagator.getResult();
    }

    private static class TopDownClassHierarchyPropagator
    extends DepthFirstTopDownClassHierarchyTraversal {
        private final Map<DexProgramClass, DexMethodSignatureSet> methodsOfInterest = new IdentityHashMap<DexProgramClass, DexMethodSignatureSet>();
        private final ProgramMethodSet result = ProgramMethodSet.create();

        TopDownClassHierarchyPropagator(AppView<AppInfoWithLiveness> appView, ImmediateProgramSubtypingInfo immediateSubtypingInfo, ProgramMethodSet classRootMethods, ProgramMethodSet interfaceRootMethods) {
            super(appView, immediateSubtypingInfo);
            classRootMethods.forEach(this::addRootMethod);
            interfaceRootMethods.forEach(this::addRootMethod);
        }

        private void addRootMethod(ProgramMethod method) {
            this.methodsOfInterest.computeIfAbsent(method.getHolder(), MapUtils.ignoreKey(DexMethodSignatureSet::create)).add(method);
        }

        ProgramMethodSet getResult() {
            return this.result;
        }

        @Override
        public void visit(DexProgramClass clazz) {
            DexMethodSignatureSet methodsOfInterestForClass = this.methodsOfInterest.computeIfAbsent(clazz, MapUtils.ignoreKey(DexMethodSignatureSet::create));
            this.immediateSubtypingInfo.forEachImmediateProgramSuperClass(clazz, superclass -> methodsOfInterestForClass.addAll(this.methodsOfInterest.get(superclass)));
            clazz.forEachProgramMethod(method -> {
                if (methodsOfInterestForClass.contains((DexClassAndMethod)method)) {
                    this.result.add(method);
                }
            });
        }

        @Override
        public void prune(DexProgramClass clazz) {
            this.methodsOfInterest.remove(clazz);
        }
    }

    private static class InterfaceMethodToClassSiblingPropagator
    extends DepthFirstTopDownClassHierarchyTraversal {
        private final ProgramMethodSet classRootMethods;
        private final Map<DexProgramClass, DexMethodSignatureSet> interfaceMethodsOfInterest = new IdentityHashMap<DexProgramClass, DexMethodSignatureSet>();

        InterfaceMethodToClassSiblingPropagator(AppView<AppInfoWithLiveness> appView, ImmediateProgramSubtypingInfo immediateSubtypingInfo, ProgramMethodSet classRootMethods, ProgramMethodSet interfaceRootMethods) {
            super(appView, immediateSubtypingInfo);
            this.classRootMethods = classRootMethods;
            for (ProgramMethod method : interfaceRootMethods) {
                this.interfaceMethodsOfInterest.computeIfAbsent(method.getHolder(), MapUtils.ignoreKey(DexMethodSignatureSet::create)).add(method);
            }
        }

        @Override
        public void visit(DexProgramClass clazz) {
            DexMethodSignatureSet interfaceMethodsOfInterestForClass = this.interfaceMethodsOfInterest.computeIfAbsent(clazz, MapUtils.ignoreKey(DexMethodSignatureSet::create));
            this.immediateSubtypingInfo.forEachImmediateProgramSuperClass(clazz, superclass -> interfaceMethodsOfInterestForClass.addAll(this.interfaceMethodsOfInterest.get(superclass)));
            for (DexProgramClass implementer : this.immediateSubtypingInfo.getSubclasses(clazz)) {
                if (implementer.isInterface()) continue;
                for (DexMethodSignature interfaceMethod : interfaceMethodsOfInterestForClass) {
                    ProgramMethod resolvedMethod;
                    MethodResolutionResult.SingleResolutionResult resolutionResult = ((AppInfoWithLiveness)this.appView.appInfo()).resolveMethodOnClass(interfaceMethod, (DexClass)implementer).asSingleResolution();
                    if (resolutionResult == null || !resolutionResult.getResolvedHolder().isProgramClass() || (resolvedMethod = resolutionResult.getResolvedProgramMethod()).getHolder().isInterface() || resolvedMethod.getHolder() == implementer) continue;
                    this.classRootMethods.add(resolvedMethod);
                }
            }
        }

        @Override
        public void prune(DexProgramClass clazz) {
            this.interfaceMethodsOfInterest.remove(clazz);
        }

        @Override
        public boolean isRoot(DexProgramClass clazz) {
            return clazz.isInterface() && super.isRoot(clazz);
        }

        @Override
        public void forEachSubClass(DexProgramClass clazz, Consumer<DexProgramClass> consumer) {
            for (DexProgramClass subclass : this.immediateSubtypingInfo.getSubclasses(clazz)) {
                if (!subclass.isInterface()) continue;
                consumer.accept(subclass);
            }
        }
    }
}

