/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils.collections;

import com.android.tools.r8.utils.collections.MutableBidirectionalManyToOneMap;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public class BidirectionalManyToOneHashMap<K, V>
implements MutableBidirectionalManyToOneMap<K, V> {
    private final Map<K, V> backing;
    private final Map<V, Set<K>> inverse;

    public static <K, V> BidirectionalManyToOneHashMap<K, V> newIdentityHashMap() {
        return new BidirectionalManyToOneHashMap(new IdentityHashMap(), new IdentityHashMap());
    }

    public static <K, V> BidirectionalManyToOneHashMap<K, V> newLinkedHashMap() {
        return new BidirectionalManyToOneHashMap(new LinkedHashMap(), new LinkedHashMap());
    }

    protected BidirectionalManyToOneHashMap(Map<K, V> backing, Map<V, Set<K>> inverse) {
        this.backing = backing;
        this.inverse = inverse;
    }

    @Override
    public void clear() {
        this.backing.clear();
        this.inverse.clear();
    }

    @Override
    public boolean containsKey(K key) {
        return this.backing.containsKey(key);
    }

    @Override
    public boolean containsValue(V value) {
        return this.inverse.containsKey(value);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> consumer) {
        this.backing.forEach(consumer);
    }

    @Override
    public void forEachKey(Consumer<? super K> consumer) {
        this.backing.keySet().forEach(consumer);
    }

    @Override
    public void forEachManyToOneMapping(BiConsumer<? super Set<K>, V> consumer) {
        this.inverse.forEach((value, keys2) -> consumer.accept((Object)keys2, (Object)value));
    }

    @Override
    public void forEachValue(Consumer<? super V> consumer) {
        this.inverse.keySet().forEach(consumer);
    }

    @Override
    public V get(Object key) {
        return this.backing.get(key);
    }

    @Override
    public V getOrDefault(Object key, V value) {
        return this.backing.getOrDefault(key, value);
    }

    @Override
    public Map<K, V> getForwardMap() {
        return this.backing;
    }

    @Override
    public Set<K> keySet() {
        return this.backing.keySet();
    }

    @Override
    public Set<K> getKeys(V value) {
        return this.inverse.getOrDefault(value, Collections.emptySet());
    }

    @Override
    public Set<V> getValues(K key) {
        V value = this.get(key);
        return value != null ? Collections.singleton(value) : Collections.emptySet();
    }

    @Override
    public boolean isEmpty() {
        return this.backing.isEmpty();
    }

    @Override
    public V remove(K key) {
        V value = this.backing.remove(key);
        if (value != null) {
            Set<K> keys2 = this.inverse.get(value);
            keys2.remove(key);
            if (keys2.isEmpty()) {
                this.inverse.remove(value);
            }
        }
        return value;
    }

    @Override
    public void removeAll(Iterable<K> keys2) {
        keys2.forEach(this::remove);
    }

    @Override
    public Set<K> removeValue(V value) {
        Set<K> keys2 = this.inverse.remove(value);
        if (keys2 == null) {
            return Collections.emptySet();
        }
        for (K key : keys2) {
            V removedValue = this.backing.remove(key);
            assert (removedValue == value);
        }
        return keys2;
    }

    @Override
    public V put(K key, V value) {
        V old = this.remove(key);
        this.backing.put(key, value);
        this.inverse.computeIfAbsent((Set)value, (Function<Set, Set<Object>>)((Function<Object, Set>)ignore -> new LinkedHashSet())).add(key);
        return old;
    }

    @Override
    public void put(Iterable<K> keys2, V value) {
        keys2.forEach((? super T key) -> this.put(key, value));
    }

    @Override
    public Set<V> values() {
        return this.inverse.keySet();
    }
}

