/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils.collections;

import com.android.tools.r8.utils.collections.MutableBidirectionalOneToManyMap;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class BidirectionalOneToManyHashMap<K, V>
implements MutableBidirectionalOneToManyMap<K, V> {
    private final Map<K, Set<V>> backing;
    private final Map<V, K> inverse;

    public BidirectionalOneToManyHashMap() {
        this(new IdentityHashMap(), new IdentityHashMap());
    }

    private BidirectionalOneToManyHashMap(Map<K, Set<V>> backing, Map<V, K> inverse) {
        this.backing = backing;
        this.inverse = inverse;
    }

    @Override
    public void clear() {
        this.backing.clear();
        this.inverse.clear();
    }

    @Override
    public boolean containsKey(K key) {
        return this.backing.containsKey(key);
    }

    @Override
    public boolean containsValue(V value) {
        return this.inverse.containsKey(value);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> consumer) {
        this.backing.forEach((key, values2) -> values2.forEach((? super T value) -> consumer.accept((Object)key, (Object)value)));
    }

    @Override
    public void forEachKey(Consumer<? super K> consumer) {
        this.backing.keySet().forEach(consumer);
    }

    @Override
    public void forEachOneToManyMapping(BiConsumer<K, Set<V>> consumer) {
        this.backing.forEach(consumer);
    }

    @Override
    public void forEachValue(Consumer<? super V> consumer) {
        this.inverse.keySet().forEach(consumer);
    }

    @Override
    public Set<V> get(Object key) {
        return this.backing.get(key);
    }

    @Override
    public Set<V> getOrDefault(Object key, Set<V> value) {
        return this.backing.getOrDefault(key, value);
    }

    @Override
    public K getKey(V value) {
        return this.inverse.get(value);
    }

    @Override
    public K getKeyOrDefault(V value, K defaultValue) {
        return this.inverse.getOrDefault(value, defaultValue);
    }

    @Override
    public Set<K> getKeys(V value) {
        K key = this.inverse.get(value);
        return key != null ? Collections.singleton(key) : Collections.emptySet();
    }

    @Override
    public Set<V> getValues(K key) {
        return this.getOrDefault(key, Collections.emptySet());
    }

    @Override
    public boolean isEmpty() {
        return this.backing.isEmpty();
    }

    public Set<K> keySet() {
        return this.backing.keySet();
    }

    @Override
    public Set<V> remove(K key) {
        Set<V> values2 = this.backing.remove(key);
        if (values2 == null) {
            return Collections.emptySet();
        }
        for (V value : values2) {
            K removedKey = this.inverse.remove(value);
            assert (removedKey == key);
        }
        return values2;
    }

    @Override
    public void removeAll(Iterable<K> keys2) {
        keys2.forEach(this::remove);
    }

    @Override
    public K removeValue(V value) {
        K key = this.inverse.remove(value);
        if (key != null) {
            Set<V> values2 = this.backing.get(key);
            values2.remove(value);
            if (values2.isEmpty()) {
                this.backing.remove(key);
            }
        }
        return key;
    }

    @Override
    public void put(K key, V value) {
        this.removeValue(value);
        this.backing.computeIfAbsent(key, ignore -> new LinkedHashSet()).add(value);
        this.inverse.put(value, key);
    }

    @Override
    public void put(K key, Set<V> values2) {
        values2.forEach((? super T value) -> this.put(key, value));
    }
}

