/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils.collections;

import com.android.tools.r8.com.google.common.collect.Streams;
import com.android.tools.r8.utils.collections.BidirectionalOneToManyHashMap;
import com.android.tools.r8.utils.collections.MutableBidirectionalOneToManyRepresentativeMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public class BidirectionalOneToManyRepresentativeHashMap<K, V>
extends BidirectionalOneToManyHashMap<K, V>
implements MutableBidirectionalOneToManyRepresentativeMap<K, V> {
    private final Map<K, V> representatives = new IdentityHashMap();

    @Override
    public void clear() {
        super.clear();
        this.representatives.clear();
    }

    @Override
    public boolean hasExplicitRepresentativeKey(V value) {
        assert (this.containsValue(value));
        return true;
    }

    @Override
    public K getRepresentativeKey(V value) {
        return this.getKey(value);
    }

    @Override
    public V getRepresentativeValue(K key) {
        Set values2 = this.getValues(key);
        if (!values2.isEmpty()) {
            return values2.size() == 1 ? values2.iterator().next() : this.representatives.get(key);
        }
        return null;
    }

    @Override
    public Set<V> remove(K key) {
        Set values2 = super.remove(key);
        this.removeRepresentativeFor(key);
        return values2;
    }

    @Override
    public void removeAll(Iterable<K> keys2) {
        super.removeAll(keys2);
        assert (Streams.stream(keys2).noneMatch(this.representatives::containsKey));
    }

    @Override
    public V removeRepresentativeFor(K key) {
        return this.representatives.remove(key);
    }

    @Override
    public K removeValue(V value) {
        Object key = super.removeValue(value);
        if (this.getValues(key).size() <= 1 || this.getRepresentativeValue(key) == value) {
            this.removeRepresentativeFor(key);
        }
        return key;
    }

    @Override
    public void setRepresentative(K key, V representative) {
        assert (this.getValues(key).size() > 1);
        assert (this.getValues(key).contains(representative));
        this.representatives.put(key, representative);
    }
}

