/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils.collections;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.ProgramField;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class ProgramFieldSet
implements Iterable<ProgramField> {
    private static final ProgramFieldSet EMPTY = new ProgramFieldSet(ImmutableMap.of());
    private Map<DexField, ProgramField> backing;

    private ProgramFieldSet(Map<DexField, ProgramField> backing) {
        this.backing = backing;
    }

    public static ProgramFieldSet create() {
        return new ProgramFieldSet(new IdentityHashMap<DexField, ProgramField>());
    }

    public static ProgramFieldSet empty() {
        return EMPTY;
    }

    public boolean add(ProgramField field) {
        ProgramField existing = this.backing.put((DexField)field.getReference(), field);
        assert (existing == null || existing.isStructurallyEqualTo(field));
        return existing == null;
    }

    public void addAll(Iterable<ProgramField> fields) {
        fields.forEach(this::add);
    }

    public void addAll(ProgramFieldSet fields) {
        this.backing.putAll(fields.backing);
    }

    public boolean createAndAdd(DexProgramClass clazz, DexEncodedField definition) {
        return this.add(new ProgramField(clazz, definition));
    }

    public boolean contains(DexEncodedField field) {
        return this.backing.containsKey(field.getReference());
    }

    public boolean contains(ProgramField field) {
        return this.backing.containsKey(field.getReference());
    }

    public void clear() {
        this.backing.clear();
    }

    public boolean isEmpty() {
        return this.backing.isEmpty();
    }

    @Override
    public Iterator<ProgramField> iterator() {
        return this.backing.values().iterator();
    }

    public boolean remove(DexField field) {
        ProgramField existing = this.backing.remove(field);
        return existing != null;
    }

    public boolean remove(DexEncodedField field) {
        return this.remove((DexField)field.getReference());
    }

    public int size() {
        return this.backing.size();
    }

    public Stream<ProgramField> stream() {
        return this.backing.values().stream();
    }

    public Set<DexEncodedField> toDefinitionSet() {
        assert (this.backing instanceof IdentityHashMap);
        Set<DexEncodedField> definitions = Sets.newIdentityHashSet();
        this.forEach(field -> definitions.add((DexEncodedField)field.getDefinition()));
        return definitions;
    }
}

