/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils.collections;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.graph.ProgramMember;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class ProgramMemberMap<K extends ProgramMember<?, ?>, V> {
    private final Map<Equivalence.Wrapper<K>, V> backing;

    ProgramMemberMap(Supplier<Map<Equivalence.Wrapper<K>, V>> backingFactory) {
        this.backing = backingFactory.get();
    }

    ProgramMemberMap(Map<Equivalence.Wrapper<K>, V> backing) {
        this.backing = backing;
    }

    public void clear() {
        this.backing.clear();
    }

    public V compute(K member, BiFunction<K, V, V> fn) {
        return (V)this.backing.compute(this.wrap(member), (? super K key, ? super V value) -> fn.apply(member, value));
    }

    public V computeIfAbsent(K member, Function<K, V> fn) {
        return (V)this.backing.computeIfAbsent(this.wrap(member), (? super K key) -> fn.apply((ProgramMember)key.get()));
    }

    public boolean containsKey(K member) {
        return this.backing.containsKey(this.wrap(member));
    }

    public void forEach(BiConsumer<K, V> consumer) {
        this.backing.forEach((? super K wrapper, ? super V value) -> consumer.accept((ProgramMember)wrapper.get(), value));
    }

    public V get(K member) {
        return this.backing.get(this.wrap(member));
    }

    public V getOrDefault(K member, V defaultValue) {
        return this.backing.getOrDefault(this.wrap(member), defaultValue);
    }

    public V getOrDefault(K member, Supplier<V> defaultValue) {
        V value = this.backing.get(this.wrap(member));
        return value != null ? value : defaultValue.get();
    }

    public boolean isEmpty() {
        return this.backing.isEmpty();
    }

    public V put(K member, V value) {
        Equivalence.Wrapper<K> wrapper = this.wrap(member);
        return this.backing.put(wrapper, value);
    }

    public V remove(K member) {
        return this.backing.remove(this.wrap(member));
    }

    public void removeIf(BiPredicate<K, V> predicate) {
        this.backing.entrySet().removeIf((? super E entry) -> predicate.test((ProgramMember)((Equivalence.Wrapper)entry.getKey()).get(), entry.getValue()));
    }

    abstract Equivalence.Wrapper<K> wrap(K var1);
}

