/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils.collections;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.com.google.common.collect.ConcurrentHashMultiset;
import com.android.tools.r8.com.google.common.collect.HashMultiset;
import com.android.tools.r8.com.google.common.collect.Multiset;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.utils.ProgramMethodEquivalence;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;

public class ProgramMethodMultiset {
    private final Multiset<Equivalence.Wrapper<ProgramMethod>> backing;

    private ProgramMethodMultiset(Multiset<Equivalence.Wrapper<ProgramMethod>> backing) {
        this.backing = backing;
    }

    public static ProgramMethodMultiset createConcurrent() {
        return new ProgramMethodMultiset(ConcurrentHashMultiset.create());
    }

    public static ProgramMethodMultiset createHash() {
        return new ProgramMethodMultiset(HashMultiset.create());
    }

    private static Equivalence.Wrapper<ProgramMethod> wrap(ProgramMethod method) {
        return ProgramMethodEquivalence.get().wrap(method);
    }

    public void add(ProgramMethod method) {
        this.backing.add(ProgramMethodMultiset.wrap(method));
    }

    public void createAndAdd(DexProgramClass holder, DexEncodedMethod method, int occurrences) {
        this.backing.add(ProgramMethodMultiset.wrap(new ProgramMethod(holder, method)), occurrences);
    }

    public void forEachEntry(ObjIntConsumer<ProgramMethod> consumer) {
        this.backing.forEachEntry((? super E wrapper, int occurrences) -> consumer.accept((ProgramMethod)wrapper.get(), occurrences));
    }

    public boolean removeIf(Predicate<ProgramMethod> predicate) {
        return this.backing.removeIf((? super E wrapper) -> predicate.test((ProgramMethod)wrapper.get()));
    }

    public int size() {
        return this.backing.size();
    }
}

