/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils.collections;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.utils.ForEachable;
import com.android.tools.r8.utils.collections.DexClassAndMethodSetBase;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class ProgramMethodSet
extends DexClassAndMethodSetBase<ProgramMethod> {
    private static final ProgramMethodSet EMPTY = new ProgramMethodSet((Supplier<? extends Map<DexMethod, ProgramMethod>>)((Supplier<Map>)ImmutableMap::of));

    protected ProgramMethodSet(Supplier<? extends Map<DexMethod, ProgramMethod>> backingFactory) {
        super(backingFactory);
    }

    protected ProgramMethodSet(Supplier<? extends Map<DexMethod, ProgramMethod>> backingFactory, Map<DexMethod, ProgramMethod> backing) {
        super(backingFactory, backing);
    }

    public static ProgramMethodSet create() {
        return new ProgramMethodSet((Supplier<? extends Map<DexMethod, ProgramMethod>>)((Supplier<Map>)IdentityHashMap::new));
    }

    public static ProgramMethodSet create(int capacity) {
        return new ProgramMethodSet((Supplier<? extends Map<DexMethod, ProgramMethod>>)((Supplier<Map>)IdentityHashMap::new), (Map<DexMethod, ProgramMethod>)new IdentityHashMap<DexMethod, ProgramMethod>(capacity));
    }

    public static ProgramMethodSet create(ProgramMethod element) {
        ProgramMethodSet result = ProgramMethodSet.create();
        result.add(element);
        return result;
    }

    public static ProgramMethodSet create(ForEachable<ProgramMethod> methods) {
        ProgramMethodSet result = ProgramMethodSet.create();
        methods.forEach(result::add);
        return result;
    }

    public static ProgramMethodSet create(ProgramMethodSet methodSet) {
        ProgramMethodSet newMethodSet = ProgramMethodSet.create();
        newMethodSet.addAll(methodSet);
        return newMethodSet;
    }

    public static ProgramMethodSet createConcurrent() {
        return new ProgramMethodSet((Supplier<? extends Map<DexMethod, ProgramMethod>>)((Supplier<Map>)ConcurrentHashMap::new));
    }

    public static ProgramMethodSet createLinked() {
        return new ProgramMethodSet((Supplier<? extends Map<DexMethod, ProgramMethod>>)((Supplier<Map>)LinkedHashMap::new));
    }

    public static ProgramMethodSet empty() {
        return EMPTY;
    }

    public void addAll(ProgramMethodSet methods) {
        this.backing.putAll(methods.backing);
    }

    public boolean createAndAdd(DexProgramClass clazz, DexEncodedMethod definition) {
        return this.add(new ProgramMethod(clazz, definition));
    }

    public ProgramMethodSet rewrittenWithLens(DexDefinitionSupplier definitions, GraphLens lens) {
        ProgramMethodSet rewritten = new ProgramMethodSet(this.backingFactory);
        this.forEach(method -> {
            ProgramMethod newMethod = lens.mapProgramMethod((ProgramMethod)method, definitions);
            if (newMethod != null) {
                rewritten.add(newMethod);
            }
        });
        return rewritten;
    }
}

