/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils.collections;

import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.utils.ComparatorUtils;
import com.android.tools.r8.utils.ForEachable;
import com.android.tools.r8.utils.ForEachableUtils;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import com.android.tools.r8.utils.structural.StructuralItem;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class SortedProgramMethodSet
extends ProgramMethodSet {
    private static final SortedProgramMethodSet EMPTY = new SortedProgramMethodSet(() -> new TreeMap(ComparatorUtils.unreachableComparator()));

    private SortedProgramMethodSet(Supplier<SortedMap<DexMethod, ProgramMethod>> backingFactory) {
        super((Supplier<? extends Map<DexMethod, ProgramMethod>>)backingFactory);
    }

    public static SortedProgramMethodSet create() {
        return SortedProgramMethodSet.create(ForEachableUtils.empty());
    }

    public static SortedProgramMethodSet create(ProgramMethod method) {
        SortedProgramMethodSet result = SortedProgramMethodSet.create();
        result.add(method);
        return result;
    }

    public static SortedProgramMethodSet create(ForEachable<ProgramMethod> methods) {
        SortedProgramMethodSet result = new SortedProgramMethodSet(() -> new TreeMap(StructuralItem::compareTo));
        methods.forEach(result::add);
        return result;
    }

    public static SortedProgramMethodSet createConcurrent() {
        return new SortedProgramMethodSet(() -> new ConcurrentSkipListMap(StructuralItem::compareTo));
    }

    public static SortedProgramMethodSet empty() {
        return EMPTY;
    }

    @Override
    public SortedProgramMethodSet rewrittenWithLens(DexDefinitionSupplier definitions, GraphLens lens) {
        return SortedProgramMethodSet.create((Consumer<ProgramMethod> consumer) -> this.forEach(method -> consumer.accept(lens.mapProgramMethod((ProgramMethod)method, definitions))));
    }

    @Override
    public Set<DexEncodedMethod> toDefinitionSet() {
        Comparator comparator = (x, y) -> ((DexMethod)x.getReference()).compareTo((DexMethod)y.getReference());
        TreeSet<DexEncodedMethod> definitions = new TreeSet<DexEncodedMethod>(comparator);
        this.forEach(method -> definitions.add((DexEncodedMethod)method.getDefinition()));
        return definitions;
    }
}

