/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils.structural;

import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.utils.structural.CompareToVisitor;
import com.android.tools.r8.utils.structural.StructuralItem;
import com.android.tools.r8.utils.structural.StructuralMapping;
import com.android.tools.r8.utils.structural.StructuralSpecification;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public abstract class CompareToVisitorBase
extends CompareToVisitor {
    private static boolean DEBUG = false;

    public static int debug(int order) {
        if (DEBUG && order != 0) {
            return order;
        }
        return order;
    }

    @Override
    public final int visitBool(boolean value1, boolean value2) {
        return CompareToVisitorBase.debug(Boolean.compare(value1, value2));
    }

    @Override
    public final int visitInt(int value1, int value2) {
        return CompareToVisitorBase.debug(Integer.compare(value1, value2));
    }

    @Override
    public int visitLong(long value1, long value2) {
        return CompareToVisitorBase.debug(Long.compare(value1, value2));
    }

    @Override
    public int visitFloat(float value1, float value2) {
        return CompareToVisitorBase.debug(Float.compare(value1, value2));
    }

    @Override
    public int visitDouble(double value1, double value2) {
        return CompareToVisitorBase.debug(Double.compare(value1, value2));
    }

    @Override
    public <S> int visitItemIterator(Iterator<S> it1, Iterator<S> it2, StructuralItem.CompareToAccept<S> compareToAccept) {
        int order = 0;
        while (order == 0 && it1.hasNext() && it2.hasNext()) {
            order = compareToAccept.acceptCompareTo(it1.next(), it2.next(), this);
        }
        if (order == 0) {
            order = this.visitBool(it1.hasNext(), it2.hasNext());
        }
        return CompareToVisitorBase.debug(order);
    }

    @Override
    public int visitDexString(DexString string1, DexString string2) {
        return CompareToVisitorBase.debug(string1.compareTo(string2));
    }

    @Override
    public int visitDexReference(DexReference reference1, DexReference reference2) {
        int order = this.visitInt(reference1.referenceTypeOrder(), reference2.referenceTypeOrder());
        if (order == 0) {
            assert (reference1.getClass() == reference2.getClass());
            order = reference1.isDexType() ? this.visitDexType(reference1.asDexType(), reference2.asDexType()) : (reference1.isDexField() ? this.visitDexField(reference1.asDexField(), reference2.asDexField()) : this.visitDexMethod(reference1.asDexMethod(), reference2.asDexMethod()));
        }
        return CompareToVisitorBase.debug(order);
    }

    @Override
    public final <S> int visit(S item1, S item2, Comparator<S> comparator) {
        return CompareToVisitorBase.debug(comparator.compare(item1, item2));
    }

    @Override
    public final <S> int visit(S item1, S item2, StructuralMapping<S> accept) {
        ItemSpecification itemVisitor = new ItemSpecification(item1, item2, this);
        accept.apply(itemVisitor);
        return CompareToVisitorBase.debug(itemVisitor.order);
    }

    private static class ItemSpecification<T>
    extends StructuralSpecification<T, ItemSpecification<T>> {
        private final CompareToVisitorBase parent;
        private final T item1;
        private final T item2;
        private int order = 0;

        private ItemSpecification(T item1, T item2, CompareToVisitorBase parent) {
            this.item1 = item1;
            this.item2 = item2;
            this.parent = parent;
        }

        @Override
        ItemSpecification<T> self() {
            return this;
        }

        @Override
        public ItemSpecification<T> withAssert(Predicate<T> predicate) {
            assert (predicate.test(this.item1));
            assert (predicate.test(this.item2));
            return this;
        }

        @Override
        public ItemSpecification<T> withBool(Predicate<T> getter) {
            if (this.order == 0) {
                this.order = this.parent.visitBool(getter.test(this.item1), getter.test(this.item2));
            }
            return this;
        }

        @Override
        public ItemSpecification<T> withInt(ToIntFunction<T> getter) {
            if (this.order == 0) {
                this.order = this.parent.visitInt(getter.applyAsInt(this.item1), getter.applyAsInt(this.item2));
            }
            return this;
        }

        @Override
        public ItemSpecification<T> withLong(ToLongFunction<T> getter) {
            if (this.order == 0) {
                this.order = this.parent.visitLong(getter.applyAsLong(this.item1), getter.applyAsLong(this.item2));
            }
            return this;
        }

        @Override
        public ItemSpecification<T> withDouble(ToDoubleFunction<T> getter) {
            if (this.order == 0) {
                this.order = this.parent.visitDouble(getter.applyAsDouble(this.item1), getter.applyAsDouble(this.item2));
            }
            return this;
        }

        @Override
        public ItemSpecification<T> withIntArray(Function<T, int[]> getter) {
            if (this.order == 0) {
                int[] is1 = getter.apply(this.item1);
                int[] is2 = getter.apply(this.item2);
                int minLength = Math.min(is1.length, is2.length);
                for (int i = 0; i < minLength && this.order == 0; ++i) {
                    this.order = this.parent.visitInt(is1[i], is2[i]);
                }
                if (this.order == 0) {
                    this.order = this.parent.visitInt(is1.length, is2.length);
                }
            }
            return this;
        }

        @Override
        public ItemSpecification<T> withShortArray(Function<T, short[]> getter) {
            if (this.order == 0) {
                short[] is1 = getter.apply(this.item1);
                short[] is2 = getter.apply(this.item2);
                int minLength = Math.min(is1.length, is2.length);
                for (int i = 0; i < minLength && this.order == 0; ++i) {
                    this.order = this.parent.visitInt(is1[i], is2[i]);
                }
                if (this.order == 0) {
                    this.order = this.parent.visitInt(is1.length, is2.length);
                }
            }
            return this;
        }

        @Override
        public <S> ItemSpecification<T> withConditionalCustomItem(Predicate<T> predicate, Function<T, S> getter, StructuralItem.CompareToAccept<S> compare, StructuralItem.HashingAccept<S> hasher) {
            if (this.order == 0) {
                boolean test1 = predicate.test(this.item1);
                boolean test2 = predicate.test(this.item2);
                this.order = test1 && test2 ? compare.acceptCompareTo(getter.apply(this.item1), getter.apply(this.item2), this.parent) : this.parent.visitBool(test1, test2);
            }
            return this;
        }

        @Override
        protected <S> ItemSpecification<T> withCustomItemIterator(Function<T, Iterator<S>> getter, StructuralItem.CompareToAccept<S> compare, StructuralItem.HashingAccept<S> hasher) {
            if (this.order == 0) {
                this.order = this.parent.visitItemIterator(getter.apply(this.item1), getter.apply(this.item2), compare);
            }
            return this;
        }

        @Override
        public ItemSpecification<T> withDexReference(Function<T, DexReference> getter) {
            if (this.order == 0) {
                this.order = this.parent.visitDexReference(getter.apply(this.item1), getter.apply(this.item2));
            }
            return this;
        }
    }
}

