/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils.structural;

import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.utils.structural.StructuralItem;
import com.android.tools.r8.utils.structural.StructuralMapping;
import com.android.tools.r8.utils.structural.StructuralSpecification;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public class HashCodeVisitor<T>
extends StructuralSpecification<T, HashCodeVisitor<T>> {
    private final T item;
    private int hashCode = 0;

    public static <T extends StructuralItem<T>> int run(T item) {
        return HashCodeVisitor.run(item, item.getStructuralMapping());
    }

    public static <T> int run(T item, StructuralMapping<T> visit) {
        HashCodeVisitor<T> visitor = new HashCodeVisitor<T>(item);
        visit.apply(visitor);
        return visitor.hashCode;
    }

    private HashCodeVisitor(T item) {
        this.item = item;
    }

    private HashCodeVisitor<T> amend(int value) {
        this.hashCode = 31 * this.hashCode + value;
        return this;
    }

    @Override
    HashCodeVisitor<T> self() {
        return this;
    }

    @Override
    public HashCodeVisitor<T> withAssert(Predicate<T> predicate) {
        assert (predicate.test(this.item));
        return this;
    }

    @Override
    public HashCodeVisitor<T> withBool(Predicate<T> getter) {
        return this.amend(Boolean.hashCode(getter.test(this.item)));
    }

    @Override
    public HashCodeVisitor<T> withInt(ToIntFunction<T> getter) {
        return this.amend(Integer.hashCode(getter.applyAsInt(this.item)));
    }

    @Override
    public HashCodeVisitor<T> withLong(ToLongFunction<T> getter) {
        return this.amend(Long.hashCode(getter.applyAsLong(this.item)));
    }

    @Override
    public HashCodeVisitor<T> withDouble(ToDoubleFunction<T> getter) {
        return this.amend(Double.hashCode(getter.applyAsDouble(this.item)));
    }

    @Override
    public HashCodeVisitor<T> withIntArray(Function<T, int[]> getter) {
        return this.amend(Arrays.hashCode(getter.apply(this.item)));
    }

    @Override
    public HashCodeVisitor<T> withShortArray(Function<T, short[]> getter) {
        return this.amend(Arrays.hashCode(getter.apply(this.item)));
    }

    @Override
    protected <S> HashCodeVisitor<T> withConditionalCustomItem(Predicate<T> predicate, Function<T, S> getter, StructuralItem.CompareToAccept<S> compare, StructuralItem.HashingAccept<S> hasher) {
        if (predicate.test(this.item)) {
            return this.amend(getter.apply(this.item).hashCode());
        }
        return this.amend(1);
    }

    @Override
    protected <S> HashCodeVisitor<T> withCustomItemIterator(Function<T, Iterator<S>> getter, StructuralItem.CompareToAccept<S> compare, StructuralItem.HashingAccept<S> hasher) {
        Iterator<S> it = getter.apply(this.item);
        while (it.hasNext()) {
            this.amend(it.next().hashCode());
        }
        return this;
    }

    @Override
    public HashCodeVisitor<T> withDexReference(Function<T, DexReference> getter) {
        return this.amend(getter.apply(this.item).hashCode());
    }
}

