/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils.structural;

import com.android.tools.r8.com.google.common.hash.Hasher;
import com.android.tools.r8.com.google.common.hash.Hashing;

public interface HasherWrapper {
    public static HasherWrapper sha256Hasher() {
        return new HasherWrapped(Hashing.sha256().newHasher());
    }

    public static HasherWrapper murmur3128Hasher() {
        return new HasherWrapped(Hashing.murmur3_128().newHasher());
    }

    public void putBoolean(boolean var1);

    public void putInt(int var1);

    public void putFloat(float var1);

    public void putLong(long var1);

    public void putDouble(double var1);

    public void putBytes(byte[] var1);

    public String hashCodeAsString();

    public <T> T hash();

    public static class HasherWrapped
    implements HasherWrapper {
        private final Hasher hasher;

        public HasherWrapped(Hasher hasher) {
            this.hasher = hasher;
        }

        @Override
        public void putBoolean(boolean value) {
            this.hasher.putBoolean(value);
        }

        @Override
        public void putInt(int value) {
            this.hasher.putInt(value);
        }

        @Override
        public void putFloat(float value) {
            this.hasher.putFloat(value);
        }

        @Override
        public void putLong(long value) {
            this.hasher.putLong(value);
        }

        @Override
        public void putDouble(double value) {
            this.hasher.putDouble(value);
        }

        @Override
        public void putBytes(byte[] content) {
            this.hasher.putBytes(content);
        }

        @Override
        public <T> T hash() {
            return (T)this.hasher.hash();
        }

        @Override
        public String hashCodeAsString() {
            return this.hasher.hash().toString();
        }
    }
}

