/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils.structural;

import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.utils.structural.StructuralItem;
import com.android.tools.r8.utils.structural.StructuralMapping;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public abstract class HashingVisitor {
    public abstract void visitBool(boolean var1);

    public abstract void visitInt(int var1);

    public abstract void visitFloat(float var1);

    public abstract void visitLong(long var1);

    public abstract void visitDouble(double var1);

    protected abstract <S> void visitItemIterator(Iterator<S> var1, StructuralItem.HashingAccept<S> var2);

    public final <S extends StructuralItem<S>> void visitItemArray(S[] items) {
        this.visitItemCollection(Arrays.asList(items));
    }

    public final <S extends StructuralItem<S>> void visitItemCollection(Collection<S> items) {
        this.visitItemIterator(items.iterator(), StructuralItem::acceptHashing);
    }

    public abstract void visitDexString(DexString var1);

    public abstract void visitDexType(DexType var1);

    public void visitDexField(DexField field) {
        this.visit(field, field.getStructuralMapping());
    }

    public void visitDexMethod(DexMethod method) {
        this.visit(method, method.getStructuralMapping());
    }

    public void visitDexReference(DexReference reference) {
        reference.accept(this::visitDexType, this::visitDexField, this::visitDexMethod);
    }

    public abstract <S> void visit(S var1, StructuralMapping<S> var2);
}

