/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils.structural;

import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.utils.structural.StructuralAcceptor;
import com.android.tools.r8.utils.structural.StructuralItem;
import com.android.tools.r8.utils.structural.StructuralMapping;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public abstract class StructuralSpecification<T, V extends StructuralSpecification<T, V>> {
    abstract V self();

    public final V withSpec(StructuralMapping<T> spec) {
        spec.apply(this);
        return this.self();
    }

    @Deprecated
    public final <S> V withCustomItem(Function<T, S> getter, StructuralItem.CompareToAccept<S> compare, StructuralItem.HashingAccept<S> hasher) {
        return this.withConditionalCustomItem(t -> true, getter, compare, hasher);
    }

    public final <S> V withCustomItem(Function<T, S> getter, StructuralAcceptor<S> acceptor) {
        return this.withCustomItem(getter, acceptor, acceptor);
    }

    protected abstract <S> V withConditionalCustomItem(Predicate<T> var1, Function<T, S> var2, StructuralItem.CompareToAccept<S> var3, StructuralItem.HashingAccept<S> var4);

    protected abstract <S> V withCustomItemIterator(Function<T, Iterator<S>> var1, StructuralItem.CompareToAccept<S> var2, StructuralItem.HashingAccept<S> var3);

    public final <S> V withCustomItemCollection(Function<T, Collection<S>> getter, StructuralAcceptor<S> acceptor) {
        return this.withCustomItemIterator(getter.andThen(Collection::iterator), acceptor, acceptor);
    }

    public final <S extends StructuralItem<S>> V withItem(Function<T, S> getter) {
        return this.withConditionalItem(t -> true, getter);
    }

    public final <S extends StructuralItem<S>> V withNullableItem(Function<T, S> getter) {
        return this.withConditionalItem(s2 -> getter.apply(s2) != null, getter);
    }

    public final <S extends StructuralItem<S>> V withConditionalItem(Predicate<T> predicate, Function<T, S> getter) {
        return this.withConditionalCustomItem(predicate, getter, StructuralItem::acceptCompareTo, StructuralItem::acceptHashing);
    }

    public final <S extends StructuralItem<S>> V withItemIterator(Function<T, Iterator<S>> getter) {
        return this.withCustomItemIterator(getter, StructuralItem::acceptCompareTo, StructuralItem::acceptHashing);
    }

    public final <S extends StructuralItem<S>> V withItemCollection(Function<T, Collection<S>> getter) {
        return this.withItemIterator(getter.andThen(Collection::iterator));
    }

    public final <S extends StructuralItem<S>> V withItemArray(Function<T, S[]> getter) {
        return this.withItemIterator(getter.andThen(a -> Arrays.asList(a).iterator()));
    }

    public final <S extends StructuralItem<S>> V withItemArrayAllowingNullMembers(Function<T, S[]> getter) {
        return this.withCustomItemIterator(getter.andThen(a -> Arrays.asList(a).iterator()), (a, b, visitor) -> {
            if (a == null || b == null) {
                return visitor.visitBool(a != null, b != null);
            }
            return a.acceptCompareTo(b, visitor);
        }, (a, visitor) -> {
            if (a == null) {
                visitor.visitInt(0);
            } else {
                a.acceptHashing(visitor);
            }
        });
    }

    public abstract V withAssert(Predicate<T> var1);

    public abstract V withBool(Predicate<T> var1);

    public abstract V withInt(ToIntFunction<T> var1);

    public abstract V withLong(ToLongFunction<T> var1);

    public abstract V withDouble(ToDoubleFunction<T> var1);

    public abstract V withIntArray(Function<T, int[]> var1);

    public abstract V withShortArray(Function<T, short[]> var1);

    public abstract V withDexReference(Function<T, DexReference> var1);
}

